/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.misc;

import com.sun.xml.ws.api.ha.HaInfo;
import com.sun.xml.ws.api.ha.HighAvailabilityProvider;
import com.sun.xml.ws.commons.ha.HaContext;
import com.sun.xml.ws.commons.ha.StickyKey;
import com.sun.xml.wss.NonceManager;
import com.sun.xml.wss.logging.LogStringsMessages;
import java.io.Serializable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HANonceManager
extends NonceManager {
    private Long maxNonceAge;
    private BackingStore<StickyKey, HAPojo> backingStore = null;
    private final ScheduledExecutorService singleThreadScheduledExecutor = Executors.newSingleThreadScheduledExecutor();
    private boolean isScheduled = false;

    public HANonceManager(long maxNonceAge) {
        this.maxNonceAge = maxNonceAge;
        try {
            BackingStoreConfiguration bsConfig = HighAvailabilityProvider.INSTANCE.initBackingStoreConfiguration("HANonceManagerStore", StickyKey.class, HAPojo.class);
            bsConfig.getVendorSpecificSettings().put("max.idle.timeout.in.seconds", maxNonceAge / 1000L);
            bsConfig.setClassLoader(ClassLoader.getSystemClassLoader());
            bsConfig.getVendorSpecificSettings().put("start.gms", true);
            BackingStoreFactory bsFactory = HighAvailabilityProvider.INSTANCE.getBackingStoreFactory(HighAvailabilityProvider.StoreType.IN_MEMORY);
            this.backingStore = bsFactory.createBackingStore(bsConfig);
        }
        catch (BackingStoreException ex) {
            LOGGER.log(Level.SEVERE, LogStringsMessages.WSS_0826_ERROR_INITIALIZE_BACKINGSTORE(), ex);
        }
    }

    public HANonceManager(BackingStore<StickyKey, HAPojo> backingStore, long maxNonceAge) {
        this.backingStore = backingStore;
        this.maxNonceAge = maxNonceAge;
    }

    @Override
    public boolean validateNonce(String nonce, String created) throws NonceManager.NonceException {
        if (!this.isScheduled) {
            this.singleThreadScheduledExecutor.scheduleAtFixedRate(new nonceCleanupTask(), this.maxNonceAge, this.maxNonceAge, TimeUnit.MILLISECONDS);
            this.isScheduled = true;
        }
        byte[] data = created.getBytes();
        HAPojo pojo = new HAPojo();
        pojo.setData(data);
        try {
            HAPojo value = null;
            try {
                value = (HAPojo)HighAvailabilityProvider.loadFrom(this.backingStore, (Serializable)new StickyKey((Serializable)((Object)nonce)), null);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, " exception during load command ", ex);
            }
            if (value != null) {
                String message = "Nonce Repeated : Nonce Cache already contains the nonce value :" + nonce;
                LOGGER.log(Level.WARNING, LogStringsMessages.WSS_0815_NONCE_REPEATED_ERROR(nonce));
                throw new NonceManager.NonceException(message);
            }
            HaInfo haInfo = HaContext.currentHaInfo();
            if (haInfo != null) {
                HighAvailabilityProvider.saveTo(this.backingStore, (Serializable)new StickyKey((Serializable)((Object)nonce), haInfo.getKey()), (Serializable)pojo, (boolean)true);
            } else {
                StickyKey stickyKey = new StickyKey((Serializable)((Object)nonce));
                String replicaId = HighAvailabilityProvider.saveTo(this.backingStore, (Serializable)stickyKey, (Serializable)pojo, (boolean)true);
                HaContext.updateHaInfo((HaInfo)new HaInfo(stickyKey.getHashKey(), replicaId, false));
            }
            LOGGER.log(Level.INFO, " nonce {0} saved ", nonce);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, LogStringsMessages.WSS_0825_ERROR_VALIDATE_NONCE(), ex);
            return false;
        }
        return true;
    }

    public void remove(String key) throws BackingStoreException {
        this.backingStore.remove((Serializable)new StickyKey((Serializable)((Object)key)));
    }

    public static class HAPojo
    implements Serializable {
        byte[] data;

        public void setData(byte[] data) {
            this.data = data;
        }

        public byte[] getData() {
            return this.data;
        }
    }

    public class nonceCleanupTask
    implements Runnable {
        public void run() {
            try {
                int removed = HANonceManager.this.backingStore.removeExpired(HANonceManager.this.maxNonceAge.longValue());
                LOGGER.log(Level.INFO, " removed {0} expired entries from backing store ", removed);
            }
            catch (BackingStoreException ex) {
                LOGGER.log(Level.SEVERE, LogStringsMessages.WSS_0827_ERROR_REMOVING_EXPIRED_ENTRIES(), ex);
            }
        }
    }
}

