/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.kerberos;

import com.sun.security.auth.callback.TextCallbackHandler;
import com.sun.xml.ws.security.impl.kerberos.KerberosContext;
import com.sun.xml.ws.security.jgss.XWSSProvider;
import com.sun.xml.wss.XWSSecurityException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.util.Iterator;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.security.krb5.EncryptionKey;

public class KerberosLogin {
    public KerberosContext login(String loginModule, String servicePrincipal, boolean credDeleg) throws XWSSecurityException {
        KerberosContext krbContext = new KerberosContext();
        LoginContext lc = null;
        try {
            lc = new LoginContext(loginModule, new TextCallbackHandler());
        }
        catch (LoginException le) {
            throw new XWSSecurityException("Cannot create LoginContext. ", (Throwable)le);
        }
        catch (SecurityException se) {
            throw new XWSSecurityException("Cannot create LoginContext. ", (Throwable)se);
        }
        try {
            lc.login();
        }
        catch (AccountExpiredException aee) {
            throw new XWSSecurityException("Your Kerberos account has expired.", (Throwable)aee);
        }
        catch (CredentialExpiredException cee) {
            throw new XWSSecurityException("Your credentials have expired.", (Throwable)cee);
        }
        catch (FailedLoginException fle) {
            throw new XWSSecurityException("Authentication Failed", (Throwable)fle);
        }
        catch (Exception e) {
            throw new XWSSecurityException("Unexpected Exception in Kerberos login - unable to continue", (Throwable)e);
        }
        try {
            Subject loginSubject = lc.getSubject();
            Subject.doAsPrivileged(loginSubject, new KerberosClientSetupAction(servicePrincipal, credDeleg), null);
            Set<Object> setPubCred = loginSubject.getPublicCredentials();
            Iterator<Object> iter1 = setPubCred.iterator();
            GSSContext gssContext = null;
            while (iter1.hasNext()) {
                Object pubObject = iter1.next();
                if (pubObject instanceof byte[]) {
                    krbContext.setKerberosToken((byte[])pubObject);
                    continue;
                }
                if (!(pubObject instanceof GSSContext)) continue;
                gssContext = (GSSContext)pubObject;
                krbContext.setGSSContext(gssContext);
            }
            Set<Object> setPrivCred = loginSubject.getPrivateCredentials();
            for (Object privObject : setPrivCred) {
                if (!(privObject instanceof KerberosTicket)) continue;
                KerberosTicket kerbTicket = (KerberosTicket)privObject;
                try {
                    if (!kerbTicket.getServer().getName().equals(((Object)gssContext.getTargName()).toString())) continue;
                    SecretKey sKey = kerbTicket.getSessionKey();
                    byte[] secret = sKey.getEncoded();
                    krbContext.setSecretKey(secret);
                    break;
                }
                catch (GSSException ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (PrivilegedActionException pae) {
            throw new XWSSecurityException((Throwable)pae);
        }
        krbContext.setOnce(true);
        return krbContext;
    }

    public KerberosContext login(String loginModule, byte[] token) throws XWSSecurityException {
        KerberosContext krbContext = new KerberosContext();
        LoginContext lc = null;
        try {
            lc = new LoginContext(loginModule, new TextCallbackHandler());
        }
        catch (LoginException le) {
            throw new XWSSecurityException("Cannot create LoginContext. ", (Throwable)le);
        }
        catch (SecurityException se) {
            throw new XWSSecurityException("Cannot create LoginContext. ", (Throwable)se);
        }
        try {
            lc.login();
        }
        catch (AccountExpiredException aee) {
            throw new XWSSecurityException("Your Kerberos account has expired.", (Throwable)aee);
        }
        catch (CredentialExpiredException cee) {
            throw new XWSSecurityException("Your credentials have expired.", (Throwable)cee);
        }
        catch (FailedLoginException fle) {
            throw new XWSSecurityException("Authentication Failed", (Throwable)fle);
        }
        catch (Exception e) {
            throw new XWSSecurityException("Unexpected Exception in Kerberos login - unable to continue", (Throwable)e);
        }
        try {
            Subject loginSubject = lc.getSubject();
            Subject.doAsPrivileged(loginSubject, new KerberosServerSetupAction(token), null);
            Set<Object> setPubCred = loginSubject.getPublicCredentials();
            Iterator<Object> iter1 = setPubCred.iterator();
            GSSContext gssContext = null;
            while (iter1.hasNext()) {
                Object pubObject = iter1.next();
                if (pubObject instanceof byte[]) {
                    krbContext.setKerberosToken((byte[])pubObject);
                    continue;
                }
                if (!(pubObject instanceof GSSContext)) continue;
                gssContext = (GSSContext)pubObject;
                krbContext.setGSSContext(gssContext);
            }
            Set<Object> setPrivCred = loginSubject.getPrivateCredentials();
            for (Object privObject : setPrivCred) {
                if (!(privObject instanceof EncryptionKey)) continue;
                EncryptionKey encKey = (EncryptionKey)privObject;
                byte[] keyBytes = encKey.getBytes();
                krbContext.setSecretKey(keyBytes);
                break;
            }
        }
        catch (PrivilegedActionException pae) {
            throw new XWSSecurityException((Throwable)pae);
        }
        krbContext.setOnce(false);
        return krbContext;
    }

    class KerberosServerSetupAction
    implements PrivilegedExceptionAction {
        byte[] token;

        public KerberosServerSetupAction(byte[] token) {
            this.token = token;
        }

        public Object run() throws Exception {
            try {
                final GSSManager manager = GSSManager.getInstance();
                final Oid krb5Oid = new Oid("1.2.840.113554.1.2.2");
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            manager.addProviderAtFront((Provider)new XWSSProvider(), krb5Oid);
                        }
                        catch (GSSException gsse) {
                            gsse.printStackTrace();
                        }
                        return null;
                    }
                });
                GSSContext context = manager.createContext((GSSCredential)null);
                byte[] outToken = context.acceptSecContext(this.token, 0, this.token.length);
                if (outToken == null || outToken.length != 0) {
                    // empty if block
                }
                AccessControlContext acc = AccessController.getContext();
                Subject loginSubject = Subject.getSubject(acc);
                loginSubject.getPublicCredentials().add(context);
                loginSubject.getPublicCredentials().add(this.token);
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
            return null;
        }
    }

    class KerberosClientSetupAction
    implements PrivilegedExceptionAction {
        String server;
        boolean credentialDelegation = false;

        public KerberosClientSetupAction(String server, boolean credDeleg) {
            this.server = server;
            this.credentialDelegation = credDeleg;
        }

        public Object run() throws Exception {
            try {
                Oid krb5Oid = new Oid("1.2.840.113554.1.2.2");
                GSSManager manager = GSSManager.getInstance();
                GSSName serverName = manager.createName(this.server, null);
                GSSContext context = manager.createContext(serverName, krb5Oid, null, 0);
                context.requestMutualAuth(false);
                context.requestConf(false);
                context.requestInteg(true);
                context.requestCredDeleg(this.credentialDelegation);
                byte[] token = new byte[]{};
                token = context.initSecContext(token, 0, token.length);
                AccessControlContext acc = AccessController.getContext();
                Subject loginSubject = Subject.getSubject(acc);
                loginSubject.getPublicCredentials().add(context);
                loginSubject.getPublicCredentials().add(token);
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
            return null;
        }
    }
}

