/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.commons.DelayedTaskManager;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.runtime.JaxwsApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.RuntimeContext;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import java.util.concurrent.TimeUnit;

public class ClientAckRequesterTask
implements DelayedTaskManager.DelayedTask {
    private static final Logger LOGGER = Logger.getLogger(ClientAckRequesterTask.class);
    private final RuntimeContext rc;
    private final String outboundSequenceId;
    private final long acknowledgementRequestInterval;

    public ClientAckRequesterTask(RuntimeContext rc, String outboundSequenceId) {
        this.rc = rc;
        this.acknowledgementRequestInterval = rc.configuration.getRmFeature().getAckRequestTransmissionInterval();
        this.outboundSequenceId = outboundSequenceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(DelayedTaskManager manager) {
        block7: {
            LOGGER.entering(new Object[]{this.outboundSequenceId});
            try {
                block8: {
                    Sequence sequence;
                    if (this.rc.communicator.isClosed()) {
                        return;
                    }
                    if (!this.rc.sequenceManager().isValid(this.outboundSequenceId) || (sequence = this.rc.sequenceManager().getOutboundSequence(this.outboundSequenceId)).isClosed() || sequence.isExpired()) break block7;
                    try {
                        if (!sequence.isStandaloneAcknowledgementRequestSchedulable(this.acknowledgementRequestInterval)) break block8;
                        this.requestAcknowledgement();
                        sequence.updateLastAcknowledgementRequestTime();
                    }
                    catch (Throwable throwable) {
                        LOGGER.finer(String.format("Scheduling next run for an outbound sequence with id [ %s ]", this.outboundSequenceId));
                        manager.register((DelayedTaskManager.DelayedTask)this, this.getExecutionDelay(), this.getExecutionDelayTimeUnit());
                        throw throwable;
                    }
                }
                LOGGER.finer(String.format("Scheduling next run for an outbound sequence with id [ %s ]", this.outboundSequenceId));
                manager.register((DelayedTaskManager.DelayedTask)this, this.getExecutionDelay(), this.getExecutionDelayTimeUnit());
            }
            finally {
                LOGGER.exiting((Object)this.outboundSequenceId);
            }
        }
    }

    private void requestAcknowledgement() {
        Packet request = this.rc.communicator.createEmptyRequestPacket(this.rc.rmVersion.protocolVersion.ackRequestedAction, true);
        request.setIsProtocolMessage();
        if (this.rc.getUserStateID() != null) {
            request.setUserStateId(this.rc.getUserStateID());
        }
        JaxwsApplicationMessage requestMessage = new JaxwsApplicationMessage(request, request.getMessage().getID(this.rc.addressingVersion, this.rc.soapVersion));
        requestMessage.setSequenceData(this.outboundSequenceId, 0L);
        this.rc.sourceMessageHandler.attachAcknowledgementInfo(requestMessage);
        this.rc.protocolHandler.appendAcknowledgementHeaders(requestMessage.getPacket(), requestMessage.getAcknowledgementData());
        this.rc.communicator.sendAsync(request, new Fiber.CompletionCallback(){

            public void onCompletion(Packet response) {
                if (response == null || response.getMessage() == null) {
                    LOGGER.warning(LocalizationMessages.WSRM_1108_NULL_RESPONSE_FOR_ACK_REQUEST());
                    return;
                }
                try {
                    if (((ClientAckRequesterTask)ClientAckRequesterTask.this).rc.protocolHandler.containsProtocolMessage(response)) {
                        LOGGER.finer("Processing RM protocol response message.");
                        JaxwsApplicationMessage message = new JaxwsApplicationMessage(response, "");
                        ((ClientAckRequesterTask)ClientAckRequesterTask.this).rc.protocolHandler.loadAcknowledgementData(message, message.getJaxwsMessage());
                        ((ClientAckRequesterTask)ClientAckRequesterTask.this).rc.destinationMessageHandler.processAcknowledgements(message.getAcknowledgementData());
                        ((ClientAckRequesterTask)ClientAckRequesterTask.this).rc.outboundDeliveredHandler.processAcknowledgements(message.getAcknowledgementData());
                    } else {
                        LOGGER.severe(LocalizationMessages.WSRM_1120_RESPONSE_NOT_IDENTIFIED_AS_PROTOCOL_MESSAGE());
                    }
                    if (response.getMessage().isFault()) {
                        LOGGER.warning(LocalizationMessages.WSRM_1109_SOAP_FAULT_RESPONSE_FOR_ACK_REQUEST());
                    }
                }
                finally {
                    response.getMessage().consume();
                }
            }

            public void onCompletion(Throwable error) {
                LOGGER.warning(LocalizationMessages.WSRM_1127_UNEXPECTED_EXCEPTION_WHEN_SENDING_ACK_REQUEST(), error);
            }
        });
    }

    public long getExecutionDelay() {
        return this.acknowledgementRequestInterval;
    }

    public TimeUnit getExecutionDelayTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    public String getName() {
        return "client acknowledgement requester task";
    }
}

