/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.mc.dev.AdditionalResponses;
import com.sun.xml.ws.rx.rm.protocol.AcknowledgementData;
import com.sun.xml.ws.rx.rm.protocol.CloseSequenceData;
import com.sun.xml.ws.rx.rm.protocol.CloseSequenceResponseData;
import com.sun.xml.ws.rx.rm.protocol.CreateSequenceData;
import com.sun.xml.ws.rx.rm.protocol.CreateSequenceResponseData;
import com.sun.xml.ws.rx.rm.protocol.TerminateSequenceData;
import com.sun.xml.ws.rx.rm.protocol.TerminateSequenceResponseData;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.AckRequestedElement;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.CloseSequenceElement;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.CloseSequenceResponseElement;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.CreateSequenceElement;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.CreateSequenceResponseElement;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.SequenceAcknowledgementElement;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.SequenceElement;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.SequenceFaultElement;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.TerminateSequenceElement;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.TerminateSequenceResponseElement;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.UsesSequenceSTR;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.RmConfiguration;
import com.sun.xml.ws.rx.rm.runtime.RmRuntimeVersion;
import com.sun.xml.ws.rx.rm.runtime.RuntimeContext;
import com.sun.xml.ws.rx.rm.runtime.WsrmProtocolHandler;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.UnknownSequenceException;
import com.sun.xml.ws.rx.util.Communicator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;

final class Wsrm200702ProtocolHandler
extends WsrmProtocolHandler {
    private static final Logger LOGGER = Logger.getLogger(Wsrm200702ProtocolHandler.class);
    private final RuntimeContext rc;

    Wsrm200702ProtocolHandler(RmConfiguration configuration, RuntimeContext rc, Communicator communicator) {
        super(RmRuntimeVersion.WSRM200702, configuration, communicator);
        assert (rc != null);
        this.rc = rc;
    }

    public CreateSequenceData toCreateSequenceData(@NotNull Packet packet) throws RxRuntimeException {
        assert (packet != null);
        assert (packet.getMessage() != null);
        assert (!packet.getMessage().isFault());
        Message message = packet.getMessage();
        CreateSequenceElement csElement = (CreateSequenceElement)this.unmarshallMessage(message);
        return csElement.toDataBuilder().build();
    }

    public Packet toPacket(CreateSequenceData data, @Nullable Packet requestPacket) throws RxRuntimeException {
        Packet packet = this.communicator.createRequestPacket(requestPacket, (Object)new CreateSequenceElement(data), this.rmVersion.protocolVersion.createSequenceAction, true);
        if (data.getStrType() != null) {
            UsesSequenceSTR usesSequenceSTR = new UsesSequenceSTR();
            usesSequenceSTR.getOtherAttributes().put(this.communicator.soapMustUnderstandAttributeName, "true");
            packet.getMessage().getHeaders().add(Headers.create((JAXBContext)this.getJaxbContext(), (Object)usesSequenceSTR));
        }
        return packet;
    }

    public CreateSequenceResponseData toCreateSequenceResponseData(Packet packet) throws RxRuntimeException {
        assert (packet != null);
        assert (packet.getMessage() != null);
        assert (!packet.getMessage().isFault());
        Message message = packet.getMessage();
        CreateSequenceResponseElement csrElement = (CreateSequenceResponseElement)this.unmarshallMessage(message);
        return csrElement.toDataBuilder().build();
    }

    public Packet toPacket(CreateSequenceResponseData data, @NotNull Packet requestPacket, boolean clientSideResponse) throws RxRuntimeException {
        return this.communicator.createResponsePacket(requestPacket, (Object)new CreateSequenceResponseElement(data), this.rmVersion.protocolVersion.createSequenceResponseAction, clientSideResponse);
    }

    public CloseSequenceData toCloseSequenceData(Packet packet) throws RxRuntimeException {
        assert (packet != null);
        assert (packet.getMessage() != null);
        assert (!packet.getMessage().isFault());
        Message message = packet.getMessage();
        CloseSequenceElement csElement = (CloseSequenceElement)this.unmarshallMessage(message);
        CloseSequenceData.Builder dataBuilder = csElement.toDataBuilder();
        dataBuilder.acknowledgementData(this.getAcknowledgementData(message));
        return dataBuilder.build();
    }

    public Packet toPacket(CloseSequenceData data, @Nullable Packet requestPacket) throws RxRuntimeException {
        Packet packet = this.communicator.createRequestPacket(requestPacket, (Object)new CloseSequenceElement(data), this.rmVersion.protocolVersion.closeSequenceAction, true);
        if (data.getAcknowledgementData() != null) {
            this.appendAcknowledgementHeaders(packet, data.getAcknowledgementData());
        }
        return packet;
    }

    public CloseSequenceResponseData toCloseSequenceResponseData(Packet packet) throws RxRuntimeException {
        assert (packet != null);
        assert (packet.getMessage() != null);
        assert (!packet.getMessage().isFault());
        Message message = packet.getMessage();
        CloseSequenceResponseElement csrElement = (CloseSequenceResponseElement)this.unmarshallMessage(message);
        CloseSequenceResponseData.Builder dataBuilder = csrElement.toDataBuilder();
        dataBuilder.acknowledgementData(this.getAcknowledgementData(message));
        return dataBuilder.build();
    }

    public Packet toPacket(CloseSequenceResponseData data, @NotNull Packet requestPacket, boolean clientSideResponse) throws RxRuntimeException {
        Packet packet = this.communicator.createResponsePacket(requestPacket, (Object)new CloseSequenceResponseElement(data), this.rmVersion.protocolVersion.closeSequenceResponseAction, clientSideResponse);
        if (data.getAcknowledgementData() != null) {
            this.appendAcknowledgementHeaders(packet, data.getAcknowledgementData());
        }
        return packet;
    }

    public TerminateSequenceData toTerminateSequenceData(Packet packet) throws RxRuntimeException {
        assert (packet != null);
        assert (packet.getMessage() != null);
        assert (!packet.getMessage().isFault());
        Message message = packet.getMessage();
        TerminateSequenceElement tsElement = (TerminateSequenceElement)this.unmarshallMessage(message);
        TerminateSequenceData.Builder dataBuilder = tsElement.toDataBuilder();
        dataBuilder.acknowledgementData(this.getAcknowledgementData(message));
        return dataBuilder.build();
    }

    public Packet toPacket(TerminateSequenceData data, @Nullable Packet requestPacket) throws RxRuntimeException {
        Packet packet = this.communicator.createRequestPacket(requestPacket, (Object)new TerminateSequenceElement(data), this.rmVersion.protocolVersion.terminateSequenceAction, true);
        if (data.getAcknowledgementData() != null) {
            this.appendAcknowledgementHeaders(packet, data.getAcknowledgementData());
        }
        return packet;
    }

    public TerminateSequenceResponseData toTerminateSequenceResponseData(Packet packet) throws RxRuntimeException {
        assert (packet != null);
        assert (packet.getMessage() != null);
        assert (!packet.getMessage().isFault());
        Message message = packet.getMessage();
        TerminateSequenceResponseElement tsrElement = (TerminateSequenceResponseElement)this.unmarshallMessage(message);
        TerminateSequenceResponseData.Builder dataBuilder = tsrElement.toDataBuilder();
        dataBuilder.acknowledgementData(this.getAcknowledgementData(message));
        return dataBuilder.build();
    }

    public Packet toPacket(TerminateSequenceResponseData data, @NotNull Packet requestPacket, boolean clientSideResponse) throws RxRuntimeException {
        AdditionalResponses ar;
        Packet packet = this.communicator.createResponsePacket(requestPacket, (Object)new TerminateSequenceResponseElement(data), this.rmVersion.protocolVersion.terminateSequenceResponseAction, clientSideResponse);
        if (data.getAcknowledgementData() != null) {
            this.appendAcknowledgementHeaders(packet, data.getAcknowledgementData());
        }
        if (data.getBoundSequenceId() != null && (ar = (AdditionalResponses)packet.getSatellite(AdditionalResponses.class)) != null) {
            TerminateSequenceData tsData = TerminateSequenceData.getBuilder(data.getBoundSequenceId(), data.getBoundSequenceLastMessageId()).build();
            ar.getAdditionalResponsePacketQueue().offer(this.toPacket(tsData, requestPacket));
        }
        return packet;
    }

    public void appendSequenceHeader(@NotNull Message jaxwsMessage, @NotNull ApplicationMessage message) throws RxRuntimeException {
        assert (message != null);
        assert (message.getSequenceId() != null);
        assert (jaxwsMessage != null);
        SequenceElement sequenceHeaderElement = new SequenceElement();
        sequenceHeaderElement.setId(message.getSequenceId());
        sequenceHeaderElement.setMessageNumber(message.getMessageNumber());
        sequenceHeaderElement.getOtherAttributes().put(this.communicator.soapMustUnderstandAttributeName, "true");
        jaxwsMessage.getHeaders().add(this.createHeader(sequenceHeaderElement));
    }

    public void appendAcknowledgementHeaders(@NotNull Packet packet, @NotNull AcknowledgementData ackData) {
        assert (packet != null);
        assert (packet.getMessage() != null);
        assert (ackData != null);
        Message jaxwsMessage = packet.getMessage();
        if (ackData.getAckReqestedSequenceId() != null) {
            AckRequestedElement ackRequestedElement = new AckRequestedElement();
            ackRequestedElement.setId(ackData.getAckReqestedSequenceId());
            jaxwsMessage.getHeaders().add(this.createHeader(ackRequestedElement));
            packet.invocationProperties.put(RmConfiguration.ACK_REQUESTED_HEADER_SET, Boolean.TRUE);
        }
        if (ackData.getAcknowledgedSequenceId() != null) {
            SequenceAcknowledgementElement ackElement = new SequenceAcknowledgementElement();
            ackElement.setId(ackData.getAcknowledgedSequenceId());
            List<Sequence.AckRange> ackedRanges = ackData.getAcknowledgedRanges();
            if (ackedRanges.isEmpty()) {
                ackElement.setNone(new SequenceAcknowledgementElement.None());
            } else {
                for (Sequence.AckRange range : ackedRanges) {
                    ackElement.addAckRange(range.lower, range.upper);
                }
            }
            if (ackData.isFinalAcknowledgement()) {
                ackElement.setFinal(new SequenceAcknowledgementElement.Final());
            }
            jaxwsMessage.getHeaders().add(this.createHeader(ackElement));
        }
    }

    public void loadSequenceHeaderData(@NotNull ApplicationMessage message, @NotNull Message jaxwsMessage) throws RxRuntimeException {
        assert (message != null);
        assert (message.getSequenceId() == null);
        SequenceElement sequenceElement = (SequenceElement)this.readHeaderAsUnderstood(this.rmVersion.protocolVersion.protocolNamespaceUri, "Sequence", jaxwsMessage);
        if (sequenceElement != null) {
            message.setSequenceData(sequenceElement.getId(), sequenceElement.getMessageNumber());
        }
    }

    public void loadAcknowledgementData(@NotNull ApplicationMessage message, @NotNull Message jaxwsMessage) throws RxRuntimeException {
        assert (message != null);
        assert (message.getAcknowledgementData() == null);
        message.setAcknowledgementData(this.getAcknowledgementData(jaxwsMessage));
    }

    public AcknowledgementData getAcknowledgementData(Message jaxwsMessage) throws UnknownSequenceException, RxRuntimeException {
        SequenceAcknowledgementElement ackElement;
        assert (jaxwsMessage != null);
        AcknowledgementData.Builder ackDataBuilder = AcknowledgementData.getBuilder();
        AckRequestedElement ackRequestedElement = (AckRequestedElement)this.readHeaderAsUnderstood(this.rmVersion.protocolVersion.protocolNamespaceUri, "AckRequested", jaxwsMessage);
        if (ackRequestedElement != null) {
            ackDataBuilder.ackReqestedSequenceId(ackRequestedElement.getId());
        }
        if ((ackElement = (SequenceAcknowledgementElement)this.readHeaderAsUnderstood(this.rmVersion.protocolVersion.protocolNamespaceUri, "SequenceAcknowledgement", jaxwsMessage)) != null) {
            LinkedList<Sequence.AckRange> ranges = new LinkedList<Sequence.AckRange>();
            if (ackElement.getNone() == null) {
                if (!ackElement.getNack().isEmpty()) {
                    ArrayList<BigInteger> nacks = new ArrayList<BigInteger>(ackElement.getNack());
                    Collections.sort(nacks);
                    long lastLowerBound = 1L;
                    for (BigInteger nackId : nacks) {
                        if (lastLowerBound == nackId.longValue()) {
                            ++lastLowerBound;
                            continue;
                        }
                        ranges.add(new Sequence.AckRange(lastLowerBound, nackId.longValue() - 1L));
                        lastLowerBound = nackId.longValue() + 1L;
                    }
                    long lastMessageId = this.rc.sequenceManager().getSequence(ackElement.getId()).getLastMessageNumber();
                    if (lastLowerBound <= lastMessageId) {
                        ranges.add(new Sequence.AckRange(lastLowerBound, lastMessageId));
                    }
                } else if (ackElement.getAcknowledgementRange() != null && !ackElement.getAcknowledgementRange().isEmpty()) {
                    for (SequenceAcknowledgementElement.AcknowledgementRange rangeElement : ackElement.getAcknowledgementRange()) {
                        ranges.add(new Sequence.AckRange(rangeElement.getLower().longValue(), rangeElement.getUpper().longValue()));
                    }
                }
            }
            ackDataBuilder.acknowledgements(ackElement.getId(), ranges, ackElement.getFinal() != null);
        }
        return ackDataBuilder.build();
    }

    public Header createSequenceFaultElementHeader(QName subcode, Detail detail) {
        return Headers.create((JAXBContext)this.rmVersion.getJaxbContext(this.addressingVersion), (Object)new SequenceFaultElement(subcode, detail));
    }

    public Packet createEmptyAcknowledgementResponse(AcknowledgementData ackData, Packet requestPacket) throws RxRuntimeException {
        if (ackData.getAckReqestedSequenceId() != null || ackData.getAcknowledgedSequenceId() != null) {
            Packet response = this.rc.communicator.createEmptyResponsePacket(requestPacket, this.rc.rmVersion.protocolVersion.sequenceAcknowledgementAction);
            response = this.rc.communicator.setEmptyResponseMessage(response, requestPacket, this.rc.rmVersion.protocolVersion.sequenceAcknowledgementAction);
            this.appendAcknowledgementHeaders(response, ackData);
            return response;
        }
        return this.rc.communicator.createNullResponsePacket(requestPacket);
    }
}

