/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.policy.spi_impl;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.jaxws.spi.PolicyFeatureConfigurator;
import com.sun.xml.ws.rx.rm.api.ReliableMessagingFeature;
import com.sun.xml.ws.rx.rm.api.ReliableMessagingFeatureBuilder;
import com.sun.xml.ws.rx.rm.api.RmProtocolVersion;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.policy.RmConfigurator;
import java.util.Collection;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RmFeatureConfigurator
implements PolicyFeatureConfigurator {
    private static final Logger LOGGER = Logger.getLogger(RmFeatureConfigurator.class);

    public Collection<WebServiceFeature> getFeatures(PolicyMapKey key, PolicyMap policyMap) throws PolicyException {
        Policy policy;
        LinkedList<WebServiceFeature> features = new LinkedList<WebServiceFeature>();
        if (key != null && policyMap != null && (policy = policyMap.getEndpointEffectivePolicy(key)) != null) {
            for (AssertionSet alternative : policy) {
                ReliableMessagingFeature feature = this.getRmFeature(alternative);
                if (feature == null) continue;
                features.add((WebServiceFeature)feature);
            }
        }
        return features;
    }

    private ReliableMessagingFeature getRmFeature(AssertionSet alternative) throws PolicyException {
        ReliableMessagingFeatureBuilder rmFeatureBuilder = null;
        for (RmProtocolVersion rmv : RmProtocolVersion.values()) {
            if (!this.isPresentAndMandatory(alternative, rmv.rmAssertionName)) continue;
            rmFeatureBuilder = new ReliableMessagingFeatureBuilder(rmv);
            break;
        }
        if (rmFeatureBuilder == null) {
            return null;
        }
        for (PolicyAssertion assertion : alternative) {
            if (!(assertion instanceof RmConfigurator)) continue;
            RmConfigurator rmAssertion = (RmConfigurator)RmConfigurator.class.cast(assertion);
            if (!rmAssertion.isCompatibleWith(rmFeatureBuilder.getProtocolVersion())) {
                LOGGER.warning(LocalizationMessages.WSRM_1009_INCONSISTENCIES_IN_POLICY(rmAssertion.getName(), rmFeatureBuilder.getProtocolVersion()));
            }
            rmFeatureBuilder = rmAssertion.update(rmFeatureBuilder);
        }
        return rmFeatureBuilder.build();
    }

    private Collection<PolicyAssertion> getAssertionsWithName(AssertionSet alternative, QName name) throws PolicyException {
        Collection assertions = alternative.get(name);
        if (assertions.size() > 1) {
            throw (PolicyException)LOGGER.logSevereException((Throwable)new PolicyException(LocalizationMessages.WSRM_1008_DUPLICATE_ASSERTION_IN_POLICY(assertions.size(), name)));
        }
        return assertions;
    }

    private boolean isPresentAndMandatory(AssertionSet alternative, QName assertionName) throws PolicyException {
        Collection<PolicyAssertion> assertions = this.getAssertionsWithName(alternative, assertionName);
        for (PolicyAssertion assertion : assertions) {
            if (assertion.isOptional()) continue;
            return true;
        }
        return false;
    }
}

