/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence;

import com.sun.istack.NotNull;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.commons.DelayedTaskManager;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;

public class SequenceMaintenanceTask
implements DelayedTaskManager.DelayedTask {
    private static final Logger LOGGER = Logger.getLogger(SequenceMaintenanceTask.class);
    private final WeakReference<SequenceManager> smReference;
    private final long period;
    private final TimeUnit timeUnit;
    private final String endpointUid;

    public SequenceMaintenanceTask(@NotNull SequenceManager sequenceManager, long period, @NotNull TimeUnit timeUnit) {
        assert (sequenceManager != null);
        assert (period > 0L);
        assert (timeUnit != null);
        this.smReference = new WeakReference<SequenceManager>(sequenceManager);
        this.period = period;
        this.timeUnit = timeUnit;
        this.endpointUid = sequenceManager.uniqueEndpointId();
    }

    public void run(DelayedTaskManager manager) {
        SequenceManager sequenceManager = (SequenceManager)this.smReference.get();
        if (sequenceManager != null) {
            boolean registrationSuccesfull;
            sequenceManager.onMaintenance();
            if (!manager.isClosed() && !(registrationSuccesfull = manager.register((DelayedTaskManager.DelayedTask)this, this.period, this.timeUnit))) {
                LOGGER.config(LocalizationMessages.WSRM_1150_UNABLE_TO_RESCHEDULE_SEQUENCE_MAINTENANCE_TASK(this.endpointUid));
            }
        } else {
            LOGGER.config(LocalizationMessages.WSRM_1151_TERMINATING_SEQUENCE_MAINTENANCE_TASK(this.endpointUid));
        }
    }

    public String getName() {
        return "sequence maintenance task";
    }
}

