/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.delivery;

import com.sun.istack.NotNull;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueue;
import com.sun.xml.ws.rx.rm.runtime.delivery.Postman;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

class InOrderDeliveryQueue
implements DeliveryQueue {
    private static final Logger LOGGER = Logger.getLogger(InOrderDeliveryQueue.class);
    private static final MessageIdComparator MSG_ID_COMPARATOR = new MessageIdComparator();
    @NotNull
    private final Postman postman;
    @NotNull
    private final Postman.Callback deliveryCallback;
    @NotNull
    private final Sequence sequence;
    private final long maxMessageBufferSize;
    @NotNull
    private final BlockingQueue<ApplicationMessage> postponedMessageQueue;
    private final AtomicBoolean isClosed;

    public InOrderDeliveryQueue(@NotNull Postman postman, @NotNull Postman.Callback deliveryCallback, @NotNull Sequence sequence, long maxMessageBufferSize) {
        assert (postman != null);
        assert (deliveryCallback != null);
        assert (sequence != null);
        assert (maxMessageBufferSize >= -1L);
        this.postman = postman;
        this.deliveryCallback = deliveryCallback;
        this.sequence = sequence;
        this.maxMessageBufferSize = maxMessageBufferSize;
        this.postponedMessageQueue = new PriorityBlockingQueue<ApplicationMessage>(32, MSG_ID_COMPARATOR);
        this.isClosed = new AtomicBoolean(false);
    }

    public void put(ApplicationMessage message) {
        assert (message.getSequenceId().equals(this.sequence.getId()));
        try {
            this.postponedMessageQueue.put(message);
        }
        catch (InterruptedException ex) {
            throw (RxRuntimeException)LOGGER.logSevereException((Throwable)new RxRuntimeException(LocalizationMessages.WSRM_1147_ADDING_MSG_TO_QUEUE_INTERRUPTED(), (Throwable)ex));
        }
        this.tryDelivery();
    }

    public void onSequenceAcknowledgement() {
        if (!this.isClosed.get()) {
            this.tryDelivery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryDelivery() {
        if (this.isClosed.get()) {
            throw new RxRuntimeException(LocalizationMessages.WSRM_1160_DELIVERY_QUEUE_CLOSED());
        }
        if (!this.postponedMessageQueue.isEmpty()) {
            while (true) {
                ApplicationMessage deliverableMessage = null;
                BlockingQueue<ApplicationMessage> blockingQueue = this.postponedMessageQueue;
                synchronized (blockingQueue) {
                    ApplicationMessage queueHead = (ApplicationMessage)this.postponedMessageQueue.peek();
                    if (queueHead != null && this.isDeliverable(queueHead)) {
                        deliverableMessage = (ApplicationMessage)this.postponedMessageQueue.poll();
                        assert (this.isDeliverable(deliverableMessage));
                    }
                }
                if (deliverableMessage == null) break;
                this.postman.deliver(deliverableMessage, this.deliveryCallback);
            }
        }
    }

    public long getRemainingMessageBufferSize() {
        return this.maxMessageBufferSize == -1L ? this.maxMessageBufferSize : this.maxMessageBufferSize - (long)this.postponedMessageQueue.size();
    }

    public void close() {
        this.isClosed.set(true);
    }

    private boolean isDeliverable(ApplicationMessage message) {
        List<Sequence.AckRange> ackedIds = this.sequence.getAcknowledgedMessageNumbers();
        if (ackedIds.isEmpty()) {
            return message.getMessageNumber() == 1L;
        }
        Sequence.AckRange firstRange = ackedIds.get(0);
        return firstRange.lower != 1L ? message.getMessageNumber() == 1L : message.getMessageNumber() == firstRange.upper + 1L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MessageIdComparator
    implements Comparator<ApplicationMessage> {
        private MessageIdComparator() {
        }

        @Override
        public int compare(ApplicationMessage o1, ApplicationMessage o2) {
            return o1.getMessageNumber() < o2.getMessageNumber() ? -1 : (o1.getMessageNumber() > o2.getMessageNumber() ? 1 : 0);
        }
    }
}

