/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.mc.runtime;

import com.sun.istack.NotNull;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.ha.HaInfo;
import com.sun.xml.ws.api.ha.HighAvailabilityProvider;
import com.sun.xml.ws.commons.ha.HaContext;
import com.sun.xml.ws.commons.ha.StickyKey;
import com.sun.xml.ws.rx.ha.HighlyAvailableMap;
import com.sun.xml.ws.rx.ha.ReplicationManager;
import com.sun.xml.ws.rx.mc.localization.LocalizationMessages;
import com.sun.xml.ws.rx.mc.runtime.PendingResponseIdentifiers;
import com.sun.xml.ws.rx.message.jaxws.JaxwsMessage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreFactory;

final class ResponseStorage {
    private static final Logger LOGGER = Logger.getLogger(ResponseStorage.class);
    private final ReentrantReadWriteLock storageLock = new ReentrantReadWriteLock();
    private final HighlyAvailableMap<String, JaxwsMessage> pendingResponses;
    private final HighlyAvailableMap<String, PendingResponseIdentifiers> pendingResponseIdentifiers;
    private final String endpointUid;

    public ResponseStorage(String endpointUid) {
        HighlyAvailableMap.StickyReplicationManager responseIdentifiersManager = null;
        PendingMessageDataReplicationManager responseManager = null;
        if (HighAvailabilityProvider.INSTANCE.isHaEnvironmentConfigured()) {
            BackingStoreFactory bsf = HighAvailabilityProvider.INSTANCE.getBackingStoreFactory(HighAvailabilityProvider.StoreType.IN_MEMORY);
            responseIdentifiersManager = new HighlyAvailableMap.StickyReplicationManager(endpointUid + "_MC_PENDING_MESSAGE_IDENTIFIERS_MAP_MANAGER", HighAvailabilityProvider.INSTANCE.createBackingStore(bsf, endpointUid + "_MC_PENDING_MESSAGE_IDENTIFIERS_STORE", StickyKey.class, PendingResponseIdentifiers.class));
            responseManager = new PendingMessageDataReplicationManager(endpointUid);
        }
        this.pendingResponseIdentifiers = HighlyAvailableMap.create((String)(endpointUid + "_MC_PENDING_MESSAGE_IDENTIFIERS_MAP"), new HashMap(), responseIdentifiersManager);
        this.pendingResponses = HighlyAvailableMap.create((String)(endpointUid + "_MC_PENDING_MESSAGE_DATA_MAP"), new HashMap(), responseManager);
        this.endpointUid = endpointUid;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("[WSMC-HA] endpoint UID [" + endpointUid + "]: Response storage initialized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store(@NotNull JaxwsMessage response, @NotNull String clientUID) {
        try {
            this.storageLock.writeLock().lock();
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("[WSMC-HA] endpoint UID [" + this.endpointUid + "]: Storing new response for client UID: " + clientUID);
            }
            this.pendingResponses.put((Serializable)((Object)response.getCorrelationId()), (Object)response);
            PendingResponseIdentifiers clientResponses = (PendingResponseIdentifiers)this.pendingResponseIdentifiers.get((Object)clientUID);
            if (clientResponses == null) {
                clientResponses = new PendingResponseIdentifiers();
            }
            if (!clientResponses.offer(response.getCorrelationId())) {
                LOGGER.severe(LocalizationMessages.WSMC_0104_ERROR_STORING_RESPONSE(clientUID));
            }
            this.pendingResponseIdentifiers.put((Serializable)((Object)clientUID), (Object)clientResponses);
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JaxwsMessage getPendingResponse(@NotNull String clientUID) {
        try {
            PendingResponseIdentifiers clientResponses;
            this.storageLock.writeLock().lock();
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("[WSMC-HA] endpoint UID [" + this.endpointUid + "]: Retrieving stored pending response for client UID: " + clientUID);
            }
            if ((clientResponses = (PendingResponseIdentifiers)this.pendingResponseIdentifiers.get((Object)clientUID)) != null && !clientResponses.isEmpty()) {
                String messageId = clientResponses.poll();
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("[WSMC-HA] endpoint UID [" + this.endpointUid + "]: Found registered pending response with message id [" + messageId + "] for client UID: " + clientUID);
                }
                this.pendingResponseIdentifiers.put((Serializable)((Object)clientUID), (Object)clientResponses);
                JaxwsMessage response = (JaxwsMessage)this.pendingResponses.remove((Object)messageId);
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("[WSMC-HA] endpoint UID [" + this.endpointUid + "]: Retrieved and removed pending response message data for message id [" + messageId + "]: " + (response == null ? null : response.toString()));
                }
                if (response == null) {
                    LOGGER.warning("[WSMC-HA] endpoint UID [" + this.endpointUid + "]: No penidng response message data found for message id [" + messageId + "]");
                }
                JaxwsMessage jaxwsMessage = response;
                return jaxwsMessage;
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("[WSMC-HA] endpoint UID [" + this.endpointUid + "]: No pedning responses found for client UID: " + clientUID);
            }
            JaxwsMessage jaxwsMessage = null;
            return jaxwsMessage;
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingResponse(@NotNull String clientUID) {
        try {
            boolean result;
            this.storageLock.readLock().lock();
            PendingResponseIdentifiers clientResponses = (PendingResponseIdentifiers)this.pendingResponseIdentifiers.get((Object)clientUID);
            boolean bl = result = clientResponses != null && !clientResponses.isEmpty();
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("[WSMC-HA] endpoint UID [" + this.endpointUid + "]: Pending responses avaliable for client UID [" + clientUID + "]: " + result);
            }
            boolean bl2 = result;
            return bl2;
        }
        finally {
            this.storageLock.readLock().unlock();
        }
    }

    void invalidateLocalCache() {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("[WSMC-HA] endpoint UID [" + this.endpointUid + "]: Invalidation local caches for the response storage");
        }
        this.pendingResponseIdentifiers.invalidateCache();
        this.pendingResponses.invalidateCache();
    }

    void dispose() {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("[WSMC-HA] endpoint UID [" + this.endpointUid + "]: Disposing the response storage");
        }
        this.pendingResponseIdentifiers.close();
        this.pendingResponseIdentifiers.destroy();
        this.pendingResponses.close();
        this.pendingResponses.destroy();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PendingMessageDataReplicationManager
    implements ReplicationManager<String, JaxwsMessage> {
        private final BackingStore<StickyKey, JaxwsMessage.JaxwsMessageState> messageStateStore;
        private final String loggerProlog;

        public PendingMessageDataReplicationManager(String endpointUid) {
            this.messageStateStore = HighAvailabilityProvider.INSTANCE.createBackingStore(HighAvailabilityProvider.INSTANCE.getBackingStoreFactory(HighAvailabilityProvider.StoreType.IN_MEMORY), endpointUid + "_MC_PENDING_MESSAGE_DATA_STORE", StickyKey.class, JaxwsMessage.JaxwsMessageState.class);
            this.loggerProlog = "[MC message data manager endpointUid: " + endpointUid + "]: ";
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.loggerProlog + "Created pending message backing store");
            }
        }

        public JaxwsMessage load(String key) {
            JaxwsMessage.JaxwsMessageState state = (JaxwsMessage.JaxwsMessageState)HighAvailabilityProvider.loadFrom(this.messageStateStore, (Serializable)new StickyKey((Serializable)((Object)key)), null);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.loggerProlog + "Message state loaded from pending message backing store for key [" + key + "]: " + (state == null ? null : state.toString()));
            }
            JaxwsMessage message = state.toMessage();
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.loggerProlog + "Message state converted to a pending message: " + (message == null ? null : message.toString()));
            }
            return message;
        }

        public void save(String key, JaxwsMessage value, boolean isNew) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.loggerProlog + "Sending for replication pending message with a key [" + key + "]: " + value.toString() + ", isNew=" + isNew);
            }
            JaxwsMessage.JaxwsMessageState state = value.getState();
            HaInfo haInfo = HaContext.currentHaInfo();
            if (haInfo != null) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(this.loggerProlog + "Existing HaInfo found, using it for pending message state replication: " + HaContext.asString((HaInfo)haInfo));
                }
                HighAvailabilityProvider.saveTo(this.messageStateStore, (Serializable)new StickyKey((Serializable)((Object)key), haInfo.getKey()), (Serializable)state, (boolean)isNew);
            } else {
                StickyKey stickyKey = new StickyKey((Serializable)((Object)key));
                String replicaId = HighAvailabilityProvider.saveTo(this.messageStateStore, (Serializable)stickyKey, (Serializable)state, (boolean)isNew);
                haInfo = new HaInfo(stickyKey.getHashKey(), replicaId, false);
                HaContext.updateHaInfo((HaInfo)haInfo);
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(this.loggerProlog + "No HaInfo found, created new after pending message state replication: " + HaContext.asString((HaInfo)haInfo));
                }
            }
        }

        public void remove(String key) {
            HighAvailabilityProvider.removeFrom(this.messageStateStore, (Serializable)new StickyKey((Serializable)((Object)key)));
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.loggerProlog + "Removed pending message from the backing store for key [" + key + "]");
            }
        }

        public void close() {
            HighAvailabilityProvider.close(this.messageStateStore);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.loggerProlog + "Closed pending message backing store");
            }
        }

        public void destroy() {
            HighAvailabilityProvider.destroy(this.messageStateStore);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.loggerProlog + "Destroyed pending message backing store");
            }
        }
    }
}

