/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.mc.runtime;

import com.sun.istack.NotNull;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.ha.HaInfo;
import com.sun.xml.ws.api.ha.HighAvailabilityProvider;
import com.sun.xml.ws.commons.ha.HaContext;
import com.sun.xml.ws.commons.ha.StickyKey;
import com.sun.xml.ws.rx.ha.HighlyAvailableMap;
import com.sun.xml.ws.rx.ha.ReplicationManager;
import com.sun.xml.ws.rx.mc.localization.LocalizationMessages;
import com.sun.xml.ws.rx.mc.runtime.PendingResponseIdentifiers;
import com.sun.xml.ws.rx.message.jaxws.JaxwsMessage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreFactory;

final class ResponseStorage {
    private static final Logger LOGGER = Logger.getLogger(ResponseStorage.class);
    final HighlyAvailableMap<String, JaxwsMessage> pendingResponses;
    final HighlyAvailableMap<String, PendingResponseIdentifiers> pendingResponseIdentifiers;
    final ReentrantReadWriteLock storageLock = new ReentrantReadWriteLock();

    public ResponseStorage(String uniqueEndpointId) {
        HighlyAvailableMap.StickyReplicationManager responseIdentifiersManager = null;
        PendingMessageReplicationManager responseManager = null;
        if (HighAvailabilityProvider.INSTANCE.isHaEnvironmentConfigured()) {
            BackingStoreFactory bsf = HighAvailabilityProvider.INSTANCE.getBackingStoreFactory(HighAvailabilityProvider.StoreType.IN_MEMORY);
            responseIdentifiersManager = new HighlyAvailableMap.StickyReplicationManager(HighAvailabilityProvider.INSTANCE.createBackingStore(bsf, uniqueEndpointId + "_MC_CLIENT_PENDING_MESSAGE_IDENTIFIERS", StickyKey.class, PendingResponseIdentifiers.class));
            responseManager = new PendingMessageReplicationManager(uniqueEndpointId);
        }
        this.pendingResponseIdentifiers = HighlyAvailableMap.create(new HashMap(), responseIdentifiersManager);
        this.pendingResponses = HighlyAvailableMap.create(new HashMap(), responseManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store(@NotNull JaxwsMessage response, @NotNull String clientUID) {
        try {
            this.storageLock.writeLock().lock();
            PendingResponseIdentifiers clientResponses = (PendingResponseIdentifiers)this.pendingResponseIdentifiers.get((Object)clientUID);
            if (clientResponses == null) {
                clientResponses = new PendingResponseIdentifiers();
            }
            this.pendingResponses.put((Serializable)((Object)response.getCorrelationId()), (Object)response);
            if (!clientResponses.offer(response.getCorrelationId())) {
                LOGGER.severe(LocalizationMessages.WSMC_0104_ERROR_STORING_RESPONSE(clientUID));
            }
            this.pendingResponseIdentifiers.put((Serializable)((Object)clientUID), (Object)clientResponses);
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JaxwsMessage getPendingResponse(@NotNull String clientUID) {
        try {
            this.storageLock.readLock().lock();
            PendingResponseIdentifiers clientResponses = (PendingResponseIdentifiers)this.pendingResponseIdentifiers.get((Object)clientUID);
            if (clientResponses != null && !clientResponses.isEmpty()) {
                String messageId = clientResponses.poll();
                this.pendingResponseIdentifiers.put((Serializable)((Object)clientUID), (Object)clientResponses);
                JaxwsMessage jaxwsMessage = (JaxwsMessage)this.pendingResponses.remove((Object)messageId);
                return jaxwsMessage;
            }
            JaxwsMessage jaxwsMessage = null;
            return jaxwsMessage;
        }
        finally {
            this.storageLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingResponse(@NotNull String clientUID) {
        try {
            this.storageLock.readLock().lock();
            PendingResponseIdentifiers clientResponses = (PendingResponseIdentifiers)this.pendingResponseIdentifiers.get((Object)clientUID);
            boolean bl = clientResponses != null && !clientResponses.isEmpty();
            return bl;
        }
        finally {
            this.storageLock.readLock().unlock();
        }
    }

    void invalidateLocalCache() {
        this.pendingResponseIdentifiers.invalidateCache();
        this.pendingResponses.invalidateCache();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PendingMessageReplicationManager
    implements ReplicationManager<String, JaxwsMessage> {
        private BackingStore<StickyKey, JaxwsMessage.JaxwsMessageState> messageStateStore;

        public PendingMessageReplicationManager(String uniqueEndpointId) {
            this.messageStateStore = HighAvailabilityProvider.INSTANCE.createBackingStore(HighAvailabilityProvider.INSTANCE.getBackingStoreFactory(HighAvailabilityProvider.StoreType.IN_MEMORY), uniqueEndpointId + "_MC_PENDING_MESSAGE_STORE", StickyKey.class, JaxwsMessage.JaxwsMessageState.class);
        }

        public JaxwsMessage load(String key) {
            JaxwsMessage.JaxwsMessageState state = (JaxwsMessage.JaxwsMessageState)HighAvailabilityProvider.loadFrom(this.messageStateStore, (Serializable)new StickyKey((Serializable)((Object)key)), null);
            return state.toMessage();
        }

        public void save(String key, JaxwsMessage value, boolean isNew) {
            JaxwsMessage.JaxwsMessageState state = value.getState();
            HaInfo haInfo = HaContext.currentHaInfo();
            if (haInfo != null) {
                HighAvailabilityProvider.saveTo(this.messageStateStore, (Serializable)new StickyKey((Serializable)((Object)key), haInfo.getKey()), (Serializable)state, (boolean)isNew);
            } else {
                StickyKey stickyKey = new StickyKey((Serializable)((Object)key));
                String replicaId = HighAvailabilityProvider.saveTo(this.messageStateStore, (Serializable)stickyKey, (Serializable)state, (boolean)isNew);
                HaContext.updateHaInfo((HaInfo)new HaInfo(stickyKey.getHashKey(), replicaId, false));
            }
        }

        public void remove(String key) {
            HighAvailabilityProvider.removeFrom(this.messageStateStore, (Serializable)new StickyKey((Serializable)((Object)key)));
        }

        public void close() {
            HighAvailabilityProvider.close(this.messageStateStore);
        }

        public void destroy() {
            HighAvailabilityProvider.destroy(this.messageStateStore);
        }
    }
}

