/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.coord.common;

import com.sun.xml.ws.api.tx.at.Transactional;
import com.sun.xml.ws.developer.MemberSubmissionEndpointReference;
import jakarta.xml.ws.EndpointReference;
import jakarta.xml.ws.wsaddressing.W3CEndpointReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class EndpointReferenceBuilder<T extends EndpointReference> {
    protected String address;
    protected List<Element> referenceParameters = new ArrayList<Element>();

    public static EndpointReferenceBuilder newInstance(Transactional.Version version) {
        if (Transactional.Version.WSAT10 == version || Transactional.Version.DEFAULT == version) {
            return EndpointReferenceBuilder.MemberSubmission();
        }
        if (Transactional.Version.WSAT11 == version || Transactional.Version.WSAT12 == version) {
            return EndpointReferenceBuilder.W3C();
        }
        throw new IllegalArgumentException(version + "is not a supported ws-at version");
    }

    public static EndpointReferenceBuilder<W3CEndpointReference> W3C() {
        return new W3CEndpointReferenceBuilder();
    }

    public static EndpointReferenceBuilder<MemberSubmissionEndpointReference> MemberSubmission() {
        return new MemberSubmissionEndpointReferenceBuilder();
    }

    public EndpointReferenceBuilder<T> address(String address) {
        this.address = address;
        return this;
    }

    public EndpointReferenceBuilder<T> referenceParameter(Element ... elements) {
        this.referenceParameters.addAll(Arrays.asList(elements));
        return this;
    }

    public EndpointReferenceBuilder<T> referenceParameter(Node ... elements) {
        for (Node element : elements) {
            this.referenceParameters.add((Element)element);
        }
        return this;
    }

    public EndpointReferenceBuilder<T> referenceParameter(List<Element> elements) {
        this.referenceParameters.addAll(elements);
        return this;
    }

    public abstract T build();

    static class W3CEndpointReferenceBuilder
    extends EndpointReferenceBuilder<W3CEndpointReference> {
        W3CEndpointReferenceBuilder() {
        }

        @Override
        public W3CEndpointReference build() {
            jakarta.xml.ws.wsaddressing.W3CEndpointReferenceBuilder builder = new jakarta.xml.ws.wsaddressing.W3CEndpointReferenceBuilder();
            for (int i = 0; i < this.referenceParameters.size(); ++i) {
                Element element = (Element)this.referenceParameters.get(i);
                builder.referenceParameter(element);
            }
            W3CEndpointReference w3CEndpointReference = builder.address(this.address).build();
            return w3CEndpointReference;
        }
    }

    static class MemberSubmissionEndpointReferenceBuilder
    extends EndpointReferenceBuilder<MemberSubmissionEndpointReference> {
        MemberSubmissionEndpointReferenceBuilder() {
        }

        @Override
        public MemberSubmissionEndpointReference build() {
            MemberSubmissionEndpointReference epr = new MemberSubmissionEndpointReference();
            epr.addr = new MemberSubmissionEndpointReference.Address();
            epr.addr.uri = this.address;
            epr.referenceParameters = new MemberSubmissionEndpointReference.Elements();
            epr.referenceParameters.elements = new ArrayList();
            epr.referenceParameters.elements.addAll(this.referenceParameters);
            return epr;
        }
    }
}

