/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.util;

import com.sun.istack.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class TimestampedCollection<K, V> {
    private final PriorityQueue<TimestampedRegistration<K, V>> timestampedPriorityQueue = new PriorityQueue();
    private final Map<K, TimestampedRegistration<K, V>> correlationMap = new HashMap<K, TimestampedRegistration<K, V>>();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();

    public static <K, V> TimestampedCollection<K, V> newInstance() {
        return new TimestampedCollection<K, V>();
    }

    TimestampedCollection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V register(@NotNull K correlationId, @NotNull V subject) {
        try {
            TimestampedRegistration<K, V> tr = new TimestampedRegistration<K, V>(System.currentTimeMillis(), correlationId, subject);
            this.rwLock.writeLock().lock();
            this.timestampedPriorityQueue.offer(tr);
            TimestampedRegistration<K, V> oldTr = this.correlationMap.put(tr.key, tr);
            if (oldTr != null) {
                this.removeFromQueue(oldTr);
                Object v = oldTr.value;
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public boolean register(@NotNull V subject) {
        return this.register(System.currentTimeMillis(), subject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean register(long timestamp, @NotNull V subject) {
        try {
            TimestampedRegistration<Object, V> tr = new TimestampedRegistration<Object, V>(timestamp, null, subject);
            this.rwLock.writeLock().lock();
            boolean bl = this.timestampedPriorityQueue.offer(tr);
            return bl;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(@NotNull K correlationId) {
        try {
            this.rwLock.writeLock().lock();
            TimestampedRegistration<K, V> tr = this.correlationMap.remove(correlationId);
            if (tr == null) {
                V v = null;
                return v;
            }
            this.removeFromQueue(tr);
            Object v = tr.value;
            return v;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public V removeOldest() {
        try {
            Object v;
            this.rwLock.writeLock().lock();
            TimestampedRegistration<K, V> tr = this.timestampedPriorityQueue.poll();
            try {
                if (tr.key != null) {
                    this.correlationMap.remove(tr.key);
                }
                v = tr.value;
            }
            catch (NullPointerException cause) {
                NoSuchElementException ex = new NoSuchElementException("The underlying collection is empty.");
                ex.initCause(cause);
                throw ex;
            }
            return v;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public List<V> removeAll() {
        try {
            this.rwLock.writeLock().lock();
            if (this.timestampedPriorityQueue.isEmpty()) {
                List list = Collections.emptyList();
                return list;
            }
            ArrayList<V> values = new ArrayList<V>(this.timestampedPriorityQueue.size());
            while (!this.timestampedPriorityQueue.isEmpty()) {
                values.add(this.removeOldest());
            }
            ArrayList<V> arrayList = values;
            return arrayList;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public boolean isEmpty() {
        try {
            this.rwLock.readLock().lock();
            boolean bl = this.timestampedPriorityQueue.isEmpty();
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public int size() {
        try {
            this.rwLock.readLock().lock();
            int n = this.timestampedPriorityQueue.size();
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public long getOldestRegistrationTimestamp() {
        try {
            this.rwLock.readLock().lock();
            try {
                long l = this.timestampedPriorityQueue.peek().timestamp;
                return l;
            }
            catch (NullPointerException cause) {
                NoSuchElementException ex = new NoSuchElementException("The underlying collection is empty.");
                ex.initCause(cause);
                throw ex;
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private void removeFromQueue(TimestampedRegistration<K, V> tr) {
        Iterator<TimestampedRegistration<K, V>> it = this.timestampedPriorityQueue.iterator();
        while (it.hasNext()) {
            if (it.next() != tr) continue;
            it.remove();
            break;
        }
    }

    private static class TimestampedRegistration<K, V>
    implements Comparable<TimestampedRegistration<K, V>> {
        private final long timestamp;
        private final K key;
        @NotNull
        private final V value;

        public TimestampedRegistration(long timestamp, K key, @NotNull V value) {
            this.timestamp = timestamp;
            this.key = key;
            this.value = value;
        }

        @Override
        public int compareTo(TimestampedRegistration<K, V> other) {
            return this.timestamp < other.timestamp ? -1 : (this.timestamp == other.timestamp ? 0 : 1);
        }
    }
}

