/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.secconv;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.AddressingUtils;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.MessageHeaders;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Engine;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.security.secconv.client.SCTokenConfiguration;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.impl.policyconv.PolicyID;
import com.sun.xml.ws.security.impl.policyconv.SecurityPolicyUtil;
import com.sun.xml.ws.security.policy.AlgorithmSuite;
import com.sun.xml.ws.security.policy.Binding;
import com.sun.xml.ws.security.policy.SecureConversationToken;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import com.sun.xml.ws.security.policy.Token;
import com.sun.xml.ws.security.secconv.WSSCClientContract;
import com.sun.xml.ws.security.secconv.WSSCFactory;
import com.sun.xml.ws.security.secconv.WSSCVersion;
import com.sun.xml.ws.security.secconv.WSSecureConversationException;
import com.sun.xml.ws.security.secconv.logging.LogStringsMessages;
import com.sun.xml.ws.security.trust.WSTrustConstants;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.ws.security.trust.elements.BaseSTSRequest;
import com.sun.xml.ws.security.trust.elements.BaseSTSResponse;
import com.sun.xml.ws.security.trust.elements.BinarySecret;
import com.sun.xml.ws.security.trust.elements.CancelTarget;
import com.sun.xml.ws.security.trust.elements.Entropy;
import com.sun.xml.ws.security.trust.elements.Lifetime;
import com.sun.xml.ws.security.trust.elements.RenewTarget;
import com.sun.xml.ws.security.trust.elements.RequestSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponse;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponseCollection;
import com.sun.xml.ws.security.trust.elements.str.SecurityTokenReference;
import com.sun.xml.ws.security.trust.util.WSTrustUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.policy.mls.DerivedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.SecureConversationTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.jaxws.impl.SecurityClientTube;
import com.sun.xml.wss.provider.wsit.WSITClientAuthContext;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.ws.soap.SOAPFaultException;
import java.io.StringWriter;
import java.net.URI;
import java.security.SecureRandom;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class WSSCPlugin {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.secconv", "com.sun.xml.ws.security.secconv.logging.LogStrings");
    private static final int DEFAULT_KEY_SIZE = 256;
    private static final String SC_ASSERTION = "SecureConversationAssertion";
    private static final String FOR_CANCEL = "For Cancel";
    private static SignaturePolicy renewSignaturePolicy = null;
    private static PolicyID pid = new PolicyID();
    private static Binding binding = null;
    private Engine fiberEngine;
    private Packet packet = null;

    public void process(IssuedTokenContext itc) {
        SCTokenConfiguration sctConfig = (SCTokenConfiguration)itc.getSecurityPolicy().get(0);
        WSSCVersion wsscVer = WSSCVersion.getInstance(sctConfig.getProtocol());
        WSTrustVersion wsTrustVer = null;
        wsTrustVer = wsscVer.getNamespaceURI().equals("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512") ? WSTrustVersion.WS_TRUST_13 : WSTrustVersion.WS_TRUST_10;
        this.packet = sctConfig.getPacket();
        int skl = 256;
        if (sctConfig.isSymmetricBinding()) {
            skl = sctConfig.getKeySize();
            if (skl < 1) {
                skl = 256;
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, LogStringsMessages.WSSC_1006_SYM_BIN_KEYSIZE(skl, 256));
            }
        }
        RequestSecurityToken rst = null;
        try {
            rst = this.createRequestSecurityToken(sctConfig, sctConfig.getReqClientEntropy(), skl);
        }
        catch (WSSecureConversationException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0024_ERROR_CREATING_RST(""), ex);
            throw new RuntimeException(LogStringsMessages.WSSC_0024_ERROR_CREATING_RST(""), ex);
        }
        BaseSTSResponse rstr = this.sendRequest(sctConfig, rst, itc.getEndpointAddress(), wsscVer.getSCTRequestAction());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_1012_RECEIVED_SCT_RSTR_ISSUE(WSTrustUtil.elemToString(rstr, wsTrustVer)));
        }
        try {
            this.processRequestSecurityTokenResponse(sctConfig, rst, rstr, itc);
        }
        catch (WSSecureConversationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void processRenew(IssuedTokenContext itc) {
        SCTokenConfiguration sctConfig = (SCTokenConfiguration)itc.getSecurityPolicy().get(0);
        WSSCVersion wsscVer = WSSCVersion.getInstance(sctConfig.getProtocol());
        WSTrustVersion wsTrustVer = null;
        wsTrustVer = wsscVer.getNamespaceURI().equals("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512") ? WSTrustVersion.WS_TRUST_13 : WSTrustVersion.WS_TRUST_10;
        this.packet = sctConfig.getPacket();
        int skl = 256;
        if (sctConfig.isSymmetricBinding()) {
            skl = sctConfig.getKeySize();
            if (skl < 1) {
                skl = 256;
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, LogStringsMessages.WSSC_1006_SYM_BIN_KEYSIZE(skl, 256));
            }
        }
        RequestSecurityToken rst = null;
        try {
            rst = this.createRequestSecurityTokenForRenew(itc, sctConfig.getReqClientEntropy(), skl);
        }
        catch (WSSecureConversationException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0024_ERROR_CREATING_RST(""), ex);
            throw new RuntimeException(LogStringsMessages.WSSC_0024_ERROR_CREATING_RST(""), ex);
        }
        this.createRenewSignaturePolicy(sctConfig.getSCToken());
        BaseSTSResponse rstr = this.sendRequest(sctConfig, rst, itc.getEndpointAddress(), wsscVer.getSCTRenewRequestAction());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_1014_RECEIVED_SCT_RSTR_RENEW(WSTrustUtil.elemToString(rstr, wsTrustVer)));
        }
        try {
            this.processRequestSecurityTokenResponse(sctConfig, rst, rstr, itc);
        }
        catch (WSSecureConversationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private BaseSTSResponse sendRequest(SCTokenConfiguration sctConfig, BaseSTSRequest rst, String endPointAddress, String action) {
        Unmarshaller unmarshaller;
        Marshaller marshaller;
        WSSCVersion wsscVer = WSSCVersion.getInstance(sctConfig.getProtocol());
        WSTrustVersion wsTrustVer = null;
        wsTrustVer = wsscVer.getNamespaceURI().equals("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512") ? WSTrustVersion.WS_TRUST_13 : WSTrustVersion.WS_TRUST_10;
        WSTrustElementFactory eleFac = WSTrustElementFactory.newInstance(wsTrustVer);
        JAXBContext jaxbContext = WSTrustElementFactory.getContext(wsTrustVer);
        try {
            marshaller = jaxbContext.createMarshaller();
            unmarshaller = jaxbContext.createUnmarshaller();
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, "WSSC0016.problem.mar.unmar", ex);
            throw new RuntimeException("Problem creating JAXB Marshaller/Unmarshaller", ex);
        }
        Message request = Messages.create((Marshaller)marshaller, (Object)eleFac.toJAXBElement(rst), (SOAPVersion)sctConfig.getWSBinding().getSOAPVersion());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_1009_SEND_REQ_MESSAGE(this.printMessageAsString(request)));
        }
        Packet reqPacket = new Packet(request);
        if (sctConfig.getSCToken() != null) {
            reqPacket.invocationProperties.put(SC_ASSERTION, sctConfig.getSCToken());
        }
        if (sctConfig.getPacket() != null) {
            for (WSTrustConstants.STS_PROPERTIES stsProperty : WSTrustConstants.STS_PROPERTIES.values()) {
                reqPacket.invocationProperties.put(stsProperty.toString(), sctConfig.getPacket().invocationProperties.get(stsProperty.toString()));
            }
        }
        reqPacket.endpointAddress = this.packet.endpointAddress;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_1008_SET_EP_ADDRESS(endPointAddress));
        }
        try {
            reqPacket = this.addAddressingHeaders(reqPacket, sctConfig.getWSDLPort(), sctConfig.getWSBinding(), action, sctConfig.getAddressingVersion());
        }
        catch (WSSecureConversationException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0017_PROBLEM_ADD_ADDRESS_HEADERS(), ex);
            throw new RuntimeException(LogStringsMessages.WSSC_0017_PROBLEM_ADD_ADDRESS_HEADERS(), ex);
        }
        if (sctConfig.getPacket() != null) {
            reqPacket.contentNegotiation = sctConfig.getPacket().contentNegotiation;
        }
        this.copyStandardSecurityProperties(sctConfig.getPacket(), reqPacket);
        Packet respPacket = null;
        if (sctConfig.getClientTube() != null) {
            reqPacket = ((SecurityClientTube)sctConfig.getClientTube()).processClientRequestPacket(reqPacket);
            Tube tubeline = sctConfig.getNextTube();
            Fiber fiber = this.getFiberEngine().createFiber();
            respPacket = fiber.runSync(tubeline, reqPacket);
            respPacket = ((SecurityClientTube)sctConfig.getClientTube()).processClientResponsePacket(respPacket);
        } else {
            WSITClientAuthContext wsitAuthCtx = (WSITClientAuthContext)sctConfig.getOtherOptions().get("WSITClientAuthContext");
            if (wsitAuthCtx != null) {
                try {
                    respPacket = wsitAuthCtx.secureRequest(reqPacket, null, true);
                }
                catch (XWSSecurityException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        Message response = respPacket.getMessage();
        BaseSTSResponse rstr = null;
        if (!response.isFault()) {
            JAXBElement rstrEle = null;
            try {
                rstrEle = (JAXBElement)response.readPayloadAsJAXB(unmarshaller);
            }
            catch (JAXBException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSSC_0018_ERR_JAXB_RSTR(), ex);
                throw new RuntimeException(LogStringsMessages.WSSC_0018_ERR_JAXB_RSTR(), ex);
            }
            if (wsscVer.getNamespaceURI().equals(WSSCVersion.WSSC_13.getNamespaceURI())) {
                try {
                    rstr = eleFac.createRSTRCollectionFrom(rstrEle);
                }
                catch (Exception e) {
                    rstr = eleFac.createRSTRFrom(rstrEle);
                }
            } else {
                rstr = eleFac.createRSTRFrom(rstrEle);
            }
        } else {
            try {
                throw new SOAPFaultException(response.readAsSOAPMessage().getSOAPBody().getFault());
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSSC_0022_PROBLEM_CREATING_FAULT(), ex);
                throw new RuntimeException(LogStringsMessages.WSSC_0022_PROBLEM_CREATING_FAULT(), ex);
            }
        }
        return rstr;
    }

    private AssertionSet getAssertions(SecureConversationToken scToken) {
        return scToken.getBootstrapPolicy().getAssertionSet();
    }

    public void processCancellation(IssuedTokenContext itc) {
        SCTokenConfiguration sctConfig = (SCTokenConfiguration)itc.getSecurityPolicy().get(0);
        WSSCVersion wsscVer = WSSCVersion.getInstance(sctConfig.getProtocol());
        WSTrustVersion wsTrustVer = null;
        wsTrustVer = wsscVer.getNamespaceURI().equals("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512") ? WSTrustVersion.WS_TRUST_13 : WSTrustVersion.WS_TRUST_10;
        this.packet = sctConfig.getPacket();
        RequestSecurityToken rst = null;
        try {
            rst = this.createRequestSecurityTokenForCancel(sctConfig, itc);
        }
        catch (WSSecureConversationException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0024_ERROR_CREATING_RST(FOR_CANCEL), ex);
            throw new RuntimeException(LogStringsMessages.WSSC_0024_ERROR_CREATING_RST(FOR_CANCEL), ex);
        }
        BaseSTSResponse rstr = this.sendRequest(sctConfig, rst, itc.getEndpointAddress(), wsscVer.getSCTCancelRequestAction());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_1016_RECEIVED_SCT_RSTR_CANCEL(WSTrustUtil.elemToString(rstr, wsTrustVer)));
        }
        try {
            this.processRequestSecurityTokenResponse(sctConfig, rst, rstr, itc);
        }
        catch (WSSecureConversationException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0020_PROBLEM_CREATING_RSTR(), ex);
            throw new RuntimeException(LogStringsMessages.WSSC_0020_PROBLEM_CREATING_RSTR(), ex);
        }
    }

    private RequestSecurityToken createRequestSecurityToken(SCTokenConfiguration sctConfig, boolean reqClientEntropy, int skl) throws WSSecureConversationException {
        WSSCVersion wsscVer = WSSCVersion.getInstance(sctConfig.getProtocol());
        WSTrustVersion wsTrustVer = null;
        wsTrustVer = wsscVer.getNamespaceURI().equals("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512") ? WSTrustVersion.WS_TRUST_13 : WSTrustVersion.WS_TRUST_10;
        WSTrustElementFactory eleFac = WSTrustElementFactory.newInstance(wsTrustVer);
        URI tokenType = URI.create(wsscVer.getSCTTokenTypeURI());
        URI requestType = URI.create(wsTrustVer.getIssueRequestTypeURI());
        SecureRandom random = new SecureRandom();
        byte[] rawValue = new byte[skl / 8];
        random.nextBytes(rawValue);
        BinarySecret secret = eleFac.createBinarySecret(rawValue, wsTrustVer.getNonceBinarySecretTypeURI());
        Entropy entropy = reqClientEntropy ? eleFac.createEntropy(secret) : null;
        Lifetime lifetime = null;
        if (sctConfig.getSCTokenTimeout() > 0L) {
            long currentTime = WSTrustUtil.getCurrentTimeWithOffset();
            lifetime = WSTrustUtil.createLifetime(currentTime, sctConfig.getSCTokenTimeout(), wsTrustVer);
        }
        RequestSecurityToken rst = null;
        try {
            rst = eleFac.createRSTForIssue(tokenType, requestType, null, null, null, entropy, lifetime);
            rst.setKeySize(skl);
            rst.setKeyType(URI.create(wsTrustVer.getSymmetricKeyTypeURI()));
            rst.setComputedKeyAlgorithm(URI.create(wsTrustVer.getCKPSHA1algorithmURI()));
        }
        catch (WSTrustException ex) {
            throw new WSSecureConversationException(ex);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_1011_CREATED_SCT_RST_ISSUE(WSTrustUtil.elemToString(rst, wsTrustVer)));
        }
        return rst;
    }

    private RequestSecurityToken createRequestSecurityTokenForRenew(IssuedTokenContext itc, boolean reqClientEntropy, int skl) throws WSSecureConversationException {
        SCTokenConfiguration sctConfig = (SCTokenConfiguration)itc.getSecurityPolicy().get(0);
        WSSCVersion wsscVer = WSSCVersion.getInstance(sctConfig.getProtocol());
        WSTrustVersion wsTrustVer = null;
        wsTrustVer = wsscVer.getNamespaceURI().equals("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512") ? WSTrustVersion.WS_TRUST_13 : WSTrustVersion.WS_TRUST_10;
        WSTrustElementFactory eleFac = WSTrustElementFactory.newInstance(wsTrustVer);
        URI tokenType = URI.create(wsscVer.getSCTTokenTypeURI());
        URI requestType = URI.create(wsTrustVer.getRenewRequestTypeURI());
        SecureRandom random = new SecureRandom();
        byte[] rawValue = new byte[skl / 8];
        random.nextBytes(rawValue);
        BinarySecret secret = eleFac.createBinarySecret(rawValue, wsTrustVer.getNonceBinarySecretTypeURI());
        Entropy entropy = reqClientEntropy ? eleFac.createEntropy(secret) : null;
        RenewTarget target = eleFac.createRenewTarget((SecurityTokenReference)itc.getUnAttachedSecurityTokenReference());
        RequestSecurityToken rst = null;
        try {
            rst = eleFac.createRSTForRenew(tokenType, requestType, null, target, null, null);
            rst.setEntropy(entropy);
            rst.setKeySize(skl);
            rst.setKeyType(URI.create(wsTrustVer.getSymmetricKeyTypeURI()));
            rst.setComputedKeyAlgorithm(URI.create(wsTrustVer.getCKPSHA1algorithmURI()));
        }
        catch (WSTrustException ex) {
            throw new WSSecureConversationException(ex);
        }
        Lifetime lifetime = null;
        if (sctConfig.getSCTokenTimeout() > 0L) {
            long currentTime = WSTrustUtil.getCurrentTimeWithOffset();
            lifetime = WSTrustUtil.createLifetime(currentTime, sctConfig.getSCTokenTimeout(), wsTrustVer);
            rst.setLifetime(lifetime);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_1013_CREATED_SCT_RST_RENEW(WSTrustUtil.elemToString(rst, wsTrustVer)));
        }
        return rst;
    }

    private RequestSecurityToken createRequestSecurityTokenForCancel(SCTokenConfiguration sctConfig, IssuedTokenContext ctx) throws WSSecureConversationException {
        WSSCVersion wsscVer = WSSCVersion.getInstance(sctConfig.getProtocol());
        WSTrustVersion wsTrustVer = null;
        wsTrustVer = wsscVer.getNamespaceURI().equals("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512") ? WSTrustVersion.WS_TRUST_13 : WSTrustVersion.WS_TRUST_10;
        WSTrustElementFactory eleFac = WSTrustElementFactory.newInstance(wsTrustVer);
        URI requestType = URI.create(wsTrustVer.getCancelRequestTypeURI());
        CancelTarget target = eleFac.createCancelTarget((SecurityTokenReference)ctx.getUnAttachedSecurityTokenReference());
        RequestSecurityToken rst = eleFac.createRSTForCancel(requestType, target);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_1015_CREATED_SCT_RST_CANCEL(WSTrustUtil.elemToString(rst, wsTrustVer)));
        }
        return rst;
    }

    private void processRequestSecurityTokenResponse(SCTokenConfiguration sctConfig, BaseSTSRequest rst, BaseSTSResponse rstr, IssuedTokenContext context) throws WSSecureConversationException {
        WSSCVersion wsscVer = WSSCVersion.getInstance(sctConfig.getProtocol());
        WSSCClientContract contract = WSSCFactory.newWSSCClientContract();
        if (wsscVer.getNamespaceURI().equals(WSSCVersion.WSSC_13.getNamespaceURI())) {
            try {
                contract.handleRSTRC((RequestSecurityToken)rst, (RequestSecurityTokenResponseCollection)rstr, context);
            }
            catch (Exception ex) {
                contract.handleRSTR((RequestSecurityToken)rst, (RequestSecurityTokenResponse)rstr, context);
            }
        } else {
            contract.handleRSTR((RequestSecurityToken)rst, (RequestSecurityTokenResponse)rstr, context);
        }
    }

    private String printMessageAsString(Message message) {
        StringWriter writer = new StringWriter();
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        try {
            XMLStreamWriter streamWriter = factory.createXMLStreamWriter(writer);
            message.writeTo(streamWriter);
            streamWriter.flush();
            return writer.toString();
        }
        catch (XMLStreamException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0025_PROBLEM_PRINTING_MSG(), ex);
            throw new RuntimeException(LogStringsMessages.WSSC_0025_PROBLEM_PRINTING_MSG(), ex);
        }
    }

    private Packet addAddressingHeaders(Packet packet, WSDLPort wsdlPort, WSBinding binding, String action, AddressingVersion addVer) throws WSSecureConversationException {
        MessageHeaders list = packet.getMessage().getHeaders();
        AddressingUtils.fillRequestAddressingHeaders((MessageHeaders)list, (Packet)packet, (AddressingVersion)addVer, (SOAPVersion)binding.getSOAPVersion(), (boolean)false, (String)action);
        return packet;
    }

    private void copyStandardSecurityProperties(Packet packet, Packet requestPacket) {
        Set set = packet.invocationProperties.keySet();
        for (String key : set) {
            requestPacket.invocationProperties.put(key, packet.invocationProperties.get(key));
        }
    }

    private void createRenewSignaturePolicy(Token token) {
        renewSignaturePolicy = new SignaturePolicy();
        renewSignaturePolicy.setUUID("_99");
        SecurityPolicyVersion spVersion = token.getSecurityPolicyVersion();
        SecureConversationTokenKeyBinding sct = new SecureConversationTokenKeyBinding();
        SecureConversationToken scToken = (SecureConversationToken)token;
        if (scToken.isRequireDerivedKeys()) {
            DerivedTokenKeyBinding dtKB = new DerivedTokenKeyBinding();
            dtKB.setOriginalKeyBinding(sct);
            renewSignaturePolicy.setKeyBinding(dtKB);
            dtKB.setUUID("_100");
        } else {
            renewSignaturePolicy.setKeyBinding(sct);
        }
        if (spVersion == SecurityPolicyVersion.SECURITYPOLICY200507) {
            sct.setIncludeToken(token.getIncludeToken());
        } else {
            sct.setIncludeToken(SecurityPolicyVersion.SECURITYPOLICY200507.includeTokenAlwaysToRecipient);
        }
        sct.setUUID(token.getTokenId());
        AssertionSet assertions = this.getAssertions(scToken);
        for (PolicyAssertion policyAssertion : assertions) {
            if (!PolicyUtil.isBinding(policyAssertion, spVersion)) continue;
            binding = (Binding)policyAssertion;
        }
        SignaturePolicy.FeatureBinding spFB = (SignaturePolicy.FeatureBinding)renewSignaturePolicy.getFeatureBinding();
        AlgorithmSuite as = binding.getAlgorithmSuite();
        SecurityPolicyUtil.setCanonicalizationMethod(spFB, as);
    }

    public SignaturePolicy getRenewSignaturePolicy() {
        return renewSignaturePolicy;
    }

    public AlgorithmSuite getAlgorithmSuite() {
        return binding.getAlgorithmSuite();
    }

    private SecurityPolicyVersion getSPVersion(PolicyAssertion pa) {
        String nsUri = pa.getName().getNamespaceURI();
        SecurityPolicyVersion spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;
        if (SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri.equals(nsUri)) {
            spVersion = SecurityPolicyVersion.SECURITYPOLICY12NS;
        }
        return spVersion;
    }

    private Engine getFiberEngine() {
        if (this.fiberEngine == null) {
            this.fiberEngine = Fiber.current().owner;
        }
        return this.fiberEngine;
    }
}

