/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.crypto.dsig;

import com.sun.xml.security.core.dsig.ReferenceType;
import com.sun.xml.ws.security.opt.crypto.dsig.DigestMethod;
import com.sun.xml.ws.security.opt.crypto.dsig.Transform;
import com.sun.xml.ws.security.opt.crypto.dsig.internal.DigesterOutputStream;
import com.sun.xml.ws.security.opt.impl.util.StreamUtil;
import com.sun.xml.wss.logging.impl.opt.signature.LogStringsMessages;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.Data;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;
import org.apache.xml.security.utils.UnsyncBufferedOutputStream;

@XmlRootElement(name="Reference", namespace="http://www.w3.org/2000/09/xmldsig#")
public class Reference
extends ReferenceType
implements javax.xml.crypto.dsig.Reference {
    @XmlTransient
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt.signature", "com.sun.xml.wss.logging.impl.opt.signature.LogStrings");
    @XmlTransient
    private Data _appliedTransformData;
    @XmlTransient
    private MessageDigest _md;
    @XmlTransient
    private boolean _validated;
    @XmlTransient
    private boolean _validationStatus;
    @XmlTransient
    private byte[] _calcDigestValue;

    @Override
    public byte[] getCalculatedDigestValue() {
        return this._calcDigestValue;
    }

    @Override
    public boolean validate(XMLValidateContext xMLValidateContext) throws XMLSignatureException {
        if (xMLValidateContext == null) {
            throw new NullPointerException("validateContext cannot be null");
        }
        if (this._validated) {
            return this._validationStatus;
        }
        Data data = this.dereference(xMLValidateContext);
        this._calcDigestValue = this.transform(data, xMLValidateContext);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Calculated digest value is: " + new String(this._calcDigestValue));
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, " Expected digest value is: " + new String(this.digestValue));
        }
        this._validationStatus = Arrays.equals(this.digestValue, this._calcDigestValue);
        this._validated = true;
        return this._validationStatus;
    }

    public void digest(XMLCryptoContext signContext) throws XMLSignatureException {
        if (this.getDigestValue() == null) {
            Data data = null;
            data = this._appliedTransformData == null ? this.dereference(signContext) : this._appliedTransformData;
            byte[] digest = this.transform(data, signContext);
            this.setDigestValue(digest);
        }
    }

    public DigesterOutputStream getDigestOutputStream() throws XMLSignatureException {
        try {
            String algo = StreamUtil.convertDigestAlgorithm(this.getDigestMethod().getAlgorithm());
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Digest Algorithm is " + this.getDigestMethod().getAlgorithm());
                logger.log(Level.FINE, "Mapped Digest Algorithm is " + algo);
            }
            this._md = MessageDigest.getInstance(algo);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new XMLSignatureException(nsae);
        }
        DigesterOutputStream dos = new DigesterOutputStream(this._md);
        return dos;
    }

    private byte[] transform(Data dereferencedData, XMLCryptoContext context) throws XMLSignatureException {
        List<Transform> transformList;
        if (this._md == null) {
            try {
                String algo = StreamUtil.convertDigestAlgorithm(this.getDigestMethod().getAlgorithm());
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Digest Algorithm is " + this.getDigestMethod().getAlgorithm());
                    logger.log(Level.FINE, "Mapped Digest Algorithm is " + algo);
                }
                this._md = MessageDigest.getInstance(algo);
            }
            catch (NoSuchAlgorithmException nsae) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1760_DIGEST_INIT_ERROR(), nsae);
                throw new XMLSignatureException(nsae);
            }
        }
        this._md.reset();
        DigesterOutputStream dos = new DigesterOutputStream(this._md);
        UnsyncBufferedOutputStream os = new UnsyncBufferedOutputStream((OutputStream)dos);
        Data data = dereferencedData;
        if (this.transforms != null && (transformList = this.transforms.getTransform()) != null) {
            int size = transformList.size();
            for (int i = 0; i < size; ++i) {
                Transform transform = transformList.get(i);
                try {
                    if (i < size - 1) {
                        data = transform.transform(data, context);
                        continue;
                    }
                    data = transform.transform(data, context, (OutputStream)os);
                    continue;
                }
                catch (TransformException te) {
                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1759_TRANSFORM_ERROR(te.getMessage()), te);
                    throw new XMLSignatureException(te);
                }
            }
        }
        try {
            os.flush();
            dos.flush();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1761_TRANSFORM_IO_ERROR(), ex);
            throw new XMLSignatureException(ex);
        }
        return dos.getDigestValue();
    }

    private Data dereference(XMLCryptoContext context) throws XMLSignatureException {
        Data data = null;
        URIDereferencer deref = context.getURIDereferencer();
        try {
            data = deref.dereference(this, context);
        }
        catch (URIReferenceException ure) {
            throw new XMLSignatureException(ure);
        }
        return data;
    }

    @Override
    public Data getDereferencedData() {
        return this._appliedTransformData;
    }

    @Override
    public InputStream getDigestInputStream() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public boolean isFeatureSupported(String string) {
        return false;
    }

    @Override
    public DigestMethod getDigestMethod() {
        return this.digestMethod;
    }

    public List getTransforms() {
        return this.transforms.getTransform();
    }
}

