/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.server;

import com.sun.istack.NotNull;
import com.sun.xml.ws.transport.http.DeploymentDescriptorParser;
import com.sun.xml.ws.transport.http.ResourceLoader;
import com.sun.xml.ws.transport.tcp.grizzly.GrizzlyTCPConnector;
import com.sun.xml.ws.transport.tcp.resources.MessagesMessages;
import com.sun.xml.ws.transport.tcp.server.TCPAdapter;
import com.sun.xml.ws.transport.tcp.server.TCPContext;
import com.sun.xml.ws.transport.tcp.server.TCPResourceLoader;
import com.sun.xml.ws.transport.tcp.server.TCPStandaloneContext;
import com.sun.xml.ws.transport.tcp.server.WSTCPConnector;
import com.sun.xml.ws.transport.tcp.server.WSTCPDelegate;
import com.sun.xml.ws.transport.tcp.util.WSTCPURI;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class WSTCP {
    private static final Logger logger = Logger.getLogger("com.sun.metro.transport.tcp.server");
    private static final String JAXWS_RI_RUNTIME = "WEB-INF/sun-jaxws.xml";
    private static final String ENABLE_PROTOCOL_CHECK = "-enableProtocolCheck";
    private final TCPContext context;
    private final ClassLoader initClassLoader;
    private WSTCPDelegate delegate;
    private Collection<WSTCPConnector> connectors;
    private final String contextPath;
    private boolean isProtocolCheck;

    public WSTCP(@NotNull TCPContext context, @NotNull ClassLoader initClassLoader, @NotNull String contextPath) {
        this.context = context;
        this.initClassLoader = initClassLoader;
        this.contextPath = contextPath;
    }

    public boolean isProtocolCheck() {
        return this.isProtocolCheck;
    }

    public void setProtocolCheck(boolean isProtocolCheck) {
        this.isProtocolCheck = isProtocolCheck;
    }

    @NotNull
    public List<TCPAdapter> parseDeploymentDescriptor() throws IOException {
        DeploymentDescriptorParser parser = new DeploymentDescriptorParser(this.initClassLoader, (ResourceLoader)new TCPResourceLoader(this.context), null, TCPAdapter.FACTORY);
        URL sunJaxWsXml = this.context.getResource(JAXWS_RI_RUNTIME);
        return parser.parse(sunJaxWsXml.toExternalForm(), sunJaxWsXml.openStream());
    }

    @NotNull
    public Collection<WSTCPConnector> initialize() throws IOException {
        List<TCPAdapter> adapters = this.parseDeploymentDescriptor();
        this.delegate = new WSTCPDelegate();
        LinkedList<WSTCPConnector> connectors = new LinkedList<WSTCPConnector>();
        Iterator<TCPAdapter> it = adapters.iterator();
        while (it.hasNext()) {
            TCPAdapter adapter = it.next();
            URI uri = adapter.getEndpoint().getPort().getAddress().getURI();
            WSTCPURI tcpURI = WSTCPURI.parse(uri);
            if (this.isProtocolCheck && !"vnd.sun.ws.tcp".equals(uri.getScheme())) {
                logger.log(Level.INFO, MessagesMessages.WSTCP_2002_STANDALONE_ADAPTER_NOT_REGISTERED(adapter.name, adapter.urlPattern));
                it.remove();
                continue;
            }
            GrizzlyTCPConnector connector = new GrizzlyTCPConnector(tcpURI.host, tcpURI.port, this.delegate);
            connector.listen();
            connectors.add(connector);
            logger.log(Level.FINE, MessagesMessages.WSTCP_2001_STANDALONE_ADAPTER_REGISTERED(adapter.name, adapter.urlPattern));
        }
        this.delegate.registerAdapters(this.contextPath, adapters);
        return connectors;
    }

    public void process() throws IOException {
        this.connectors = this.initialize();
    }

    public void close() {
        if (this.connectors != null) {
            for (WSTCPConnector connector : this.connectors) {
                connector.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        HashSet<String> params = new HashSet<String>();
        if (args.length < 1) {
            System.out.println(MessagesMessages.STANDALONE_RUN());
            System.exit(0);
        }
        for (int i = 1; i < args.length; ++i) {
            params.add(args[i]);
        }
        String contextPath = args[0];
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        TCPStandaloneContext context = new TCPStandaloneContext(classloader);
        wsTCP.setProtocolCheck(params.contains(ENABLE_PROTOCOL_CHECK));
        try (WSTCP wsTCP = new WSTCP(context, classloader, contextPath);){
            wsTCP.process();
            System.out.println(MessagesMessages.STANDALONE_EXIT());
            System.in.read();
        }
    }
}

