/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.xmlfilter;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.xmlfilter.Invocation;
import com.sun.xml.ws.xmlfilter.InvocationProcessor;
import com.sun.xml.ws.xmlfilter.InvocationProcessorFactory;
import com.sun.xml.ws.xmlfilter.localization.LocalizationMessages;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class EnhancedXmlStreamWriterProxy
implements InvocationHandler {
    private static final Logger LOGGER = Logger.getLogger(EnhancedXmlStreamWriterProxy.class);
    private static final Class<?>[] PROXIED_INTERFACES = new Class[]{XMLStreamWriter.class};
    private static final Method hashCodeMethod;
    private static final Method equalsMethod;
    private static final Method toStringMethod;
    private final InvocationProcessor invocationProcessor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamWriter createProxy(XMLStreamWriter writer, InvocationProcessorFactory processorFactory) throws XMLStreamException {
        XMLStreamWriter xMLStreamWriter;
        LOGGER.entering();
        XMLStreamWriter proxy = null;
        try {
            xMLStreamWriter = proxy = (XMLStreamWriter)Proxy.newProxyInstance(writer.getClass().getClassLoader(), PROXIED_INTERFACES, (InvocationHandler)new EnhancedXmlStreamWriterProxy(writer, processorFactory));
        }
        catch (Throwable throwable) {
            LOGGER.exiting(proxy);
            throw throwable;
        }
        LOGGER.exiting((Object)proxy);
        return xMLStreamWriter;
    }

    private EnhancedXmlStreamWriterProxy(XMLStreamWriter writer, InvocationProcessorFactory processorFactory) throws XMLStreamException {
        this.invocationProcessor = processorFactory.createInvocationProcessor(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        block4: {
            Object object;
            if (LOGGER.isMethodCallLoggable()) {
                LOGGER.entering(new Object[]{method, args});
            }
            result = null;
            try {
                Class<?> declaringClass = method.getDeclaringClass();
                if (declaringClass != Object.class) break block4;
                object = this.handleObjectMethodCall(proxy, method, args);
            }
            catch (Throwable throwable) {
                LOGGER.exiting(result);
                throw throwable;
            }
            LOGGER.exiting(result);
            return object;
        }
        Invocation invocation = Invocation.createInvocation(method, args);
        Object object = result = this.invocationProcessor.process(invocation);
        LOGGER.exiting(result);
        return object;
    }

    private Object handleObjectMethodCall(Object proxy, Method method, Object[] args) {
        if (method.equals(hashCodeMethod)) {
            return System.identityHashCode(proxy);
        }
        if (method.equals(equalsMethod)) {
            return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
        }
        if (method.equals(toStringMethod)) {
            return proxy.getClass().getName() + "@" + Integer.toHexString(proxy.hashCode());
        }
        throw (InternalError)LOGGER.logSevereException((Throwable)new InternalError(LocalizationMessages.XMLF_5002_UNEXPECTED_OBJECT_METHOD(method)));
    }

    static {
        try {
            hashCodeMethod = Object.class.getMethod("hashCode", new Class[0]);
            equalsMethod = Object.class.getMethod("equals", Object.class);
            toStringMethod = Object.class.getMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw (NoSuchMethodError)LOGGER.logSevereException((Throwable)new NoSuchMethodError(e.getMessage()), (Throwable)e);
        }
    }
}

