/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.protocol.wsrm200702;

import com.sun.xml.ws.rx.rm.protocol.CreateSequenceData;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.Expires;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.IncompleteSequenceBehaviorType;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.OfferType;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.ws.EndpointReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="CreateSequenceType", propOrder={"acksTo", "any", "expires", "offer", "securityTokenReference"})
@XmlRootElement(name="CreateSequence", namespace="http://docs.oasis-open.org/ws-rx/wsrm/200702")
public class CreateSequenceElement {
    @XmlElement(name="AcksTo", required=true, namespace="http://docs.oasis-open.org/ws-rx/wsrm/200702")
    protected EndpointReference acksTo;
    @XmlElement(name="Expires", namespace="http://docs.oasis-open.org/ws-rx/wsrm/200702")
    protected Expires expires;
    @XmlElement(name="Offer", namespace="http://docs.oasis-open.org/ws-rx/wsrm/200702")
    protected OfferType offer;
    @XmlAnyElement(lax=true)
    protected List<Object> any;
    @XmlElement(name="SecurityTokenReference", namespace="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")
    private SecurityTokenReferenceType securityTokenReference;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    public CreateSequenceElement() {
    }

    public CreateSequenceElement(CreateSequenceData data) {
        this();
        this.acksTo = data.getAcksToEpr();
        if (!data.doesNotExpire()) {
            this.expires = new Expires(data.getDuration());
        }
        if (data.getOfferedSequenceId() != null) {
            this.offer = new OfferType();
            this.offer.setId(data.getOfferedSequenceId());
            this.offer.setEndpoint(data.getAcksToEpr());
            if (!data.offeredSequenceDoesNotExpire()) {
                this.offer.setExpires(new Expires(data.getOfferedSequenceExpiry()));
            }
            if (data.getOfferedSequenceIncompleteBehavior() != Sequence.IncompleteSequenceBehavior.getDefault()) {
                this.offer.setIncompleteSequenceBehavior(IncompleteSequenceBehaviorType.fromISB(data.getOfferedSequenceIncompleteBehavior()));
            }
        }
        if (data.getStrType() != null) {
            this.securityTokenReference = data.getStrType();
        }
    }

    public CreateSequenceData.Builder toDataBuilder() {
        CreateSequenceData.Builder dataBuilder = CreateSequenceData.getBuilder(this.getAcksTo());
        dataBuilder.strType(this.securityTokenReference);
        if (this.expires != null) {
            dataBuilder.duration(this.expires.getDuration());
        }
        if (this.offer != null) {
            dataBuilder.offeredInboundSequenceId(this.offer.getId());
            if (this.offer.getExpires() != null) {
                dataBuilder.offeredSequenceExpiry(this.offer.getExpires().getDuration());
            }
            if (this.offer.getIncompleteSequenceBehavior() != null) {
                dataBuilder.offeredSequenceIncompleteBehavior(this.offer.getIncompleteSequenceBehavior().translate());
            }
        }
        return dataBuilder;
    }

    public EndpointReference getAcksTo() {
        return this.acksTo;
    }

    public void setAcksTo(EndpointReference value) {
        this.acksTo = value;
    }

    public Expires getExpires() {
        return this.expires;
    }

    public void setExpires(Expires value) {
        this.expires = value;
    }

    public OfferType getOffer() {
        return this.offer;
    }

    public void setOffer(OfferType value) {
        this.offer = value;
    }

    public List<Object> getAny() {
        if (this.any == null) {
            this.any = new ArrayList<Object>();
        }
        return this.any;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    public SecurityTokenReferenceType getSecurityTokenReference() {
        return this.securityTokenReference;
    }

    public void setSecurityTokenReference(SecurityTokenReferenceType securityTokenReference) {
        this.securityTokenReference = securityTokenReference;
    }
}

