/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.internal;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.tx.at.WSATException;
import com.sun.xml.ws.tx.at.WSATHelper;
import com.sun.xml.ws.tx.at.common.TransactionImportManager;
import com.sun.xml.ws.tx.at.common.TransactionManagerImpl;
import com.sun.xml.ws.tx.at.internal.ForeignRecoveryContext;
import com.sun.xml.ws.tx.at.internal.ForeignRecoveryContextManager;
import com.sun.xml.ws.tx.at.internal.WSATGatewayRM;
import com.sun.xml.ws.tx.at.internal.XidImpl;
import com.sun.xml.ws.tx.at.runtime.TransactionServices;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import javax.xml.ws.EndpointReference;

public class TransactionServicesImpl
implements TransactionServices {
    private static TransactionServices INSTANCE;
    static List<Xid> importedXids;

    public static TransactionServices getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TransactionServicesImpl();
        }
        return INSTANCE;
    }

    private TransactionServicesImpl() {
        ForeignRecoveryContextManager.getInstance().start();
    }

    public byte[] getGlobalTransactionId() {
        return new byte[]{97};
    }

    public Xid enlistResource(XAResource resource, Xid xid) throws WSATException {
        WSATGatewayRM wsatgw = WSATGatewayRM.getInstance();
        if (wsatgw == null) {
            throw new WSATException("WS-AT gateway not deployed.");
        }
        Transaction transaction = WSATHelper.getInstance().getFromXidToTransactionMap(xid);
        try {
            return wsatgw.registerWSATResource(xid, resource, transaction);
        }
        catch (IllegalStateException e) {
            throw new WSATException(e);
        }
        catch (RollbackException e) {
            throw new WSATException((Exception)((Object)e));
        }
        catch (SystemException e) {
            throw new WSATException((Exception)((Object)e));
        }
    }

    public void registerSynchronization(Synchronization synchronization, Xid xid) throws WSATException {
        this.log("regsync");
    }

    public int getExpires() {
        return 30000;
    }

    public Xid importTransaction(int timeout, byte[] tId) throws WSATException {
        XidImpl xidImpl = new XidImpl(tId);
        if (importedXids.contains(xidImpl)) {
            return xidImpl;
        }
        TransactionImportManager.getInstance().recreate(xidImpl, timeout);
        importedXids.add(xidImpl);
        return null;
    }

    public String prepare(byte[] tId) throws WSATException {
        int vote;
        this.log("prepare");
        XidImpl xidImpl = new XidImpl(tId);
        ForeignRecoveryContextManager.getInstance().persist(xidImpl);
        try {
            vote = TransactionImportManager.getInstance().getXATerminator().prepare((Xid)xidImpl);
        }
        catch (XAException ex) {
            Logger.getLogger(TransactionServicesImpl.class).log(Level.SEVERE, null, (Throwable)ex);
            throw new WSATException(ex);
        }
        return vote == 0 ? "Prepared" : "ReadOnly";
    }

    public void commit(byte[] tId) throws WSATException {
        this.log("commit");
        XidImpl xidImpl = new XidImpl(tId);
        try {
            TransactionImportManager.getInstance().getXATerminator().commit((Xid)xidImpl, false);
        }
        catch (XAException ex) {
            Logger.getLogger(TransactionServicesImpl.class).log(Level.SEVERE, null, (Throwable)ex);
            throw new WSATException(ex);
        }
    }

    public void rollback(byte[] tId) throws WSATException {
        this.log("rollback");
        XidImpl xidImpl = new XidImpl(tId);
        try {
            TransactionImportManager.getInstance().getXATerminator().rollback((Xid)xidImpl);
        }
        catch (XAException ex) {
            Logger.getLogger(TransactionServicesImpl.class).log(Level.SEVERE, null, (Throwable)ex);
            throw new WSATException(ex);
        }
    }

    public void replayCompletion(String tId, XAResource xaResource) throws WSATException {
        this.log("replayCompleiton");
    }

    public EndpointReference getParentReference(Xid xid) {
        this.log("getParentReference");
        if (xid == null) {
            throw new IllegalArgumentException("No subordinate transaction " + xid);
        }
        ForeignRecoveryContext foreignRecoveryContext = (ForeignRecoveryContext)TransactionManagerImpl.getInstance().getResource("com.sun.xml.ws.tx.foreignContext");
        if (foreignRecoveryContext == null) {
            throw new AssertionError((Object)("No recovery context associated with transaction " + xid));
        }
        return foreignRecoveryContext.getEndpointReference();
    }

    private void log(String msg) {
    }

    static {
        importedXids = new ArrayList<Xid>();
    }
}

