/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.runtime.dev;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.runtime.dev.Session;
import com.sun.xml.ws.runtime.dev.SessionManagerImpl;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextTokenInfo;
import com.sun.xml.ws.util.ServiceFinder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedObject
@Description(value="Session manager used by RM and SC")
@AMXMetadata(type="WSRMSCSessionManager")
public abstract class SessionManager {
    private static final Logger LOGGER = Logger.getLogger(SessionManager.class);
    private static final Object LOCK = new Object();
    private static final Map<WSEndpoint, SessionManager> SESSION_MANAGERS = new HashMap<WSEndpoint, SessionManager>();

    public abstract Session getSession(String var1);

    @ManagedAttribute
    @Description(value="The set of valid Session keys")
    public abstract Set<String> keys();

    @ManagedAttribute
    @Description(value="The collection of valid Sessions")
    protected abstract Collection<Session> sessions();

    public abstract void terminateSession(String var1);

    public abstract Session createSession(String var1, Class var2);

    public abstract Session createSession(String var1, Object var2);

    public abstract Session createSession(String var1, SecurityContextTokenInfo var2);

    public abstract Session createSession(String var1);

    public abstract void saveSession(String var1);

    public abstract IssuedTokenContext getSecurityContext(String var1, boolean var2);

    public abstract void addSecurityContext(String var1, IssuedTokenContext var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSessionManager(WSEndpoint endpoint) {
        Object object = LOCK;
        synchronized (object) {
            try {
                LOGGER.entering();
                SessionManager o = SESSION_MANAGERS.remove(endpoint);
                LOGGER.config(String.format("removeSessionManager(%s): %s", endpoint, o));
                if (o != null) {
                    endpoint.getManagedObjectManager().unregister((Object)o);
                }
            }
            finally {
                LOGGER.exiting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SessionManager getSessionManager(WSEndpoint endpoint, boolean isSC) {
        Object object = LOCK;
        synchronized (object) {
            SessionManager sessionManager;
            try {
                LOGGER.entering();
                SessionManager sm = SESSION_MANAGERS.get(endpoint);
                if (sm == null) {
                    ServiceFinder finder = ServiceFinder.find(SessionManager.class);
                    sm = finder != null && ((SessionManager[])finder.toArray()).length > 0 ? ((SessionManager[])finder.toArray())[0] : new SessionManagerImpl(endpoint, isSC);
                    SESSION_MANAGERS.put(endpoint, sm);
                    endpoint.getManagedObjectManager().registerAtRoot((Object)sm, "RM_SC_SessionManager");
                    LOGGER.config(String.format("getSessionManager(%s): created: %s", endpoint, sm));
                } else {
                    LOGGER.config(String.format("getSessionManager(%s): found existing: %s", endpoint, sm));
                }
                sessionManager = sm;
            }
            catch (Throwable throwable) {
                LOGGER.exiting();
                throw throwable;
            }
            LOGGER.exiting();
            return sessionManager;
        }
    }

    public static SessionManager getSessionManager(WSEndpoint endpoint) {
        return SessionManager.getSessionManager(endpoint, false);
    }
}

