/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.commons.ha;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.ha.HaInfo;
import com.sun.xml.ws.api.message.Packet;
import java.util.logging.Level;

public class HaContext {
    private static final Logger LOGGER = Logger.getLogger(HaContext.class);
    private static final ThreadLocal<State> state = new ThreadLocal<State>(){

        @Override
        protected State initialValue() {
            return new State(null, null);
        }
    };

    public static State initFrom(Packet packet) {
        State oldState = state.get();
        HaInfo haInfo = null;
        if (packet != null && packet.supports((Object)"com.sun.xml.ws.api.message.packet.hainfo")) {
            haInfo = (HaInfo)packet.get((Object)"com.sun.xml.ws.api.message.packet.hainfo");
        }
        State newState = new State(packet, haInfo);
        state.set(newState);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("[METRO-HA] : Initialized from packet - replaced old " + (oldState == null ? null : oldState.toString()) + "with new " + (newState == null ? null : newState.toString()));
        }
        return oldState;
    }

    public static State initFrom(State newState) {
        State oldState = state.get();
        state.set(newState);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("[METRO-HA] : Initialized from state - replaced old " + (oldState == null ? null : oldState.toString()) + "with new " + (newState == null ? null : newState.toString()));
        }
        return oldState;
    }

    public static State currentState() {
        return state.get();
    }

    public static void clear() {
        state.get().haInfo = null;
        state.get().packet = null;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("[METRO-HA] : Current HA state cleared");
        }
    }

    public static HaInfo currentHaInfo() {
        return state.get().haInfo;
    }

    public static void updateHaInfo(HaInfo newValue) {
        state.get().haInfo = newValue;
        if (state.get().packet != null && state.get().packet.supports((Object)"com.sun.xml.ws.api.message.packet.hainfo")) {
            state.get().packet.put("com.sun.xml.ws.api.message.packet.hainfo", (Object)newValue);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("[METRO-HA] : HaInfo value updated: " + HaContext.asString(newValue));
        }
    }

    public static boolean failoverDetected() {
        HaInfo haInfo = state.get().haInfo;
        return haInfo != null && haInfo.isFailOver();
    }

    public static String asString(HaInfo haInfo) {
        return "HaInfo{hashableKey=" + haInfo.getKey() + ", replicaInstance=" + haInfo.getReplicaInstance() + ", isFailover=" + haInfo.isFailOver() + "}";
    }

    public static final class State {
        private Packet packet;
        private HaInfo haInfo;

        private State(Packet packet, HaInfo haInfo) {
            this.packet = packet;
            this.haInfo = haInfo;
        }

        public String toString() {
            return "HaState{packet=" + this.packet + ", haInfo=" + this.haInfo + '}';
        }
    }
}

