/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.io;

import com.sun.xml.ws.transport.tcp.io.DataInOutUtils;
import com.sun.xml.ws.transport.tcp.io.OutputWriter;
import com.sun.xml.ws.transport.tcp.pool.LifeCycle;
import com.sun.xml.ws.transport.tcp.util.ByteBufferFactory;
import com.sun.xml.ws.transport.tcp.util.FrameType;
import com.sun.xml.ws.transport.tcp.util.TCPSettings;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FramedMessageOutputStream
extends OutputStream
implements LifeCycle {
    private static final int MAX_GROW_SIZE = TCPSettings.getInstance().getOutputBufferGrowLimit();
    private static final int MAX_PAYLOAD_LENGTH_LENTGTH = FramedMessageOutputStream.calculatePayloadLengthLength(MAX_GROW_SIZE);
    private static final boolean IS_GROWABLE = TCPSettings.getInstance().isOutputBufferGrow();
    private boolean useDirectBuffer;
    private ByteBuffer outputBuffer;
    private SocketChannel socketChannel;
    private int frameNumber;
    private int frameSize;
    private boolean isFlushLast;
    private int channelId;
    private int messageId;
    private int contentId;
    private Map<Integer, String> contentProps = new HashMap<Integer, String>(8);
    private int payloadlengthLength;
    private boolean isDirectMode;
    private final ByteBuffer headerBuffer;
    private int frameMessageIdHighValue;
    private int frameMessageIdPosition;
    private long sentMessageLength;

    public FramedMessageOutputStream() {
        this(4096, false);
    }

    public FramedMessageOutputStream(int frameSize) {
        this(frameSize, false);
    }

    public FramedMessageOutputStream(int frameSize, boolean useDirectBuffer) {
        this.useDirectBuffer = useDirectBuffer;
        this.headerBuffer = ByteBufferFactory.allocateView(frameSize, useDirectBuffer);
        this.setFrameSize(frameSize);
    }

    public void setFrameSize(int frameSize) {
        this.frameSize = frameSize;
        this.payloadlengthLength = FramedMessageOutputStream.calculatePayloadLengthLength(frameSize);
        this.outputBuffer = ByteBufferFactory.allocateView(frameSize, this.useDirectBuffer);
    }

    public boolean isDirectMode() {
        return this.isDirectMode;
    }

    public void setDirectMode(boolean isDirectMode) {
        this.reset();
        this.isDirectMode = isDirectMode;
        try {
            this.buildHeader();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setSocketChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    public void setChannelId(int channelId) {
        this.channelId = channelId;
    }

    public void setMessageId(int messageId) {
        this.messageId = messageId;
    }

    public void setContentId(int contentId) {
        this.contentId = contentId;
    }

    public void setContentProperty(int key, String value) {
        this.contentProps.put(key, value);
    }

    public void addAllContentProperties(Map<Integer, String> properties) {
        this.contentProps.putAll(properties);
    }

    @Override
    public void write(int data) throws IOException {
        if (!this.outputBuffer.hasRemaining()) {
            this.flushFrame();
        }
        this.outputBuffer.put((byte)data);
    }

    @Override
    public void write(byte[] data, int offset, int size) throws IOException {
        while (size > 0) {
            int bytesToWrite = Math.min(size, this.outputBuffer.remaining());
            this.outputBuffer.put(data, offset, bytesToWrite);
            offset += bytesToWrite;
            if (this.outputBuffer.hasRemaining() || (size -= bytesToWrite) <= 0) continue;
            this.flushFrame();
        }
    }

    public void flushLast() throws IOException {
        if (!this.isFlushLast) {
            this.outputBuffer.flip();
            this.isFlushLast = true;
            this.flushBuffer();
            this.outputBuffer.clear();
        }
    }

    public void buildHeader() throws IOException {
        this.headerBuffer.clear();
        if (!this.isDirectMode) {
            this.frameMessageIdHighValue = DataInOutUtils.writeInt4(this.headerBuffer, this.channelId, 0, false);
            this.frameMessageIdPosition = this.headerBuffer.position();
            boolean isFrameWithParameters = FrameType.isFrameContainsParams(this.messageId) && this.frameNumber == 0;
            int highValue = DataInOutUtils.writeInt4(this.headerBuffer, this.messageId, this.frameMessageIdHighValue, !isFrameWithParameters);
            if (isFrameWithParameters) {
                int propsCount;
                highValue = DataInOutUtils.writeInt4(this.headerBuffer, this.contentId, highValue, false);
                highValue = DataInOutUtils.writeInt4(this.headerBuffer, propsCount, highValue, (propsCount = this.contentProps.size()) == 0);
                for (Map.Entry<Integer, String> entry : this.contentProps.entrySet()) {
                    String value = entry.getValue();
                    byte[] valueBytes = value.getBytes("UTF-8");
                    highValue = DataInOutUtils.writeInt4(this.headerBuffer, (int)entry.getKey(), highValue, false);
                    DataInOutUtils.writeInt4(this.headerBuffer, valueBytes.length, highValue, true);
                    this.headerBuffer.put(valueBytes);
                    highValue = 0;
                }
            }
            this.initOutputBuffer();
        }
    }

    private void flushBuffer() throws IOException {
        if (!this.isDirectMode) {
            int approxHeaderSize = this.headerBuffer.position() + this.predictPayloadLengthLength();
            int payloadLength = this.outputBuffer.remaining() - approxHeaderSize;
            if (this.messageId == 0) {
                this.updateMessageIdIfRequired(this.frameMessageIdPosition, this.frameMessageIdHighValue, this.isFlushLast);
            }
            DataInOutUtils.writeInt8(this.headerBuffer, payloadLength);
            this.headerBuffer.flip();
            int diff = approxHeaderSize - this.headerBuffer.remaining();
            this.outputBuffer.position(diff);
            this.outputBuffer.put(this.headerBuffer);
            this.outputBuffer.position(diff);
            OutputWriter.flushChannel(this.socketChannel, this.outputBuffer);
            this.sentMessageLength += (long)payloadLength;
            ++this.frameNumber;
        } else {
            OutputWriter.flushChannel(this.socketChannel, this.outputBuffer);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateMessageIdIfRequired(int frameMessageIdPosition, int frameMessageIdHighValue, boolean isLastFrame) {
        int frameMessageId;
        if (isLastFrame) {
            if (this.frameNumber == 0) return;
            frameMessageId = 3;
        } else {
            frameMessageId = this.frameNumber == 0 ? 1 : 2;
        }
        if (frameMessageIdHighValue != 0) {
            this.headerBuffer.put(frameMessageIdPosition, (byte)(frameMessageIdHighValue & 0x70 | frameMessageId));
            return;
        } else {
            byte value = this.headerBuffer.get(frameMessageIdPosition);
            this.headerBuffer.put(frameMessageIdPosition, (byte)(frameMessageId << 4 | value & 0xF));
        }
    }

    public void reset() {
        this.outputBuffer.clear();
        this.headerBuffer.clear();
        this.messageId = -1;
        this.contentId = -1;
        this.contentProps.clear();
        this.frameNumber = 0;
        this.isFlushLast = false;
        this.sentMessageLength = 0L;
    }

    @Override
    public void activate() {
    }

    @Override
    public void passivate() {
        this.reset();
        this.socketChannel = null;
    }

    @Override
    public void close() {
    }

    private void flushFrame() throws IOException {
        this.outputBuffer.flip();
        if (IS_GROWABLE && this.outputBuffer.capacity() < MAX_GROW_SIZE) {
            ByteBuffer newOutputByteBuffer = ByteBufferFactory.allocateView(Math.min(this.outputBuffer.capacity() * 2, MAX_GROW_SIZE), this.useDirectBuffer);
            newOutputByteBuffer.put(this.outputBuffer);
            this.outputBuffer = newOutputByteBuffer;
        } else {
            this.flushBuffer();
            this.buildHeader();
        }
    }

    private void initOutputBuffer() {
        this.outputBuffer.clear();
        this.outputBuffer.position(this.headerBuffer.position() + this.predictPayloadLengthLength());
    }

    private int predictPayloadLengthLength() {
        return IS_GROWABLE ? MAX_PAYLOAD_LENGTH_LENTGTH : this.payloadlengthLength;
    }

    private static int calculatePayloadLengthLength(int frameSize) {
        return (int)Math.ceil(Math.log(frameSize) / Math.log(2.0) / 7.0);
    }
}

