/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.runtime.dev;

import com.sun.xml.ws.api.ha.HaInfo;
import com.sun.xml.ws.api.ha.HighAvailabilityProvider;
import com.sun.xml.ws.api.security.secconv.WSSecureConversationRuntimeException;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.commons.ha.HaContext;
import com.sun.xml.ws.commons.ha.StickyKey;
import com.sun.xml.ws.runtime.dev.Session;
import com.sun.xml.ws.runtime.dev.SessionManager;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.SecurityContextTokenInfo;
import com.sun.xml.ws.security.SecurityTokenReference;
import com.sun.xml.ws.security.Token;
import com.sun.xml.wss.XWSSecurityException;
import java.io.Serializable;
import java.net.URI;
import java.security.Key;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreFactory;

public class SessionManagerImpl
extends SessionManager {
    private Map<String, Session> sessionMap = new HashMap<String, Session>();
    private Map<String, IssuedTokenContext> issuedTokenContextMap = new HashMap<String, IssuedTokenContext>();
    private Map<String, SecurityContextTokenInfo> securityContextTokenInfoMap = new HashMap<String, SecurityContextTokenInfo>();
    private final BackingStore<StickyKey, HASecurityContextTokenInfo> sctBs;

    public SessionManagerImpl(WSEndpoint endpoint, boolean isSC) {
        if (isSC) {
            BackingStoreFactory bsFactory = HighAvailabilityProvider.INSTANCE.getBackingStoreFactory(HighAvailabilityProvider.StoreType.IN_MEMORY);
            this.sctBs = HighAvailabilityProvider.INSTANCE.createBackingStore(bsFactory, endpoint.getServiceName() + ":" + endpoint.getPortName() + "_SCT_BS", StickyKey.class, HASecurityContextTokenInfo.class);
        } else {
            this.sctBs = null;
        }
    }

    public SessionManagerImpl(WSEndpoint endpoint, boolean isSC, Properties config) {
        this(endpoint, isSC);
        SessionManagerImpl.setConfig(config);
    }

    @Override
    public Session getSession(String key) {
        Session session = this.sessionMap.get(key);
        if (session == null && HighAvailabilityProvider.INSTANCE.isHaEnvironmentConfigured() && this.sctBs != null) {
            SecurityContextTokenInfo sctInfo = (SecurityContextTokenInfo)HighAvailabilityProvider.loadFrom(this.sctBs, (Serializable)new StickyKey((Serializable)((Object)key)), null);
            session = new Session(this, key, null);
            session.setSecurityInfo(sctInfo);
            this.sessionMap.put(key, session);
        }
        return session;
    }

    @Override
    public Set<String> keys() {
        return this.sessionMap.keySet();
    }

    @Override
    protected Collection<Session> sessions() {
        return this.sessionMap.values();
    }

    @Override
    public void terminateSession(String key) {
        this.sessionMap.remove(key);
        if (HighAvailabilityProvider.INSTANCE.isHaEnvironmentConfigured() && this.sctBs != null) {
            HighAvailabilityProvider.removeFrom(this.sctBs, (Serializable)new StickyKey((Serializable)((Object)key)));
        }
    }

    @Override
    public Session createSession(String key, Class clasz) {
        Session sess;
        Properties props = SessionManagerImpl.getConfig();
        String timeout = (String)props.get("session-timeout");
        int timeOut = 30;
        if (timeout != null) {
            timeOut = Integer.parseInt(timeout);
        }
        for (Session session : this.sessionMap.values()) {
            SecurityContextTokenInfo securityInfo = session.getSecurityInfo();
            Date expDate = securityInfo.getExpirationTime();
            Calendar expCal = Calendar.getInstance(Locale.getDefault());
            expCal.setTimeInMillis(expDate.getTime());
            if (Calendar.getInstance(Locale.getDefault()).compareTo(expCal) <= timeOut * 60 * 1000) continue;
            this.terminateSession(session.getSessionKey());
        }
        try {
            sess = new Session(this, key, clasz.newInstance());
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException ee) {
            return null;
        }
        this.sessionMap.put(key, sess);
        return sess;
    }

    @Override
    public Session createSession(String key, Object obj) {
        Session session = new Session(this, key, Collections.synchronizedMap(new HashMap()));
        this.sessionMap.put(key, session);
        return session;
    }

    @Override
    public Session createSession(String key, SecurityContextTokenInfo sctInfo) {
        Session session = new Session(this, key, Collections.synchronizedMap(new HashMap()));
        session.setSecurityInfo(sctInfo);
        this.sessionMap.put(key, session);
        if (sctInfo != null && HighAvailabilityProvider.INSTANCE.isHaEnvironmentConfigured()) {
            HASecurityContextTokenInfo hasctInfo = new HASecurityContextTokenInfo(sctInfo);
            HaInfo haInfo = HaContext.currentHaInfo();
            if (haInfo != null) {
                HaContext.udpateReplicaInstance((String)HighAvailabilityProvider.saveTo(this.sctBs, (Serializable)new StickyKey((Serializable)((Object)key), haInfo.getKey()), (Serializable)((Object)hasctInfo), (boolean)true));
            } else {
                StickyKey stickyKey = new StickyKey((Serializable)((Object)key));
                String replicaId = HighAvailabilityProvider.saveTo(this.sctBs, (Serializable)stickyKey, (Serializable)((Object)hasctInfo), (boolean)true);
                HaContext.updateHaInfo((HaInfo)new HaInfo(stickyKey.getHashKey(), replicaId, false));
            }
        }
        return session;
    }

    @Override
    public Session createSession(String key) {
        return this.createSession(key, Collections.synchronizedMap(new HashMap()));
    }

    @Override
    public void saveSession(String key) {
    }

    @Override
    public IssuedTokenContext getSecurityContext(String key, boolean checkExpiry) {
        IssuedTokenContext ctx = this.issuedTokenContextMap.get(key);
        if (ctx == null) {
            SecurityContextTokenInfo sctInfo;
            boolean recovered = false;
            Session session = this.getSession(key);
            if (session != null && (sctInfo = session.getSecurityInfo()) != null) {
                ctx = sctInfo.getIssuedTokenContext();
                this.addSecurityContext(key, ctx);
                recovered = true;
            }
            if (!recovered) {
                throw new WebServiceException("Could not locate SecureConversation session for Id:" + key);
            }
        } else if (ctx.getSecurityContextTokenInfo() == null && ctx.getSecurityToken() != null) {
            String sctInfoKey = ((SecurityContextToken)ctx.getSecurityToken()).getIdentifier().toString() + "_" + ((SecurityContextToken)ctx.getSecurityToken()).getInstance();
            ctx.setSecurityContextTokenInfo(this.securityContextTokenInfoMap.get(sctInfoKey));
        }
        if (ctx != null && checkExpiry) {
            GregorianCalendar c = new GregorianCalendar();
            long offset = c.get(15);
            if (((Calendar)c).getTimeZone().inDaylightTime(c.getTime())) {
                offset += (long)((Calendar)c).getTimeZone().getDSTSavings();
            }
            long beforeTime = c.getTimeInMillis();
            long currentTime = beforeTime - offset;
            c.setTimeInMillis(currentTime);
            Date currentTimeInDateFormat = c.getTime();
            if (!currentTimeInDateFormat.after(ctx.getCreationTime()) || !currentTimeInDateFormat.before(ctx.getExpirationTime())) {
                throw new WSSecureConversationRuntimeException(new QName("RenewNeeded"), "The provided context token has expired");
            }
        }
        return ctx;
    }

    @Override
    public void addSecurityContext(String key, IssuedTokenContext itctx) {
        this.issuedTokenContextMap.put(key, itctx);
        SecurityContextTokenInfo sctInfo = itctx.getSecurityContextTokenInfo();
        if (sctInfo.getInstance() != null) {
            String sctInfoKey = sctInfo.getIdentifier().toString() + "_" + sctInfo.getInstance();
            this.securityContextTokenInfoMap.put(sctInfoKey, sctInfo);
        }
    }

    static class HAIssuedTokenContext
    implements IssuedTokenContext {
        X509Certificate x509Certificate = null;
        Token securityToken = null;
        Token associatedProofToken = null;
        Token secTokenReference = null;
        Token unAttachedSecTokenReference = null;
        ArrayList<Object> securityPolicies = new ArrayList();
        Object otherPartyEntropy = null;
        Object selfEntropy = null;
        URI computedKeyAlgorithm;
        String sigAlgorithm;
        String encAlgorithm;
        String canonicalizationAlgorithm;
        String signWith;
        String encryptWith;
        byte[] proofKey = null;
        SecurityContextTokenInfo sctInfo = null;
        Date creationTime = null;
        Date expiryTime = null;
        String username = null;
        String endPointAddress = null;
        Subject subject;
        KeyPair proofKeyPair;
        String authType = null;
        String tokenType = null;
        String keyType = null;
        String tokenIssuer = null;
        Token target = null;
        Map<String, Object> otherProps = new HashMap<String, Object>();

        HAIssuedTokenContext() {
        }

        public X509Certificate getRequestorCertificate() {
            return this.x509Certificate;
        }

        public void setRequestorCertificate(X509Certificate cert) {
            this.x509Certificate = cert;
        }

        public Subject getRequestorSubject() {
            return this.subject;
        }

        public void setRequestorSubject(Subject subject) {
            this.subject = subject;
        }

        public String getRequestorUsername() {
            return this.username;
        }

        public void setRequestorUsername(String username) {
            this.username = username;
        }

        public void setSecurityToken(Token securityToken) {
            this.securityToken = securityToken;
        }

        public Token getSecurityToken() {
            return this.securityToken;
        }

        public void setAssociatedProofToken(Token associatedProofToken) {
            this.associatedProofToken = associatedProofToken;
        }

        public Token getAssociatedProofToken() {
            return this.associatedProofToken;
        }

        public Token getAttachedSecurityTokenReference() {
            return this.secTokenReference;
        }

        public void setAttachedSecurityTokenReference(Token secTokenReference) {
            this.secTokenReference = secTokenReference;
        }

        public Token getUnAttachedSecurityTokenReference() {
            return this.unAttachedSecTokenReference;
        }

        public void setUnAttachedSecurityTokenReference(Token secTokenReference) {
            this.unAttachedSecTokenReference = secTokenReference;
        }

        public ArrayList<Object> getSecurityPolicy() {
            return this.securityPolicies;
        }

        public void setOtherPartyEntropy(Object otherPartyEntropy) {
            this.otherPartyEntropy = otherPartyEntropy;
        }

        public Object getOtherPartyEntropy() {
            return this.otherPartyEntropy;
        }

        public Key getDecipheredOtherPartyEntropy(Key privKey) throws XWSSecurityException {
            return null;
        }

        public void setSelfEntropy(Object selfEntropy) {
            this.selfEntropy = selfEntropy;
        }

        public Object getSelfEntropy() {
            return this.selfEntropy;
        }

        public URI getComputedKeyAlgorithmFromProofToken() {
            return this.computedKeyAlgorithm;
        }

        public void setComputedKeyAlgorithmFromProofToken(URI computedKeyAlgorithm) {
            this.computedKeyAlgorithm = computedKeyAlgorithm;
        }

        public void setProofKey(byte[] key) {
            this.proofKey = key;
        }

        public byte[] getProofKey() {
            return this.proofKey;
        }

        public void setProofKeyPair(KeyPair keys) {
            this.proofKeyPair = keys;
        }

        public KeyPair getProofKeyPair() {
            return this.proofKeyPair;
        }

        public void setAuthnContextClass(String authType) {
            this.authType = authType;
        }

        public String getAuthnContextClass() {
            return this.authType;
        }

        public Date getCreationTime() {
            return this.creationTime;
        }

        public Date getExpirationTime() {
            return this.expiryTime;
        }

        public void setCreationTime(Date date) {
            this.creationTime = date;
        }

        public void setExpirationTime(Date date) {
            this.expiryTime = date;
        }

        public void setEndpointAddress(String endPointAddress) {
            this.endPointAddress = endPointAddress;
        }

        public String getEndpointAddress() {
            return this.endPointAddress;
        }

        public void destroy() {
        }

        public SecurityContextTokenInfo getSecurityContextTokenInfo() {
            return this.sctInfo;
        }

        public void setSecurityContextTokenInfo(SecurityContextTokenInfo sctInfo) {
            this.sctInfo = sctInfo;
        }

        public Map<String, Object> getOtherProperties() {
            return this.otherProps;
        }

        public void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }

        public String getTokenType() {
            return this.tokenType;
        }

        public void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        public String getKeyType() {
            return this.keyType;
        }

        public void setAppliesTo(String appliesTo) {
            this.endPointAddress = appliesTo;
        }

        public String getAppliesTo() {
            return this.endPointAddress;
        }

        public void setTokenIssuer(String issuer) {
            this.tokenIssuer = issuer;
        }

        public String getTokenIssuer() {
            return this.tokenIssuer;
        }

        public void setSignatureAlgorithm(String sigAlg) {
            this.sigAlgorithm = sigAlg;
        }

        public String getSignatureAlgorithm() {
            return this.sigAlgorithm;
        }

        public void setEncryptionAlgorithm(String encAlg) {
            this.encAlgorithm = encAlg;
        }

        public String getEncryptionAlgorithm() {
            return this.encAlgorithm;
        }

        public void setCanonicalizationAlgorithm(String canonAlg) {
            this.canonicalizationAlgorithm = canonAlg;
        }

        public String getCanonicalizationAlgorithm() {
            return this.canonicalizationAlgorithm;
        }

        public void setSignWith(String signWithAlgo) {
            this.signWith = signWithAlgo;
        }

        public String getSignWith() {
            return this.signWith;
        }

        public void setEncryptWith(String encryptWithAlgo) {
            this.encryptWith = encryptWithAlgo;
        }

        public String getEncryptWith() {
            return this.encryptWith;
        }

        public void setTarget(Token target) {
            this.target = target;
        }

        public Token getTarget() {
            return this.target;
        }
    }

    static class HASecurityContextTokenInfo
    implements SecurityContextTokenInfo {
        String identifier = null;
        String extId = null;
        String instance = null;
        byte[] secret = null;
        Map<String, byte[]> secretMap = new HashMap<String, byte[]>();
        Date creationTime = null;
        Date expirationTime = null;

        public HASecurityContextTokenInfo() {
        }

        public HASecurityContextTokenInfo(SecurityContextTokenInfo sctInfo) {
            this.identifier = sctInfo.getIdentifier();
            this.extId = sctInfo.getExternalId();
            this.instance = sctInfo.getInstance();
            this.secret = sctInfo.getSecret();
            this.creationTime = sctInfo.getCreationTime();
            this.expirationTime = sctInfo.getExpirationTime();
            Set instKeys = sctInfo.getInstanceKeys();
            for (String instKey : instKeys) {
                this.secretMap.put(instKey, sctInfo.getInstanceSecret(this.instance));
            }
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public String getExternalId() {
            return this.extId;
        }

        public void setExternalId(String externalId) {
            this.extId = externalId;
        }

        public String getInstance() {
            return this.instance;
        }

        public void setInstance(String instance) {
            this.instance = instance;
        }

        public byte[] getSecret() {
            byte[] newSecret = new byte[this.secret.length];
            System.arraycopy(this.secret, 0, newSecret, 0, this.secret.length);
            return newSecret;
        }

        public byte[] getInstanceSecret(String instance) {
            return this.secretMap.get(instance);
        }

        public void addInstance(String instance, byte[] key) {
            byte[] newKey = new byte[key.length];
            System.arraycopy(key, 0, newKey, 0, key.length);
            if (instance == null) {
                this.secret = newKey;
            } else {
                this.secretMap.put(instance, newKey);
            }
        }

        public Date getCreationTime() {
            return new Date(this.creationTime.getTime());
        }

        public void setCreationTime(Date creationTime) {
            this.creationTime = new Date(creationTime.getTime());
        }

        public Date getExpirationTime() {
            return new Date(this.expirationTime.getTime());
        }

        public void setExpirationTime(Date expirationTime) {
            this.expirationTime = new Date(expirationTime.getTime());
        }

        public Set getInstanceKeys() {
            return this.secretMap.keySet();
        }

        public IssuedTokenContext getIssuedTokenContext() {
            HAIssuedTokenContext itc = new HAIssuedTokenContext();
            itc.setCreationTime(this.getCreationTime());
            itc.setExpirationTime(this.getExpirationTime());
            itc.setProofKey(this.getSecret());
            itc.setSecurityContextTokenInfo(this);
            return itc;
        }

        public IssuedTokenContext getIssuedTokenContext(SecurityTokenReference reference) {
            return null;
        }

        public String toString() {
            String str = "Identifier=" + this.identifier + " : Secret=" + this.secret + " : ExternalId=" + this.extId + " : Creation Time=" + this.creationTime + " : Expiration Time=" + this.expirationTime;
            return str;
        }
    }
}

