/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.config.management.server;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.config.management.EndpointCreationAttributes;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.config.management.ManagementMessages;
import com.sun.xml.ws.metro.api.config.management.ManagedEndpoint;
import com.sun.xml.ws.server.EndpointFactory;
import jakarta.xml.ws.WebServiceException;
import jakarta.xml.ws.WebServiceFeature;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.xml.sax.EntityResolver;

public class ReDelegate {
    private static final Logger LOGGER = Logger.getLogger(ReDelegate.class);

    public static <T> void recreate(ManagedEndpoint<T> managedEndpoint, WebServiceFeature ... features) {
        try {
            WSEndpoint<T> delegate = ReDelegate.recreateEndpoint(managedEndpoint, features);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(ManagementMessages.WSM_5092_NEW_ENDPOINT_DELEGATE(delegate));
            }
            managedEndpoint.swapEndpointDelegate(delegate);
        }
        catch (Throwable e) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5091_ENDPOINT_CREATION_FAILED(), e));
        }
    }

    private static <T> WSEndpoint<T> recreateEndpoint(ManagedEndpoint<T> endpoint, WebServiceFeature ... features) {
        endpoint.closeManagedObjectManager();
        EndpointCreationAttributes creationAttributes = endpoint.getCreationAttributes();
        BindingImpl recreatedBinding = BindingImpl.create((BindingID)endpoint.getBinding().getBindingId(), (WebServiceFeature[])features);
        WSEndpoint result = EndpointFactory.createEndpoint((Class)endpoint.getImplementationClass(), (boolean)creationAttributes.isProcessHandlerAnnotation(), (Invoker)creationAttributes.getInvoker(), (QName)endpoint.getServiceName(), (QName)endpoint.getPortName(), (Container)endpoint.getContainer(), (WSBinding)recreatedBinding, null, null, (EntityResolver)creationAttributes.getEntityResolver(), (boolean)creationAttributes.isTransportSynchronous());
        result.getComponents().addAll(endpoint.getComponents());
        return result;
    }
}

