/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

@Mojo(name="ws-test", defaultPhase=LifecyclePhase.TEST, requiresProject=false)
public class WSTestMojo
extends AbstractMojo {
    private static final String HARNESS_GID = "org.glassfish.metro";
    private static final String HARNESS_AID = "harness-lib";
    private static final String TOPLINK_FACTORY = "com.sun.xml.ws.db.toplink.JAXBContextFactory";
    private static final String SDO_FACTORY = "com.sun.xml.ws.db.sdo.SDOContextFactory";
    private static final String JAXWS_API_VERSION = "2.2.8";
    @Parameter(defaultValue="2.3.2-SNAPSHOT")
    private String harnessVersion;
    @Parameter(defaultValue="2.2.8")
    private String version;
    @Parameter(defaultValue="${project.build.directory}/surefire-reports")
    private File resultsDirectory;
    @Parameter
    private File endorsedDir;
    @Parameter(defaultValue="true")
    private boolean recursive;
    @Parameter(defaultValue="false")
    private boolean dump;
    @Parameter(property="ws.debug", defaultValue="false")
    private boolean debug;
    @Parameter(property="ws.failonerror", defaultValue="true")
    private boolean failonerror;
    @Parameter(property="ws.test", defaultValue="${project.basedir}/src/test/testcases")
    private File tests;
    @Parameter(defaultValue="DEFAULT")
    private Databinding databinding;
    @Parameter(defaultValue="none")
    private FI fastinfoset;
    @Parameter(property="args")
    private List<String> args;
    @Parameter(property="ws.jvmOpts")
    private String extraVmArgs;
    @Parameter(property="vmArgs")
    private List<String> vmArgs;
    @Parameter(property="ws.extDir", defaultValue="${project.basedir}/lib/ext")
    private File extDir;
    @Parameter(property="ws.imageUrl")
    private String imageUrl;
    @Parameter(property="ws.localImage", defaultValue="${project.build.directory}/image")
    private File localImage;
    @Parameter(property="ws.transport", defaultValue="IN_VM")
    private Container transport;
    @Parameter(property="ws.transportUrl")
    private String transportUrl;
    @Parameter(property="tomcat.home")
    private File tomcatHome;
    @Parameter(defaultValue="${project.basedir}/misc")
    private File wsitConf;
    @Parameter(readonly=true, defaultValue="${localRepository}")
    private ArtifactRepository localRepo;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @Parameter(readonly=true, defaultValue="${project.pluginArtifactRepositories}")
    private List<ArtifactRepository> pluginRepos;
    @Component
    private ArtifactFactory artifactFactory;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Component
    private ArchiverManager archiverManager;
    @Component
    private ArtifactMetadataSource mdataSource;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    private File imageRoot = null;

    /*
     * Unable to fully structure code
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        imageFolder = new File(this.project.getBuild().getDirectory(), "tested-image");
        try {
            u = new URL(this.imageUrl);
            try {
                imageFolder.mkdirs();
                this.imageRoot = this.prepareImage(u, imageFolder);
                this.getLog().info((CharSequence)("testing downloaded image (" + this.imageRoot.getPath() + ")..."));
            }
            catch (NoSuchArchiverException ex) {
                throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
            }
            catch (IOException ex) {
                throw new MojoFailureException(ex.getMessage(), (Throwable)ex);
            }
        }
        catch (MalformedURLException u) {
            // empty catch block
        }
        if (this.imageRoot == null) {
            if (this.localImage.exists() && this.localImage.isDirectory() && this.findImageRoot(this.localImage) != null) {
                this.imageRoot = this.findImageRoot(this.localImage);
                this.getLog().info((CharSequence)("testing local image (" + this.imageRoot.getPath() + ")..."));
            } else {
                this.getLog().info((CharSequence)"testing local workspace...");
            }
        } else {
            this.getLog().info((CharSequence)"testing local workspace...");
        }
        cmd = new Commandline();
        cmd.setExecutable(new File(new File(System.getProperty("java.home"), "bin"), this.getJavaExec()).getAbsolutePath());
        cmd.setWorkingDirectory(this.project.getBasedir());
        if (this.imageRoot != null) {
            end = this.prepareEndorsed(this.imageRoot);
            this.getLog().info((CharSequence)("Setting endorsed directory to: " + end.getAbsolutePath()));
            cmd.createArg().setLine("-Djava.endorsed.dirs=" + end.getAbsolutePath());
        } else if (this.endorsedDir != null && this.endorsedDir.isDirectory()) {
            this.getLog().info((CharSequence)("Setting endorsed directory to: " + this.endorsedDir.getAbsolutePath()));
            cmd.createArg().setValue("-Djava.endorsed.dirs=" + this.endorsedDir.getAbsolutePath());
        } else {
            this.getLog().warn((CharSequence)"Endorsed not applied. Set 'endorsedDir' in plugin's configuration.");
        }
        if (this.extDir != null && this.extDir.exists() && this.extDir.isDirectory()) {
            cmd.createArg().setValue("-DHARNESS_EXT=" + this.extDir.getAbsolutePath());
        } else {
            this.getLog().info((CharSequence)"'ext' directory not found");
        }
        if (System.getProperty("net.sourceforge.cobertura.datafile") != null) {
            cmd.createArg().setValue("-Dnet.sourceforge.cobertura.datafile=" + System.getProperty("net.sourceforge.cobertura.datafile"));
        }
        if (this.wsitConf != null && this.wsitConf.exists() && this.wsitConf.isDirectory()) {
            cmd.createArg().setValue("-DWSIT_HOME=" + this.wsitConf.getAbsolutePath());
        }
        if (this.isFastInfosetEnabled()) {
            switch (1.$SwitchMap$com$sun$xml$ws$test$WSTestMojo$FI[this.fastinfoset.ordinal()]) {
                case 1: {
                    cmd.createArg().setLine("-Dcom.sun.xml.ws.client.ContentNegotiation=optimistic");
                    break;
                }
                case 2: {
                    cmd.createArg().setLine("-Dcom.sun.xml.ws.client.ContentNegotiation=pessimistic");
                    break;
                }
            }
        }
        if (this.isToplink()) {
            cmd.createArg().setLine("-DBindingContextFactory=com.sun.xml.ws.db.toplink.JAXBContextFactory");
        } else if (this.isSDO()) {
            cmd.createArg().setLine("-DBindingContextFactory=com.sun.xml.ws.db.sdo.SDOContextFactory");
        }
        if (this.extraVmArgs != null && this.extraVmArgs.trim().length() > 1) {
            cmd.createArg().setLine(this.extraVmArgs);
        }
        if (this.settings != null) {
            for (Proxy p : this.settings.getProxies()) {
                if (!p.isActive()) continue;
                protocol = p.getProtocol().trim();
                if (p.getHost() != null) {
                    sb = new StringBuilder();
                    sb.append("-D");
                    sb.append(protocol);
                    sb.append(".proxyHost=");
                    sb.append(p.getHost());
                    cmd.createArg().setLine(sb.toString());
                }
                if (p.getPort() > -1) {
                    sb = new StringBuilder();
                    sb.append("-D");
                    sb.append(protocol);
                    sb.append(".proxyPort=");
                    sb.append(p.getPort());
                    cmd.createArg().setLine(sb.toString());
                }
                if (p.getNonProxyHosts() == null) continue;
                sb = new StringBuilder();
                sb.append("-D");
                sb.append(protocol);
                sb.append(".nonProxyHosts=\"");
                sb.append(p.getNonProxyHosts().trim());
                sb.append("\"");
                cmd.createArg().setValue(sb.toString());
            }
        }
        if (this.vmArgs != null) {
            for (String arg : this.vmArgs) {
                if (arg.contains("-DBindingContextFactory=") && (this.isToplink() || this.isSDO())) {
                    line = this.removeVmArg(arg, "BindingContextFactory");
                    if (line != null) {
                        cmd.createArg().setLine(line.trim());
                        continue;
                    }
                    this.getLog().info((CharSequence)("removing '" + arg + "' from default configuration."));
                    continue;
                }
                if (arg.contains("-Dcom.sun.xml.ws.client.ContentNegotiation=") && this.isFastInfosetEnabled()) {
                    line = this.removeVmArg(arg, "com.sun.xml.ws.client.ContentNegotiation");
                    if (line != null) {
                        cmd.createArg().setLine(line.trim());
                        continue;
                    }
                    this.getLog().info((CharSequence)("removing '" + arg + "' from default configuration."));
                    continue;
                }
                cmd.createArg().setLine(arg);
            }
        }
        cmd.createArg().setLine("-cp " + this.getHarnessClassPath());
        cmd.createArg().setValue("com.sun.xml.ws.test.Main");
        if (this.project.getFile() != null) {
            cmd.createArg().setLine("-report " + this.resultsDirectory.getAbsolutePath());
        } else if (this.args != null && !this.args.contains("-report")) {
            cmd.createArg().setLine("-report results");
        }
        if (this.recursive) {
            cmd.createArg().setValue("-r");
        }
        if (this.debug) {
            cmd.createArg().setValue("-debug");
        }
        if (this.dump) {
            cmd.createArg().setValue("-dump");
        }
        if (this.version != null && this.version.trim().length() > 0) {
            cmd.createArg().setLine("-version " + this.version);
        }
        switch (1.$SwitchMap$com$sun$xml$ws$test$WSTestMojo$Container[this.transport.ordinal()]) {
            case 1: {
                if (this.imageRoot == null) break;
                transportFile = null;
                try {
                    transportFile = this.download(new URL(this.transportUrl), imageFolder);
                }
                catch (IOException ex) {
                    transportFile = new File(this.project.getBuild().getDirectory(), "test-lib/jaxws-local-transport.jar");
                    if (transportFile.exists()) ** GOTO lbl145
                    throw new MojoExecutionException("Cannot find local transport jar.  Set 'transportUrl' in plugin's configuration.", (Exception)ex);
                }
lbl145:
                // 2 sources

                cmd.createArg().setLine("-transport " + transportFile.getAbsolutePath());
                break;
            }
            case 2: {
                cmd.createArg().setLine("-lwhs");
                break;
            }
            case 3: {
                if (this.tomcatHome == null) {
                    throw new MojoExecutionException("'tomcat.home' is not set.");
                }
                cmd.createArg().setLine("-tomcat-embedded " + this.tomcatHome.getAbsolutePath());
                break;
            }
            case 4: {
                if (this.tomcatHome == null) {
                    throw new MojoExecutionException("'tomcat.home' is not set.");
                }
                cmd.createArg().setLine("-tomcat-local " + this.tomcatHome.getAbsolutePath());
            }
        }
        filters = new ArrayList<String>();
        if (this.imageRoot != null) {
            if (this.isJaxWsRIRoot(this.imageRoot)) {
                cmd.createArg().setLine("-cp:jaxws-image " + this.imageRoot.getAbsolutePath());
            } else if (this.isMetroRoot(this.imageRoot)) {
                cmd.createArg().setLine("-cp:wsit-image " + this.imageRoot.getAbsolutePath());
            } else {
                throw new MojoExecutionException("Unknown/Unsupported image: " + this.imageRoot);
            }
            if (this.isToplink()) {
                cmd.createArg().setLine("-cp:override " + this.getToplinkCP(this.imageRoot));
                filters.add("-cp:override");
            } else if (this.isSDO()) {
                cmd.createArg().setLine("-cp:override " + this.getSdoCP(this.imageRoot));
                filters.add("-cp:override");
            }
            filters.add("-cp:jaxws");
            filters.add("-cp:wsit");
        }
        if (this.args != null) {
            for (String arg : this.args) {
                if (filters.isEmpty()) {
                    cmd.createArg().setLine(arg);
                    continue;
                }
                found = false;
                for (String filter : filters) {
                    if (!arg.contains(filter)) continue;
                    this.getLog().info((CharSequence)("removing '" + arg + "' from default configuration."));
                    found = true;
                    break;
                }
                if (found) continue;
                cmd.createArg().setLine(arg);
            }
        }
        cmd.createArg().setLine(this.tests.getAbsolutePath());
        if (this.debug) {
            this.getLog().info((CharSequence)cmd.toString());
        }
        this.getLog().debug((CharSequence)cmd.toString());
        sc = new DefaultConsumer();
        try {
            i = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)sc, (StreamConsumer)sc);
            if (i > 0 && this.failonerror) {
                throw new MojoFailureException(i + " test(s) failed");
            }
            if (i < 0) {
                throw new MojoExecutionException("Invalid command: " + cmd.toString());
            }
        }
        catch (CommandLineException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    private File download(URL u, File destDir) throws IOException {
        this.getLog().info((CharSequence)("Downloading: " + u));
        File imageZip = new File(destDir, new File(u.getFile()).getName());
        if (imageZip.createNewFile()) {
            this.getLog().info((CharSequence)("to: " + imageZip.getAbsolutePath()));
            IOUtil.copy((InputStream)u.openStream(), (OutputStream)new FileOutputStream(imageZip));
        }
        return imageZip;
    }

    private File prepareImage(URL u, File destDir) throws IOException, NoSuchArchiverException {
        File zip = this.download(u, destDir);
        this.getLog().info((CharSequence)("unpacking " + zip.getName() + "..."));
        UnArchiver unArchiver = this.archiverManager.getUnArchiver(zip);
        unArchiver.setSourceFile(zip);
        unArchiver.setDestDirectory(destDir);
        unArchiver.extract();
        return this.findImageRoot(destDir);
    }

    private File findImageRoot(File dir) {
        File f = new File(dir, "jaxws-ri");
        if (f.exists() && f.isDirectory()) {
            return f;
        }
        f = new File(dir, "metro");
        if (f.exists() && f.isDirectory()) {
            return f;
        }
        return null;
    }

    private String getJavaExec() {
        return Os.isFamily((String)"windows") ? "java.exe" : "java";
    }

    private String getHarnessClassPath() throws MojoExecutionException {
        StringBuilder sb = new StringBuilder();
        for (Artifact a : this.getHarnessLib()) {
            sb.append(a.getFile().getAbsolutePath());
            sb.append(File.pathSeparator);
        }
        return sb.substring(0, sb.length() - 1);
    }

    private Set<Artifact> getHarnessLib() throws MojoExecutionException {
        List resolvedDependencies;
        DefaultArtifact harnessLib = new DefaultArtifact(HARNESS_GID, HARNESS_AID, null, "jar", this.harnessVersion);
        HashSet<ArtifactRequest> dependenciesRequest = new HashSet<ArtifactRequest>();
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact((Artifact)harnessLib);
        request.setRepositories(this.remoteRepos);
        dependenciesRequest.add(request);
        try {
            resolvedDependencies = this.repoSystem.resolveArtifacts(this.repoSession, dependenciesRequest);
        }
        catch (ArtifactResolutionException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        for (ArtifactResult dependency : resolvedDependencies) {
            artifacts.add(dependency.getArtifact());
        }
        return artifacts;
    }

    private boolean isToplink() {
        return Databinding.TOPLINK == this.databinding;
    }

    private boolean isSDO() {
        return Databinding.SDO == this.databinding;
    }

    private boolean isFastInfosetEnabled() {
        return this.fastinfoset != null && FI.none != this.fastinfoset;
    }

    private String getCP(File root, String ... paths) {
        StringBuilder sb = new StringBuilder();
        for (String p : paths) {
            sb.append(new File(root, p).getAbsolutePath());
            sb.append(File.pathSeparatorChar);
        }
        return sb.substring(0, sb.length() - 1);
    }

    private File prepareEndorsed(File root) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Preparing endorsed directory...");
        File endorsed = new File(root.getParentFile(), "endorsed");
        try {
            if (this.isJaxWsRIRoot(root)) {
                FileUtils.copyFileToDirectory((File)new File(root, "lib/javax.xml.soap-api.jar"), (File)endorsed);
                FileUtils.copyFileToDirectory((File)new File(root, "lib/jaxb-api.jar"), (File)endorsed);
                FileUtils.copyFileToDirectory((File)new File(root, "lib/jaxws-api.jar"), (File)endorsed);
                return endorsed;
            }
            if (this.isMetroRoot(root)) {
                FileUtils.copyFileToDirectory((File)new File(root, "lib/webservices-api.jar"), (File)endorsed);
                return endorsed;
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error while preparing endorsed directory for " + this.imageRoot, (Exception)ex);
        }
        throw new MojoExecutionException("Unknown/Unsupported image: " + this.imageRoot);
    }

    private String getToplinkCP(File root) throws MojoExecutionException {
        if (this.isJaxWsRIRoot(root)) {
            return this.getCP(root, "lib/plugins/jaxws-eclipselink-plugin.jar", "lib/plugins/eclipselink.jar", "lib/plugins/mail.jar");
        }
        if (this.isMetroRoot(root)) {
            return this.getCP(root, "lib/databinding/jaxws-eclipselink-plugin.jar") + File.pathSeparatorChar + this.getCP(new File(this.project.getBuild().getDirectory()), "test-lib/eclipselink.jar");
        }
        throw new MojoExecutionException("Unknown/Unsupported image: " + this.imageRoot);
    }

    private String getSdoCP(File root) throws MojoExecutionException {
        if (this.isJaxWsRIRoot(root)) {
            return this.getCP(root, "lib/plugins/sdo-eclipselink-plugin.jar", "lib/plugins/eclipselink.jar");
        }
        if (this.isMetroRoot(root)) {
            return this.getCP(root, "lib/databinding/sdo-eclipselink-plugin.jar") + File.pathSeparatorChar + this.getCP(new File(this.project.getBuild().getDirectory()), "test-lib/eclipselink.jar");
        }
        throw new MojoExecutionException("Unknown/Unsupported image: " + this.imageRoot);
    }

    private boolean isJaxWsRIRoot(File root) {
        return "jaxws-ri".equals(root.getName());
    }

    private boolean isMetroRoot(File root) {
        return "metro".equals(root.getName());
    }

    private String removeVmArg(String line, String prop) {
        String[] opts = line.split(" ");
        if (opts.length > 1) {
            StringBuilder sb = new StringBuilder();
            for (String opt : opts) {
                if (opt.trim().startsWith("-D" + prop + "=")) {
                    this.getLog().info((CharSequence)("removing '" + opt + "' from default configuration."));
                    continue;
                }
                sb.append(opt);
                sb.append(" ");
            }
            return sb.toString();
        }
        return null;
    }

    public static enum FI {
        none,
        pessimistic,
        optimistic;

    }

    public static enum Container {
        IN_VM,
        LWHS,
        TOMCAT,
        TOMCAT_LOCAL;

    }

    public static enum Databinding {
        DEFAULT,
        TOPLINK,
        SDO;

    }
}

