/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.util;

import com.sun.xml.ws.test.World;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    public static final FileFilter DIRECTORY_FILTER = new FileFilter(){

        public boolean accept(File path) {
            return path.isDirectory();
        }
    };
    public static final FileFilter JAR_FILE_FILTER = new FileFilter(){

        public boolean accept(File path) {
            return path.getName().endsWith(".jar");
        }
    };

    public static String[] getClassFileNames(File dir) {
        ArrayList<String> names = new ArrayList<String>();
        Stack<String> pathStack = new Stack<String>();
        FileUtil.addClassNames(dir, pathStack, names);
        return names.toArray(new String[names.size()]);
    }

    private static void addClassNames(File current, Stack<String> stack, List<String> names) {
        File[] children = current.listFiles();
        if (children == null) {
            return;
        }
        for (File child : children) {
            if (child.isDirectory()) {
                stack.push(child.getName());
                FileUtil.addClassNames(child, stack, names);
                stack.pop();
                continue;
            }
            if (!child.getName().endsWith(".class")) continue;
            names.add(FileUtil.createFullName(stack, child));
        }
    }

    private static String createFullName(Stack<String> dirs, File classFile) {
        String className = classFile.getName().substring(0, classFile.getName().indexOf(".class"));
        if (dirs.empty()) {
            return className;
        }
        StringBuilder fullName = new StringBuilder();
        for (String dir : dirs) {
            fullName.append(dir);
            fullName.append(".");
        }
        fullName.append(className);
        return fullName.toString();
    }

    public static void deleteRecursive(File dir) {
        Delete d = new Delete();
        d.setProject(World.project);
        d.setDir(dir);
        d.execute();
    }

    public static void copyFile(File src, File dest) {
        Copy cp = new Copy();
        cp.setOverwrite(true);
        cp.setProject(World.project);
        cp.setFile(src);
        cp.setTofile(dest);
        cp.execute();
    }

    public static void copyDir(File src, File dest, String excludes) {
        Copy cp = new Copy();
        cp.setProject(World.project);
        cp.setTodir(dest);
        FileSet fs = new FileSet();
        if (excludes != null) {
            fs.setExcludes(excludes);
        }
        fs.setDir(src);
        cp.addFileset(fs);
        cp.execute();
    }

    public static File createTmpDir(boolean scheduleDeleteOnVmExit) throws IOException {
        File tmpFile = File.createTempFile("wstest", "tmp", new File("."));
        tmpFile.delete();
        tmpFile.mkdir();
        if (scheduleDeleteOnVmExit) {
            tmpFile.deleteOnExit();
        }
        return tmpFile;
    }
}

