/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.model;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.test.model.TestDescriptor;
import com.sun.xml.ws.test.model.TestEndpoint;
import com.sun.xml.ws.test.model.WSDL;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestService {
    @NotNull
    public final String name;
    @NotNull
    public final File baseDir;
    @Nullable
    public final List<WSDL> wsdl;
    @NotNull
    public final List<File> customizations = new ArrayList<File>();
    @NotNull
    public final Set<TestEndpoint> endpoints = new LinkedHashSet<TestEndpoint>();
    public final TestDescriptor parent;
    public boolean isSTS;
    private static final Pattern PORT_NAME = Pattern.compile("portName\\s*=\\s*\"([^\"]+)\"");

    public TestService(TestDescriptor parent, String name, File baseDir, List<WSDL> wsdl, boolean sts, @Nullable String explicitServiceClassName) throws IOException {
        this.parent = parent;
        this.name = name;
        this.wsdl = wsdl;
        this.baseDir = baseDir;
        this.isSTS = sts;
        if (explicitServiceClassName == null) {
            this.findEndpoints(baseDir);
        } else {
            String shortName = explicitServiceClassName.substring(explicitServiceClassName.lastIndexOf(46) + 1);
            this.endpoints.add(new TestEndpoint(shortName, explicitServiceClassName, null, false));
        }
    }

    public String getAbsolutePath(String relativePath) {
        return this.baseDir.getAbsolutePath() + File.separator + relativePath;
    }

    public TestEndpoint getEndpointByImpl(String implClassFullName) {
        for (TestEndpoint ep : this.endpoints) {
            if (!ep.className.equals(implClassFullName)) continue;
            return ep;
        }
        throw new Error("No TestEndpoint object recorded for " + implClassFullName);
    }

    public String getGlobalUniqueName() {
        if (this.name.length() == 0) {
            return this.parent.name;
        }
        return this.parent.name + '.' + this.name;
    }

    private void findEndpoints(File dir) throws IOException {
        File[] dirs;
        for (File subdir : dirs = dir.listFiles(new FileFilter(){

            public boolean accept(File child) {
                return child.isDirectory() && !child.getName().equals("work");
            }
        })) {
            this.findEndpoints(subdir);
        }
        Object[] javas = dir.listFiles(new FileFilter(){

            public boolean accept(File child) {
                return child.getName().endsWith(".java");
            }
        });
        Arrays.sort(javas);
        for (Object src : javas) {
            String line;
            BufferedReader r = new BufferedReader(new FileReader((File)src));
            String pkg = null;
            boolean isWebService = false;
            boolean isProvider = false;
            boolean isInterface = false;
            String portName = null;
            block2: while ((line = r.readLine()) != null) {
                if (line.startsWith("package ")) {
                    pkg = line.substring(8, line.indexOf(59));
                }
                if (line.contains("@WebServiceProvider") || line.contains("@javax.xml.ws.WebServiceProvider")) {
                    isProvider = true;
                    isWebService = true;
                } else if (line.contains("@WebService") || line.contains("@javax.jws.WebService")) {
                    isWebService = true;
                }
                if (isWebService && portName == null) {
                    portName = this.calcPortName(line);
                }
                if (!line.contains("public interface") && !line.contains("public class")) continue;
                StringTokenizer stk = new StringTokenizer(line);
                while (stk.hasMoreTokens()) {
                    String tk = stk.nextToken();
                    if (tk.equals("interface")) {
                        isInterface = true;
                        break block2;
                    }
                    if (!tk.equals("class")) continue;
                    isInterface = false;
                    break block2;
                }
            }
            r.close();
            if (!isWebService || isInterface) continue;
            String className = ((File)src).getName();
            className = className.substring(0, className.length() - 5);
            String fullName = pkg != null ? pkg + '.' + className : className;
            this.endpoints.add(new TestEndpoint(className, fullName, portName, isProvider));
        }
    }

    private String calcPortName(String line) {
        Matcher m = PORT_NAME.matcher(line);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public String toString() {
        return this.name + " of " + this.parent.toString();
    }

    public File[] getHandlerConfiguration() {
        return this.baseDir.listFiles(new HandlersFilter());
    }

    public File getConfiguredFile(String filename) {
        return this.first(this.baseDir.listFiles(new NameFilter(filename)));
    }

    private File first(File[] files) {
        return files == null || files.length == 0 ? null : files[0];
    }

    class NameFilter
    implements FilenameFilter {
        String filename;

        NameFilter(String filename) {
            this.filename = filename;
        }

        public boolean accept(File dir, String name) {
            return name.equals(this.filename);
        }
    }

    class HandlersFilter
    implements FilenameFilter {
        HandlersFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith("handlers.xml");
        }
    }
}

