/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.container.invm;

import com.sun.istack.NotNull;
import com.sun.xml.ws.test.World;
import com.sun.xml.ws.test.client.InterpreterEx;
import com.sun.xml.ws.test.container.AbstractApplicationContainer;
import com.sun.xml.ws.test.container.Application;
import com.sun.xml.ws.test.container.DeployedService;
import com.sun.xml.ws.test.container.WAR;
import com.sun.xml.ws.test.container.invm.InVmApplication;
import com.sun.xml.ws.test.tool.WsTool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class InVmContainer
extends AbstractApplicationContainer {
    public InVmContainer(WsTool wsimport, WsTool wsgen) {
        super(wsimport, wsgen, false);
    }

    public String getTransport() {
        return "in-vm";
    }

    public void start() {
    }

    public void shutdown() {
    }

    @NotNull
    public Application deploy(DeployedService service) throws Exception {
        String id = service.service.getGlobalUniqueName();
        WAR war = this.assembleWar(service);
        if (service.service.isSTS) {
            String newLocation = "in-vm://" + id + "/";
            newLocation = newLocation.replace('\\', '/');
            this.updateWsitClient(war, service, newLocation);
        }
        for (File wsdl : war.getWSDL()) {
            this.patchWsdl(service, wsdl, id);
        }
        URLClassLoader serviceClassLoader = new URLClassLoader(new URL[]{new File(service.warDir, "WEB-INF/classes").toURL()}, World.runtime.getClassLoader());
        InterpreterEx i = new InterpreterEx(serviceClassLoader);
        i.set("id", id);
        i.set("dir", service.warDir);
        Object server = i.eval("new com.sun.xml.ws.transport.local.InVmServer(id,dir)");
        return new InVmApplication(war, server, new URI("in-vm://" + id + "/"));
    }

    private void patchWsdl(DeployedService service, File wsdl, String id) throws Exception {
        Document doc = new SAXReader().read(wsdl);
        List ports = doc.getRootElement().element("service").elements("port");
        for (Element port : ports) {
            String portName = port.attributeValue("name");
            Element address = this.getSoapAddress(port);
            if (address == null) continue;
            if (!"wsdl".equalsIgnoreCase(wsdl.getParentFile().getName())) {
                portName = wsdl.getParentFile().getName() + portName;
            }
            Attribute locationAttr = address.attribute("location");
            String newLocation = "in-vm://" + id + "/?" + portName;
            newLocation = newLocation.replace('\\', '/');
            locationAttr.setValue(newLocation);
            Element wsaEprEl = port.element(QName.get((String)"EndpointReference", (String)"wsa", (String)"http://www.w3.org/2005/08/addressing"));
            if (wsaEprEl == null) continue;
            Element wsaAddrEl = wsaEprEl.element(QName.get((String)"Address", (String)"wsa", (String)"http://www.w3.org/2005/08/addressing"));
            wsaAddrEl.setText(newLocation);
        }
        FileOutputStream os = new FileOutputStream(wsdl);
        new XMLWriter((OutputStream)os).write(doc);
        os.close();
    }

    private Element getSoapAddress(Element port) {
        for (Object obj : port.elements()) {
            Element address = (Element)obj;
            if (!address.getName().equals("address") || !address.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap/") && !address.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/")) continue;
            return address;
        }
        return null;
    }
}

