/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.container.cargo;

import com.sun.xml.ws.test.container.cargo.AbstractCargoContainer;
import com.sun.xml.ws.test.tool.WsTool;
import java.net.URL;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.RemoteContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.RuntimeConfiguration;
import org.codehaus.cargo.generic.DefaultContainerFactory;
import org.codehaus.cargo.generic.configuration.DefaultConfigurationFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteCargoApplicationContainer
extends AbstractCargoContainer<RemoteContainer> {
    private final URL serverUrl;

    public RemoteCargoApplicationContainer(WsTool wsimport, WsTool wsgen, String containerId, URL server, String userName, String password, boolean httpspi) throws Exception {
        super(wsimport, wsgen, httpspi);
        this.serverUrl = server;
        DefaultConfigurationFactory configurationFactory = new DefaultConfigurationFactory();
        RuntimeConfiguration configuration = (RuntimeConfiguration)configurationFactory.createConfiguration(containerId, ContainerType.REMOTE, ConfigurationType.RUNTIME);
        configuration.setProperty("cargo.remote.username", userName);
        configuration.setProperty("cargo.remote.password", password);
        if (containerId.startsWith("tomcat")) {
            configuration.setProperty("cargo.remote.uri", new URL(server, "/manager").toExternalForm());
        }
        this.container = (RemoteContainer)new DefaultContainerFactory().createContainer(containerId, ContainerType.REMOTE, (Configuration)configuration);
    }

    @Override
    protected URL getServiceUrl(String contextPath) throws Exception {
        return new URL(this.serverUrl, "/" + contextPath + "/");
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void shutdown() throws Exception {
    }

    public String toString() {
        return "CargoRemoteContainer:" + ((RemoteContainer)this.container).getId();
    }
}

