/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.container.cargo;

import com.sun.istack.NotNull;
import com.sun.xml.ws.test.container.AbstractApplicationContainer;
import com.sun.xml.ws.test.container.Application;
import com.sun.xml.ws.test.container.DeployedService;
import com.sun.xml.ws.test.container.cargo.CargoApplication;
import com.sun.xml.ws.test.tool.WsTool;
import java.io.File;
import java.net.URL;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.container.deployer.DeployerType;
import org.codehaus.cargo.container.deployer.URLDeployableMonitor;
import org.codehaus.cargo.generic.AbstractFactoryRegistry;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.generic.deployer.DefaultDeployerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractCargoContainer<C extends Container>
extends AbstractApplicationContainer {
    protected C container;
    protected final DefaultDeployerFactory deployerFactory = new DefaultDeployerFactory(AbstractFactoryRegistry.class.getClassLoader());
    protected final DefaultDeployableFactory deployableFactory = new DefaultDeployableFactory(AbstractFactoryRegistry.class.getClassLoader());

    protected AbstractCargoContainer(WsTool wsimport, WsTool wsgen, boolean httpspi) {
        super(wsimport, wsgen, httpspi);
    }

    @Override
    public String getTransport() {
        return "http";
    }

    @Override
    @NotNull
    public Application deploy(DeployedService service) throws Exception {
        File archive;
        String contextPath = service.service.getGlobalUniqueName();
        if (this.needsArchive()) {
            archive = new File(service.workDir, contextPath + ".war");
            this.createWARZip(service, archive);
        } else {
            archive = this.assembleWar((DeployedService)service).root;
        }
        WAR war = (WAR)this.deployableFactory.createDeployable(this.container.getId(), archive.getAbsolutePath(), DeployableType.WAR);
        war.setContext(contextPath);
        Deployer deployer = this.deployerFactory.createDeployer(this.container, DeployerType.toType((ContainerType)this.container.getType()));
        URL serviceUrl = this.getServiceUrl(contextPath);
        System.out.println("Verifying that " + serviceUrl + " is already removed");
        try {
            deployer.undeploy((Deployable)war);
        }
        catch (Exception e) {
            // empty catch block
        }
        System.out.println("Deploying a service to " + serviceUrl);
        deployer.deploy((Deployable)war, (DeployableMonitor)new URLDeployableMonitor(serviceUrl));
        return new CargoApplication(deployer, (Deployable)war, serviceUrl, service);
    }

    protected abstract URL getServiceUrl(String var1) throws Exception;

    protected boolean needsArchive() {
        return true;
    }
}

