/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test;

import com.sun.istack.Nullable;
import com.sun.xml.ws.test.World;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.tools.ant.loader.AntClassLoader2;
import org.apache.tools.ant.types.Path;

public class Realm {
    private final String name;
    @Nullable
    private final Realm parent;
    private final Path classPath = new Path(World.project);
    private AntClassLoader2 classLoader;

    public Realm(String name, Realm parent) {
        this.name = name;
        this.parent = parent;
    }

    public synchronized ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            ClassLoader pcl = ClassLoader.getSystemClassLoader();
            if (this.parent != null) {
                pcl = this.parent.getClassLoader();
            }
            this.classLoader = World.emma != null ? World.emma.createInstrumentingClassLoader() : new AntClassLoader2();
            this.classLoader.setParent(pcl);
            this.classLoader.setProject(World.project);
            this.classLoader.setClassPath(this.classPath);
            this.classLoader.setDefaultAssertionStatus(true);
        }
        return this.classLoader;
    }

    public void addJar(File jar) throws IOException {
        assert (this.classLoader == null) : "classLoader is already created";
        if (!jar.exists()) {
            throw new IOException("No such file: " + jar);
        }
        this.classPath.createPathElement().setLocation(jar);
    }

    public void addClassFolder(File classFolder) throws IOException {
        this.addJar(classFolder);
    }

    public void addJarFolder(File folder, final String ... excludes) throws IOException {
        File[] children;
        if (!folder.isDirectory()) {
            throw new IOException("Not a directory " + folder);
        }
        for (File child : children = folder.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                for (String name : excludes) {
                    if (!pathname.getName().equals(name)) continue;
                    return false;
                }
                return pathname.getPath().endsWith(".jar");
            }
        })) {
            this.addJar(child);
        }
    }

    public void dump(PrintStream out) {
        for (String item : this.classPath.toString().split(File.pathSeparator)) {
            out.println("  " + item);
        }
    }

    public String toString() {
        return this.name + " realm";
    }

    public File[] list() {
        String[] names = this.classPath.list();
        File[] r = new File[names.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = new File(names[i]);
        }
        return r;
    }

    public Path getPath() {
        return this.classPath;
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.getClassLoader().loadClass(className);
    }
}

