/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.container.invm;

import com.sun.istack.NotNull;
import com.sun.xml.ws.test.World;
import com.sun.xml.ws.test.client.InterpreterEx;
import com.sun.xml.ws.test.container.AbstractApplicationContainer;
import com.sun.xml.ws.test.container.Application;
import com.sun.xml.ws.test.container.DeployedService;
import com.sun.xml.ws.test.container.WAR;
import com.sun.xml.ws.test.container.invm.InVmApplication;
import com.sun.xml.ws.test.tool.WsTool;
import com.sun.xml.ws.test.util.XMLUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class InVmContainer
extends AbstractApplicationContainer {
    public InVmContainer(WsTool wsimport, WsTool wsgen) {
        super(wsimport, wsgen, false);
    }

    @Override
    public String getTransport() {
        return "in-vm";
    }

    @Override
    public void start() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    @NotNull
    public Application deploy(DeployedService service) throws Exception {
        String id = service.service.getGlobalUniqueName();
        WAR war = this.assembleWar(service);
        if (service.service.isSTS) {
            Object newLocation = "in-vm://" + id + "/";
            newLocation = ((String)newLocation).replace('\\', '/');
            this.updateWsitClient(war, service, (String)newLocation);
        }
        for (File wsdl : war.getWSDL()) {
            this.patchWsdl(service, wsdl, id);
        }
        URLClassLoader serviceClassLoader = new URLClassLoader(new URL[]{new File(service.warDir, "WEB-INF/classes").toURL()}, World.runtime.getClassLoader());
        InterpreterEx i = new InterpreterEx(serviceClassLoader);
        i.set("id", id);
        i.set("dir", service.warDir);
        Object server = i.eval("new com.sun.xml.ws.transport.local.InVmServer(id,dir)");
        return new InVmApplication(war, server, new URI("in-vm://" + id + "/"));
    }

    private void patchWsdl(DeployedService service, File wsdl, String id) throws Exception {
        Document doc = XMLUtil.readXML(wsdl, null);
        if (service.service.isSTS) {
            Attr loc;
            for (Element element : XMLUtil.getElements(doc, "//*[local-name()='KeyStore']")) {
                loc = element.getAttributeNode("location");
                loc.setValue(loc.getValue().replaceAll("\\$WSIT_HOME", System.getProperty("WSIT_HOME")));
            }
            for (Element element : XMLUtil.getElements(doc, "//*[local-name()='TrustStore']")) {
                loc = element.getAttributeNode("location");
                loc.setValue(loc.getValue().replaceAll("\\$WSIT_HOME", System.getProperty("WSIT_HOME")));
            }
        }
        List<Element> ports = XMLUtil.getElements(doc, "//*[local-name()='service']/*");
        for (Element port : ports) {
            Element wsaAddrEl;
            String portName = port.getAttribute("name");
            Element address = this.getSoapAddress(port);
            if (address == null) continue;
            if (!"wsdl".equalsIgnoreCase(wsdl.getParentFile().getName())) {
                portName = wsdl.getParentFile().getName() + portName;
            }
            Attr locationAttr = address.getAttributeNode("location");
            String newLocation = "in-vm://" + id + "/?" + portName;
            newLocation = newLocation.replace('\\', '/');
            locationAttr.setValue(newLocation);
            NodeList nl = port.getElementsByTagNameNS("http://www.w3.org/2005/08/addressing", "EndpointReference");
            Element wsaEprEl = nl.getLength() > 0 ? (Element)nl.item(0) : null;
            if (wsaEprEl == null || (wsaAddrEl = (nl = wsaEprEl.getElementsByTagNameNS("http://www.w3.org/2005/08/addressing", "Address")).getLength() > 0 ? (Element)nl.item(0) : null) == null) continue;
            wsaAddrEl.setTextContent(newLocation);
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(wsdl);){
            XMLUtil.writeXML(doc, fileOutputStream);
            fileOutputStream.flush();
        }
    }

    private Element getSoapAddress(Element port) {
        for (Element address : XMLUtil.getChildren(port, Element.class)) {
            if (!"address".equals(address.getLocalName()) || !"http://schemas.xmlsoap.org/wsdl/soap/".equals(address.getNamespaceURI()) && !"http://schemas.xmlsoap.org/wsdl/soap12/".equals(address.getNamespaceURI())) continue;
            return address;
        }
        return null;
    }
}

