/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test;

import bsh.Interpreter;
import com.sun.istack.test.AntXmlFormatter;
import com.sun.istack.test.VersionNumber;
import com.sun.xml.ws.test.CodeGenerator;
import com.sun.xml.ws.test.FailedTest;
import com.sun.xml.ws.test.Realm;
import com.sun.xml.ws.test.VersionNumberHandler;
import com.sun.xml.ws.test.World;
import com.sun.xml.ws.test.WsGenMode;
import com.sun.xml.ws.test.container.AbstractApplicationContainer;
import com.sun.xml.ws.test.container.ApplicationContainer;
import com.sun.xml.ws.test.container.cargo.EmbeddedCargoApplicationContainer;
import com.sun.xml.ws.test.container.cargo.InstalledCargoApplicationContainer;
import com.sun.xml.ws.test.container.cargo.RemoteCargoApplicationContainer;
import com.sun.xml.ws.test.container.gf.GlassfishContainer;
import com.sun.xml.ws.test.container.invm.InVmContainer;
import com.sun.xml.ws.test.container.javase.JavaSeContainer;
import com.sun.xml.ws.test.container.local.LocalApplicationContainer;
import com.sun.xml.ws.test.model.TestDescriptor;
import com.sun.xml.ws.test.tool.WsTool;
import com.sun.xml.ws.test.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.xml.sax.SAXException;

public class Main {
    @Argument
    List<String> tests = new ArrayList<String>();
    @Option(name="-r", usage="find test directories recursively")
    boolean recursive = false;
    @Option(name="-p", usage="run multiple tests in parallel")
    int parallel = 1;
    @Option(name="-cp:wsit-image", usage="classpath option\npath to the WSIT dist image", metaVar="WSIT_HOME")
    File wsitImage = null;
    @Option(name="-cp:wsit", usage="classpath option\npath to WSIT workspace", metaVar="WSIT_HOME")
    File wsitWs = null;
    @Option(name="-cp:jaxws-image", usage="classpath option\npath to JAX-WS RI dist image", metaVar="JAXWS_HOME")
    File jaxwsImage = null;
    @Option(name="-cp:jaxws", usage="classpath option\npath to JAX-WS RI workspace", metaVar="JAXWS_HOME")
    File jaxwsWs = null;
    @Option(name="-external-wsimport", usage="use external tool.sh/.bat")
    File externalWsImport = null;
    @Option(name="-external-wsgen", usage="use external wsgen.sh/.bat")
    File externalWsGen = null;
    @Option(name="-skip", usage="skip all code generation and reuse the artifacts generated during the last run")
    boolean skipCompilation;
    @Option(name="-transport", usage="specify the pluggable transport jar")
    File transportJar;
    @Option(name="-cp:override", usage="these jars and folders are placed in front of other -cp:*** options. Useful for overriding some jars")
    String classPathOverride;
    @Option(name="-debug", usage="Generate output for debugging harness")
    boolean debug;
    @Option(name="-dump", usage="Enable all transport dumps")
    boolean dump;
    @Option(name="-generateTestSources", usage="Generates plain java sources + bash scripts to run the testcase (works just for JavaSE deployment)")
    boolean generateTestSources;
    @Option(name="-report", usage="Generate JUnit test report XMLs", metaVar="DIR")
    File reportDir = null;
    @Option(name="-concurrent-side-effect-free", usage="Run all side-effect free tests as concurrent")
    boolean concurrentSideEffectFree = false;
    @Option(name="-version", usage="Specify the target JAX-WS version being tested. This determines test exclusions", handler=VersionNumberHandler.class)
    VersionNumber version = null;
    @Option(name="-targetVersion", usage="Specify the target JAX-WS runtime version. This determines target option for the WS Tools to generate code compliant with the runtime version", handler=VersionNumberHandler.class)
    VersionNumber targetVersion = null;
    @Option(name="-client", usage="Just run a single client script, instead of all")
    String clientScriptName = null;
    @Option(name="-tomcat-local", usage="Launch Tomcat from the harness and test with it", metaVar="TOMCAT_HOME")
    File tomcat = null;
    @Option(name="-tomcat-remote", metaVar="CONFIG", usage="Test with remote Tomcat.\nCONFIG=[USER:PASS@]HOST[:PORT].\nDefaults: USER=admin, PASS=admin, PORT=8080")
    String remoteTomcat = null;
    @Option(name="-tomcat-embedded", metaVar="TOMCAT_HOME", usage="loads Tomcat into the harness VM and test with it.")
    File embeddedTomcat = null;
    @Option(name="-jetty-embedded", metaVar="JETTY_HOME", usage="loads Jetty into the harness VM and test with it.")
    File embeddedJetty;
    @Option(name="-lwhs", usage="tests using the Java lightweight HTTP server")
    boolean lwhs = false;
    @Option(name="-jaxwsInJDK", usage="tests using JAX-WS impl in JDK")
    boolean jaxwsInJDK = false;
    @Option(name="-httpspi", usage="use JAX-WS 2.2 httpspi API deployment for servlet containers")
    boolean httpspi = false;
    @Option(name="-glassfish-remote", metaVar="CONFIG", usage="Test with remote Glassfish. Needs both JMX connection info and HTTP URL.\nCONFIG=[USER:PASS@]HOST[:PORT][-HTTPURL]\ne.g., admin:adminadmin@localhost:4848-http://localhost:8080/\nDefaults: USER=admin, PASS=adminadmin, PORT=4848, HTTPURL=http://HOST/")
    String remoteGlassfish = null;
    @Option(name="-glassfish-local", metaVar="GLASSFISH_HOME", usage="Launch Glassfish from the harness and test with it")
    File localGlassfish = null;
    @Option(name="-glassfishv3-local", metaVar="GLASSFISH_HOME", usage="Launch Glassfish v3 from the harness and test with it")
    File localGlassfishV3 = null;
    @Option(name="-legacy-local", usage="Emergency! I need to use the legacy local transport!")
    boolean legacyLocalTransport = false;
    @Option(name="-leave", usage="leave the container running after all the tests are completed. Often useful for debugging problems.")
    boolean leave = false;
    @Option(name="-toolsDump", usage="Dumps WsTools parameters. Useful for reproducing tools problems.")
    boolean toolsDump = false;
    @Option(name="-toolsExtraArgs", usage="Adds extra argument(s) to all WsTools invocation. \nUseful when extra JVM param is necessary \ne.g. -toolsExtraArgs -J-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=5005", metaVar="TOOLS_ARGS")
    String toolsExtraArgs = null;
    @Option(name="-port", usage="Choose the TCP port used for local/embedded container-based tests. Set to -1 to choose random port.")
    int port = -1;
    @Option(name="-wsgen", usage="Control the packaging of Wrapper and Exception beans.\nalways - Beans are packaged.\nboth - Test case is executed twice, with and without packaging beans.\nignore - Beans are NOT packaged.", metaVar="[always|both|ignore]")
    WsGenMode wsGenMode = WsGenMode.ALWAYS;
    public static File[] containerClasspathPrefix = new File[0];

    public static void main(String[] args) throws Exception {
        Main.class.getClassLoader().setDefaultAssertionStatus(true);
        try {
            System.setProperty("java.net.useSystemProxies", "true");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        System.exit(Main.doMain(args));
    }

    public static int doMain(String[] args) throws Exception {
        Main main = new Main();
        CmdLineParser parser = new CmdLineParser((Object)main);
        try {
            parser.parseArgument(args);
            if (main.tests.isEmpty()) {
                throw new CmdLineException("No test is given");
            }
            CodeGenerator.setGenerateTestSources(main.generateTestSources);
            return main.run();
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            parser.printUsage((OutputStream)System.err);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() throws Exception {
        WsTool wsimport;
        WsTool wsgen;
        this.fillWorld();
        if (this.dump) {
            System.setProperty("com.sun.xml.ws.transport.local.LocalTransportTube.dump", "true");
            System.setProperty("com.sun.xml.ws.transport.http.client.HttpTransportPipe.dump", "true");
            System.setProperty("com.sun.xml.ws.transport.http.HttpAdapter.dump", "true");
            System.setProperty("com.sun.xml.internal.ws.transport.local.LocalTransportTube.dump", "true");
            System.setProperty("com.sun.xml.internal.ws.transport.http.client.HttpTransportPipe.dump", "true");
            System.setProperty("com.sun.xml.internal.ws.transport.http.HttpAdapter.dump", "true");
        }
        if (this.skipCompilation) {
            System.err.println("Skipping compilation");
            wsimport = wsgen = WsTool.NOOP;
        } else {
            wsimport = WsTool.createWsImport(this.externalWsImport, this.toolsDump, this.toolsExtraArgs);
            wsgen = WsTool.createWsGen(this.externalWsGen, this.toolsDump, this.toolsExtraArgs);
        }
        ApplicationContainer container = this.createContainer(wsimport, wsgen);
        TestSuite suite = this.createTestSuite();
        for (String dir : this.tests) {
            this.build(new File(dir), container, wsimport, suite);
        }
        if (suite.countTestCases() == 0) {
            System.err.println("No test to run");
            return -1;
        }
        container.start();
        try {
            TestRunner testRunner = new TestRunner(){
                private AntXmlFormatter formatter;

                protected TestResult createTestResult() {
                    TestResult result = super.createTestResult();
                    if (Main.this.reportDir != null) {
                        Main.this.reportDir.mkdirs();
                        this.formatter = new AntXmlFormatter(XMLJUnitResultFormatter.class, Main.this.reportDir);
                        result.addListener((TestListener)this.formatter);
                    }
                    return result;
                }

                public TestResult doRun(Test test) {
                    try {
                        TestResult testResult = super.doRun(test);
                        return testResult;
                    }
                    finally {
                        if (this.formatter != null) {
                            this.formatter.close();
                        }
                    }
                }
            };
            TestResult r = testRunner.doRun((Test)suite);
            int n = r.errorCount() + r.failureCount();
            return n;
        }
        finally {
            if (!this.leave) {
                container.shutdown();
            } else if (container instanceof JavaSeContainer) {
                for (int i = 10; i > 0; --i) {
                    System.err.println("Keeping JavaSeContainer on for debugging. Shutting down in [" + i * 30 + " secs] ...");
                    Thread.sleep(30000L);
                }
                System.err.println("Shutting JavaSeContainer down.");
            }
            CodeGenerator.testCaseDone();
            CodeGenerator.allTestsDone(this.tests.get(0));
        }
    }

    private void fillWorld() throws Exception {
        File classesJar;
        File jreHome;
        File toolsJar;
        World.debug = this.debug;
        Realm runtime = World.runtime;
        Realm tool = World.tool;
        if (this.classPathOverride != null) {
            StringTokenizer tokens = new StringTokenizer(this.classPathOverride, File.pathSeparator);
            while (tokens.hasMoreTokens()) {
                runtime.addJar(new File(tokens.nextToken()));
            }
        }
        if (this.transportJar != null) {
            if (this.transportJar.exists()) {
                runtime.addJar(this.transportJar);
            } else {
                throw new IllegalArgumentException(this.transportJar + " does not exist.");
            }
        }
        if (this.embeddedTomcat != null) {
            runtime.addJarFolder(new File(this.embeddedTomcat, "bin"), new String[0]);
            runtime.addJarFolder(new File(this.embeddedTomcat, "common/lib"), new String[0]);
            runtime.addJarFolder(new File(this.embeddedTomcat, "server/lib"), new String[0]);
        }
        if (this.tomcat != null) {
            runtime.addJarFolder(new File(this.tomcat, "bin"), new String[0]);
            runtime.addJarFolder(new File(this.tomcat, "lib"), new String[0]);
        }
        if (this.embeddedJetty != null) {
            runtime.addJarFolder(this.embeddedJetty, new String[0]);
            runtime.addJarFolder(new File(this.embeddedJetty, "lib"), new String[0]);
        }
        if (this.wsitImage == null && this.wsitWs == null && this.jaxwsImage == null && this.jaxwsWs == null && !this.jaxwsInJDK) {
            this.guessWorkspace();
        }
        if (this.wsitImage != null) {
            File rtJar;
            if (System.getProperty("java.endorsed.dirs") == null) {
                rtJar = new File(this.wsitImage, "lib/webservices-api.jar");
                runtime.addJar(rtJar);
            }
            rtJar = new File(this.wsitImage, "lib/webservices-rt.jar");
            runtime.addJar(rtJar);
            File toolJar = new File(this.wsitImage, "lib/webservices-tools.jar");
            tool.addJar(toolJar);
            File[] extraJar = new File(this.wsitImage, "lib/webservices-extra.jar");
            runtime.addJar((File)extraJar);
            File extraApiJar = new File(this.wsitImage, "lib/webservices-extra-api.jar");
            runtime.addJar(extraApiJar);
            containerClasspathPrefix = new File[5];
        } else if (this.wsitWs != null) {
            runtime.addClassFolder(new File(this.wsitWs, "rt/build/classes"));
            runtime.addJarFolder(new File(this.wsitWs, "lib/runtime"), new String[0]);
            tool.addClassFolder(new File(this.wsitWs, "tools/build/classes"));
            tool.addJarFolder(new File(this.wsitWs, "lib/tooltime"), new String[0]);
        } else if (this.jaxwsImage != null) {
            tool.addJar(new File(this.jaxwsImage, "lib/jaxws-tools.jar"));
            if (new File(this.jaxwsImage, "lib/jaxb-jxc.jar").exists()) {
                tool.addJar(new File(this.jaxwsImage, "lib/jaxb-jxc.jar"));
            }
            tool.addJar(new File(this.jaxwsImage, "lib/jaxb-xjc.jar"));
            ArrayList<String> exclusionList = new ArrayList<String>();
            exclusionList.add("saaj-api.jar");
            exclusionList.add("jaxb-api.jar");
            exclusionList.add("jaxws-tools.jar");
            exclusionList.add("jaxws-api.jar");
            exclusionList.add("jaxb-jxc.jar");
            exclusionList.add("jaxb-xjc.jar");
            if (System.getProperty("java.endorsed.dirs") != null) {
                exclusionList.add("jakarta.jws-api.jar");
                exclusionList.add("jakarta.xml.bind-api.jar");
                exclusionList.add("jakarta.xml.soap-api.jar");
                exclusionList.add("jakarta.xml.ws-api.jar");
            }
            runtime.addJarFolder(new File(this.jaxwsImage, "lib"), exclusionList.toArray(new String[exclusionList.size()]));
        } else if (this.jaxwsWs != null) {
            if (new File(this.jaxwsWs, "pom.xml").exists()) {
                String classesFolder;
                String string = classesFolder = new File(this.jaxwsWs, "rt/target/generated-classes/cobertura").exists() ? "target/generated-classes/cobertura" : "target/classes";
                if (new File(this.jaxwsWs, "rt/" + classesFolder + "/META-INF/versions/9").exists()) {
                    runtime.addClassFolder(new File(this.jaxwsWs, "rt/" + classesFolder + "/META-INF/versions/9"));
                }
                runtime.addClassFolder(new File(this.jaxwsWs, "rt/" + classesFolder));
                if (new File(this.jaxwsWs, "rt-ha/" + classesFolder).exists()) {
                    runtime.addClassFolder(new File(this.jaxwsWs, "rt-ha/" + classesFolder));
                }
                runtime.addClassFolder(new File(this.jaxwsWs, "servlet/" + classesFolder));
                runtime.addClassFolder(new File(this.jaxwsWs, "rt-fi/" + classesFolder));
                runtime.addClassFolder(new File(this.jaxwsWs, "httpspi-servlet/" + classesFolder));
                runtime.addClassFolder(new File(this.jaxwsWs, "transports/local/" + classesFolder));
                runtime.addClassFolder(new File(this.jaxwsWs, "tools/wscompile/src/main/resources"));
                if ("com.sun.xml.ws.db.toplink.JAXBContextFactory".equals(System.getProperty("BindingContextFactory"))) {
                    runtime.addClassFolder(new File(this.jaxwsWs, "eclipselink_jaxb/" + classesFolder));
                } else if ("com.sun.xml.ws.db.sdo.SDOContextFactory".equals(System.getProperty("BindingContextFactory"))) {
                    runtime.addClassFolder(new File(this.jaxwsWs, "eclipselink_sdo/" + classesFolder));
                }
                if (new File(this.jaxwsWs, "tools/wscompile/" + classesFolder + "/META-INF/versions/9").exists()) {
                    tool.addClassFolder(new File(this.jaxwsWs, "tools/wscompile/" + classesFolder + "/META-INF/versions/9"));
                }
                tool.addClassFolder(new File(this.jaxwsWs, "tools/wscompile/" + classesFolder));
                File libDir = System.getProperty("libraries.dir") != null ? new File(System.getProperty("libraries.dir")) : new File(this.jaxwsWs, "bundles/jaxws-ri/target/stage/jaxws-ri/lib");
                for (File lib : libDir.listFiles()) {
                    String name = lib.getName();
                    if (name.contains("jaxws-rt") || name.contains("jaxws-tools")) continue;
                    if (name.contains("jaxb-api") || name.contains("jaxws-api") || name.contains("saaj-api")) {
                        System.out.println("Ommitting: " + lib.getAbsolutePath());
                        continue;
                    }
                    if (name.contains("jaxb-jxc") || name.contains("jaxb-xjc")) {
                        tool.addJar(lib);
                        continue;
                    }
                    runtime.addJar(lib);
                }
            } else if (new File(this.jaxwsWs, "rt/build/classes").exists()) {
                System.out.println("WARNING: Ant based workspace...");
                runtime.addClassFolder(new File(this.jaxwsWs, "rt/build/classes"));
                File file = new File(this.jaxwsWs, "rt-ha/build/classes");
                if (file.exists()) {
                    runtime.addClassFolder(file);
                }
                runtime.addClassFolder(new File(this.jaxwsWs, "rt/src"));
                runtime.addClassFolder(new File(this.jaxwsWs, "servlet/build/classes"));
                runtime.addClassFolder(new File(this.jaxwsWs, "servlet/src"));
                runtime.addClassFolder(new File(this.jaxwsWs, "rt-fi/build/classes"));
                runtime.addClassFolder(new File(this.jaxwsWs, "transports/local/build/classes"));
                runtime.addClassFolder(new File(this.jaxwsWs, "transports/local/src"));
                tool.addClassFolder(new File(this.jaxwsWs, "tools/wscompile/build/classes"));
                runtime.addClassFolder(new File(this.jaxwsWs, "tools/wscompile/src"));
                tool.addJar(new File(this.jaxwsWs, "lib/jaxb-xjc.jar"));
                runtime.addJarFolder(new File(this.jaxwsWs, "lib"), "jaxb-xjc.jar");
                file = new File(this.jaxwsWs, "rt-ha/lib");
                if (file.exists()) {
                    runtime.addJarFolder(file, new String[0]);
                }
            }
        } else if (this.jaxwsInJDK) {
            System.out.println("Using JAX-WS in JDK");
            File javaHome = new File(System.getProperty("java.home"));
            this.findWsTools(javaHome.getParent());
            if (!this.externalWsGen.exists() || !this.externalWsImport.exists()) {
                this.findWsTools(javaHome.getAbsolutePath());
            }
            if (!this.externalWsGen.exists() || !this.externalWsImport.exists()) {
                throw new CmdLineException("wsgen or wsimport command line tools are not found in jdk");
            }
            System.out.println("Using wsgen from " + this.externalWsGen);
            System.out.println("Using wsimport from " + this.externalWsImport);
            this.lwhs = true;
            if (this.version == null) {
                this.version = new VersionNumber("2.1.6");
            }
            System.out.println("Going to use SE lightweight http server");
        } else {
            throw new CmdLineException("No -cp option is specified, nor were we able to guess the -cp option");
        }
        File extDir = null;
        if (System.getProperty("HARNESS_HOME") != null) {
            extDir = new File(System.getProperty("HARNESS_HOME"), "ext");
        } else if (System.getProperty("HARNESS_EXT") != null) {
            extDir = new File(System.getProperty("HARNESS_EXT"));
        }
        if (extDir != null && extDir.isDirectory()) {
            if (this.debug) {
                System.err.println("Searching extensions in " + extDir);
            }
            if (extDir.exists()) {
                for (File f : extDir.listFiles(FileUtil.JAR_FILE_FILTER)) {
                    System.err.println("Picking up extension: " + f);
                    runtime.addJar(f);
                }
            }
        } else {
            System.err.println("No extension jar");
        }
        if ((toolsJar = new File((jreHome = new File(System.getProperty("java.home"))).getParent(), "lib/tools.jar")).exists()) {
            tool.addJar(toolsJar);
        }
        if ((classesJar = new File(jreHome.getParent(), "Classes/classes.jar")).exists()) {
            tool.addJar(classesJar);
        }
        if (this.debug) {
            Interpreter.DEBUG = true;
            System.err.println("runtime realm");
            runtime.dump(System.err);
            System.err.println("tool realm");
            tool.dump(System.err);
            DefaultLogger listener = new DefaultLogger();
            World.project.addBuildListener((BuildListener)listener);
            listener.setMessageOutputLevel(2);
            listener.setOutputPrintStream(System.out);
            listener.setErrorPrintStream(System.err);
        }
    }

    private void findWsTools(String path) {
        this.externalWsGen = new File(path, "bin/wsgen");
        if (!this.externalWsGen.exists()) {
            this.externalWsGen = new File(path, "bin/wsgen.exe");
        }
        this.externalWsImport = new File(path, "bin/wsimport");
        if (!this.externalWsImport.exists()) {
            this.externalWsImport = new File(path, "bin/wsimport.exe");
        }
    }

    private void guessWorkspace() {
        File wsitHome;
        File harnessJar;
        File jaxwsUnit;
        File f;
        String jaxwsHome = System.getenv("JAXWS_HOME");
        if (jaxwsHome != null && (f = new File(jaxwsHome)).isDirectory()) {
            File home;
            if (f.getName().equals("build") && new File(home = f.getParentFile(), ".jaxws-ri").exists()) {
                System.out.println("Found JAX-WS RI workspace at " + home);
                this.jaxwsWs = home;
                return;
            }
            if (new File(f, ".jaxws-ri").exists()) {
                System.out.println("Found JAX-WS RI workspace at " + f);
                this.jaxwsWs = f;
                return;
            }
            if (new File(f, "lib/jaxws-rt.jar").exists() && new File(f, "bin/wsgen.bat").exists()) {
                System.out.println("Found JAX-WS RI distribution image at " + f);
                this.jaxwsImage = f;
                return;
            }
        }
        if ((jaxwsUnit = this.getParentWithName(harnessJar = Main.getHarnessJarDirectory(), "jaxws-unit")) != null) {
            for (File other : jaxwsUnit.getParentFile().listFiles(FileUtil.DIRECTORY_FILTER)) {
                if (!new File(other, ".jaxws-ri").exists()) continue;
                System.out.println("Found JAX-WS RI workspace at " + other);
                this.jaxwsWs = other;
                return;
            }
        }
        if ((wsitHome = this.getParentWithFile(harnessJar, ".wsit")) != null) {
            System.out.println("Found WSIT workspace at " + wsitHome);
            this.wsitWs = wsitHome;
        }
    }

    private ApplicationContainer createContainer(WsTool wsimport, WsTool wsgen) throws Exception {
        Matcher matcher;
        AbstractApplicationContainer appContainer = null;
        if (this.tomcat != null) {
            TomcatVersion tv = Main.getTomcatVersion(this.tomcat);
            System.err.println("Using Tomcat from " + this.tomcat);
            System.err.println("\tSpecification version " + tv.getSpecVersion());
            System.err.println("\tImplementation version " + tv.getImplVersion());
            appContainer = new InstalledCargoApplicationContainer(wsimport, wsgen, tv.getId(), this.tomcat, this.port, this.httpspi);
            if (!tv.supports("servlet30")) {
                appContainer.getUnsupportedUses().add("servlet30");
            }
        }
        if (this.embeddedTomcat != null) {
            appContainer = new EmbeddedCargoApplicationContainer(wsimport, wsgen, "tomcat5x", this.port, this.httpspi);
            appContainer.getUnsupportedUses().add("servlet30");
        }
        if (this.embeddedJetty != null) {
            appContainer = new EmbeddedCargoApplicationContainer(wsimport, wsgen, "jetty6x", this.port, this.httpspi);
            appContainer.getUnsupportedUses().add("servlet30");
        }
        if (this.remoteTomcat != null) {
            System.err.println("Using remote Tomcat at " + this.remoteTomcat);
            matcher = Pattern.compile("((.+):(.*)@)?([^:]+)(:([0-9]+))?").matcher(this.remoteTomcat);
            if (!matcher.matches()) {
                throw new CmdLineException("Unable to parse " + this.remoteTomcat);
            }
            appContainer = new RemoteCargoApplicationContainer(wsimport, wsgen, "tomcat9x", new URL("http", matcher.group(4), Integer.parseInt(Main.defaultsTo(matcher.group(6), "8080")), "/"), Main.defaultsTo(matcher.group(2), "admin"), Main.defaultsTo(matcher.group(3), "admin"), this.httpspi);
            appContainer.getUnsupportedUses().add("servlet30");
        }
        if (this.localGlassfish != null) {
            System.err.println("Using local Glassfish from " + this.localGlassfish);
            appContainer = new InstalledCargoApplicationContainer(wsimport, wsgen, "glassfish1x", this.localGlassfish, this.port, this.httpspi);
            appContainer.getUnsupportedUses().add("servlet30");
        }
        if (this.localGlassfishV3 != null) {
            System.err.println("Using local Glassfish v3 from " + this.localGlassfishV3);
            appContainer = new InstalledCargoApplicationContainer(wsimport, wsgen, "glassfish3x", this.localGlassfishV3, this.port, this.httpspi);
        }
        if (this.remoteGlassfish != null) {
            System.err.println("Using remote Glassfish at " + this.remoteGlassfish);
            matcher = Pattern.compile("((.+):(.*)@)?([^:\\-]+)(:([0-9]+))?(\\-(.+))?").matcher(this.remoteGlassfish);
            if (!matcher.matches()) {
                throw new CmdLineException("Unable to parse " + this.remoteGlassfish);
            }
            String userName = Main.defaultsTo(matcher.group(2), "admin");
            String password = Main.defaultsTo(matcher.group(3), "adminadmin");
            String remoteHost = matcher.group(4);
            String remotePort = Main.defaultsTo(matcher.group(6), "4848");
            String httpUrl = matcher.group(8);
            if (httpUrl == null) {
                httpUrl = "http://" + remoteHost + ":8080/";
            }
            appContainer = new GlassfishContainer(wsimport, wsgen, new URL(httpUrl), remoteHost, Integer.parseInt(remotePort), userName, password, this.httpspi);
            appContainer.getUnsupportedUses().add("servlet30");
        }
        if (this.lwhs) {
            System.err.println("Using the built-in Java SE lightweight HTTP server");
            HashSet<String> unsupportedUses = new HashSet<String>();
            unsupportedUses.add("servlet");
            unsupportedUses.add("servlet30");
            unsupportedUses.add("multi-endpoint");
            unsupportedUses.add("skip-lwhs");
            if (this.jaxwsInJDK) {
                unsupportedUses.add("ri");
            }
            appContainer = new JavaSeContainer(wsimport, wsgen, this.port, unsupportedUses);
        }
        if (this.legacyLocalTransport) {
            System.err.println("Using the legacy local transport. This will be removed in a near future");
            appContainer = new LocalApplicationContainer(wsimport, wsgen);
            appContainer.getUnsupportedUses().add("servlet30");
        }
        if (appContainer == null) {
            System.err.println("Testing with the in-vm transport");
            appContainer = new InVmContainer(wsimport, wsgen);
            appContainer.getUnsupportedUses().add("servlet30");
        }
        return appContainer;
    }

    private static String defaultsTo(String value, String defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private TestSuite createTestSuite() {
        if (this.parallel > 1) {
            System.err.println("Running tests in " + this.parallel + " threads");
            return new TestSuite();
        }
        return new TestSuite();
    }

    private void build(File dir, ApplicationContainer container, WsTool wsimport, TestSuite suite) throws IOException, ParserConfigurationException, SAXException {
        File descriptor = new File(dir, "test-descriptor.xml");
        if (descriptor.exists()) {
            try {
                TestDescriptor[] td = new TestDescriptor[2];
                if (this.wsGenMode == WsGenMode.ALWAYS) {
                    td[0] = new TestDescriptor(descriptor, false, this.jaxwsInJDK);
                } else if (this.wsGenMode == WsGenMode.BOTH) {
                    td[0] = new TestDescriptor(descriptor, false, this.jaxwsInJDK);
                    td[1] = new TestDescriptor(descriptor, true, this.jaxwsInJDK);
                } else if (this.wsGenMode == WsGenMode.IGNORE) {
                    td[0] = new TestDescriptor(descriptor, true, this.jaxwsInJDK);
                } else {
                    throw new RuntimeException("Shouldn't happen. WsGenMode=" + (Object)((Object)this.wsGenMode));
                }
                if (this.version != null && !td[0].applicableVersions.isApplicable(this.version)) {
                    System.err.println("Skipping " + dir);
                } else {
                    if (this.targetVersion != null) {
                        td[0].wsimportClientOptions.add("-target");
                        td[0].wsimportClientOptions.add(this.targetVersion.toString());
                        td[0].wsimportServerOptions.add("-target");
                        td[0].wsimportServerOptions.add(this.targetVersion.toString());
                        if (td[1] != null) {
                            td[1].wsimportClientOptions.add("-target");
                            td[1].wsimportClientOptions.add(this.targetVersion.toString());
                            td[1].wsimportServerOptions.add("-target");
                            td[1].wsimportServerOptions.add(this.targetVersion.toString());
                        }
                    }
                    suite.addTest((Test)td[0].build(container, wsimport, this.clientScriptName, this.concurrentSideEffectFree, this.version));
                    if (td[1] != null) {
                        suite.addTest((Test)td[1].build(container, wsimport, this.clientScriptName, this.concurrentSideEffectFree, this.version));
                    }
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                suite.addTest((Test)new FailedTest("invalid descriptor", e));
            }
            return;
        }
        if (this.recursive && dir.isDirectory()) {
            File[] subdirs;
            for (File subdir : subdirs = dir.listFiles(FileUtil.DIRECTORY_FILTER)) {
                this.build(subdir, container, wsimport, suite);
            }
        }
    }

    private static File getHarnessJarDirectory() {
        try {
            String res = Main.class.getClassLoader().getResource("com/sun/xml/ws/test/Main.class").toExternalForm();
            if (res.startsWith("jar:")) {
                res = res.substring(4, res.lastIndexOf(33));
                return new File(new URL(res).getFile()).getParentFile();
            }
            return new File(".").getAbsoluteFile();
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
    }

    private File getParentWithName(File file, String name) {
        while (file != null) {
            if (file.getName().equals(name)) {
                return file;
            }
            file = file.getParentFile();
        }
        return null;
    }

    private File getParentWithFile(File file, String markerFile) {
        while (file != null) {
            if (new File(file, markerFile).exists()) {
                return file;
            }
            file = file.getParentFile();
        }
        return null;
    }

    private static TomcatVersion getTomcatVersion(File tcHome) {
        String implVersion = null;
        String specVersion = null;
        try {
            File f = new File(tcHome, "lib/catalina.jar");
            if (f.exists() && f.canRead()) {
                Attributes attrs;
                JarFile jar = new JarFile(f);
                Manifest mf = jar.getManifest();
                if (mf != null && (attrs = mf.getMainAttributes()) != null) {
                    specVersion = attrs.getValue("Specification-Version");
                    implVersion = attrs.getValue("Implementation-Version");
                }
            } else {
                System.err.println("Cannot read: " + f.getAbsolutePath());
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
        return TomcatVersion.create(specVersion, implVersion);
    }

    private static class TomcatVersion {
        private String implVersion;
        private String specVersion;
        private String id;
        private final Set<String> features = new HashSet<String>();

        private TomcatVersion() {
        }

        static TomcatVersion create(String specVersion, String implVersion) {
            TomcatVersion tv = new TomcatVersion();
            tv.setSpecVersion(specVersion);
            tv.setImplVersion(implVersion);
            char major = '\u0000';
            if (implVersion != null) {
                major = implVersion.charAt(0);
            } else if (specVersion != null) {
                major = specVersion.charAt(0);
            }
            switch (major) {
                case '5': {
                    tv.setId("tomcat5x");
                    break;
                }
                case '6': {
                    tv.setId("tomcat6x");
                    break;
                }
                case '7': {
                    tv.setId("tomcat7x");
                    tv.addFeature("servlet30");
                    break;
                }
                case '8': {
                    tv.setId("tomcat8x");
                    tv.addFeature("servlet30");
                    tv.addFeature("servlet31");
                    break;
                }
                case '9': {
                    tv.setId("tomcat9x");
                    tv.addFeature("servlet30");
                    tv.addFeature("servlet31");
                    tv.addFeature("servlet40");
                    break;
                }
                default: {
                    Logger.getLogger(Main.class.getName()).log(Level.WARNING, "Unrecognized Tomcat version: {0}.{1}", new Object[]{specVersion, implVersion});
                    Logger.getLogger(Main.class.getName()).log(Level.WARNING, "Using default tomcat9x...");
                    tv.setId("tomcat9x");
                    tv.addFeature("servlet30");
                    tv.addFeature("servlet31");
                    tv.addFeature("servlet40");
                }
            }
            return tv;
        }

        public String getImplVersion() {
            return this.implVersion;
        }

        public void setImplVersion(String implVersion) {
            this.implVersion = implVersion;
        }

        public String getSpecVersion() {
            return this.specVersion;
        }

        public void setSpecVersion(String specVersion) {
            this.specVersion = specVersion;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        private void addFeature(String feature) {
            this.features.add(feature);
        }

        public boolean supports(String feature) {
            return this.features.contains(feature);
        }
    }
}

