/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.util;

import com.sun.xml.ws.test.SourcesCollector;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FreeMarkerTemplate {
    Map root = new HashMap();
    String templateName;
    static Configuration cfg = new Configuration(Configuration.VERSION_2_3_21);

    public FreeMarkerTemplate(String id, int scriptOrder, String workdir, String templateName) {
        this.templateName = templateName;
        this.root.put("serviceId", id != null ? id : "NULL");
        this.root.put("stage", scriptOrder);
        this.root.put("workdir", workdir);
    }

    public void put(String key, Object value) {
        this.root.put(key, value);
    }

    public String writeFile() {
        String workdir = (String)this.root.get("workdir");
        String stage = "" + this.root.get("stage");
        return this.writeFileTo(workdir, stage + "-" + this.templateName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeFileTo(String dir, String filename) {
        String fullFileName = dir + "/" + filename;
        SourcesCollector.ensureDirectoryExists(new File(fullFileName).getParent());
        System.out.println("\ngenerating file [" + fullFileName + "];\nparametersMap: [");
        Set entryset = this.root.entrySet();
        for (Map.Entry entry : entryset) {
            System.out.print("        ");
            System.out.print(entry.getKey());
            System.out.print(" : ");
            System.out.println(entry.getValue());
        }
        System.out.println("]\n");
        Writer out = null;
        try {
            Template temp = cfg.getTemplate(this.templateName);
            out = new FileWriter(fullFileName);
            temp.process((Object)this.root, out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return fullFileName;
    }

    static {
        cfg.setClassForTemplateLoading(FreeMarkerTemplate.class, "/com/sun/xml/ws/test/freemarker");
        cfg.setLocalizedLookup(false);
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
    }
}

