/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test;

import com.sun.xml.ws.test.SourcesCollector;
import com.sun.xml.ws.test.container.WAR;
import com.sun.xml.ws.test.model.TestEndpoint;
import com.sun.xml.ws.test.util.FreeMarkerTemplate;
import com.sun.xml.ws.test.util.JavacTask;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import junit.framework.Test;
import junit.framework.TestSuite;

public class CodeGenerator {
    private static boolean generateTestSources;
    public static int scriptOrder;
    public static String id;
    private static String lastTestcaseDir;
    private static String workDir;
    private static final List<String> testcaseScripts;
    private static final List<String> testcases;
    private static final List<String> shutdownPortList;
    private static int deployedServices;
    private static final int freePort = 8080;
    private static final Map<String, String> fixedServiceURLsBASH;
    private static final Map<String, String> fixedServiceURLsJava;

    public static void setGenerateTestSources(boolean generateTestSources) {
        CodeGenerator.generateTestSources = generateTestSources;
    }

    public static boolean isGenerateTestSources() {
        return generateTestSources;
    }

    public static void testCaseDone() {
        if (!generateTestSources) {
            return;
        }
        scriptOrder = 0;
        if (workDir == null) {
            return;
        }
        new FreeMarkerTemplate(id, scriptOrder, workDir, "shared").writeFileTo(workDir, "shared");
        FreeMarkerTemplate run = new FreeMarkerTemplate(id, scriptOrder, workDir, "run");
        run.put("scripts", CodeGenerator.toFilenames(testcaseScripts));
        run.put("shutdownPorts", shutdownPortList);
        String filename = run.writeFileTo(workDir, "run");
        testcases.add(filename);
        testcaseScripts.clear();
        FreeMarkerTemplate clean = new FreeMarkerTemplate(id, scriptOrder, workDir, "clean");
        clean.put("shutdownPorts", shutdownPortList);
        clean.writeFile();
        shutdownPortList.clear();
        fixedServiceURLsBASH.clear();
        fixedServiceURLsJava.clear();
        deployedServices = 0;
    }

    public static void allTestsDone(String dir) {
        if (!generateTestSources) {
            return;
        }
        new FreeMarkerTemplate(id, 0, CodeGenerator.chdir(dir), "runall").writeFileTo(CodeGenerator.chdir(dir), "/runall");
        FreeMarkerTemplate runall = new FreeMarkerTemplate(id, 0, CodeGenerator.chdir(dir), "testcases");
        runall.put("testcases", testcases);
        runall.writeFileTo(CodeGenerator.chdir(dir), "/testcases");
    }

    private static List<String> toFilenames(List<String> absolutePaths) {
        ArrayList<String> testcasesRelative = new ArrayList<String>();
        for (String s : absolutePaths) {
            testcasesRelative.add(s.substring(s.lastIndexOf(47) + 1));
        }
        return testcasesRelative;
    }

    private static List<String> toRelativePath(List<String> absolutePaths) {
        ArrayList<String> testcasesRelative = new ArrayList<String>();
        for (String s : absolutePaths) {
            testcasesRelative.add(CodeGenerator.toRelativePath(s));
        }
        return testcasesRelative;
    }

    public static void generateDeploy(Map<String, Object> params, String classpath, boolean fromwsdl) {
        if (!generateTestSources) {
            return;
        }
        if (workDir == null) {
            return;
        }
        FreeMarkerTemplate deploy = new FreeMarkerTemplate(id, scriptOrder, workDir, "deploy");
        classpath = CodeGenerator.chdir(classpath);
        classpath = CodeGenerator.toRelativePath(classpath);
        String serviceDirectory = classpath.replace(workDir, "").replaceAll("services/", "").replaceAll("war/WEB-INF/classes", "");
        deploy.put("serviceDirectory", serviceDirectory);
        classpath = classpath + ":" + classpath.replaceAll("/WEB-INF/classes", "");
        deploy.put("classpath", classpath);
        List<String> wsdlDocs = CodeGenerator.getWSDLDocs(params);
        if (fromwsdl) {
            deploy.put("wsdlDocs", wsdlDocs);
        } else {
            deploy.put("wsdlDocsFromJava", wsdlDocs);
        }
        deploy.put("packagePrefix", id.replaceAll("\\.", "/"));
        if (params.containsKey("wsdlLocation")) {
            deploy.put("wsdlLocation", params.get("wsdlLocation"));
            CodeGenerator.copySunJaxwsXML(serviceDirectory);
        }
        String filename = deploy.writeFile();
        File dir = new File(workDir + "/bsh");
        dir.mkdir();
        FreeMarkerTemplate deployClass = new FreeMarkerTemplate(id, scriptOrder, workDir, "bsh/Deploy.java_");
        for (String key : params.keySet()) {
            List<String> value = params.get(key);
            if (value instanceof List) {
                value = CodeGenerator.chdir(value);
            } else if (value instanceof String) {
                value = CodeGenerator.chdir((String)((Object)value));
            }
            deployClass.put(key, value);
        }
        deployClass.put("wsdlDocs", wsdlDocs);
        String port = "" + deployedServices;
        shutdownPortList.add(port);
        deployClass.put("svcNO", port);
        deployClass.writeFileTo(workDir + "/bsh", "Deploy" + scriptOrder + ".java");
        CodeGenerator.addScript(filename);
        ++deployedServices;
    }

    protected static void copySunJaxwsXML(String serviceDirectory) {
        String source = workDir + "/services/" + serviceDirectory + "/war/WEB-INF/sun-jaxws.xml";
        source = source.replaceAll("no-harness", "testcases");
        String destination = workDir + "/../src/" + serviceDirectory + "/sun-jaxws.xml";
        try {
            File sourceFile = new File(source);
            if (sourceFile.exists()) {
                SourcesCollector.copy(sourceFile, new File(destination));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static List<String> getWSDLDocs(Map<String, Object> params) {
        List<String> list = CodeGenerator.chdir((List)params.get("metadata_files"));
        ArrayList<String> result = new ArrayList<String>();
        String prefix = "WEB-INF/wsdl/";
        for (String file : list) {
            int pos = file.lastIndexOf(prefix) + prefix.length();
            result.add(file.substring(pos));
        }
        return result;
    }

    public static void generateClient(String testName, String mainClass) {
        if (!generateTestSources) {
            return;
        }
        if (workDir == null) {
            return;
        }
        FreeMarkerTemplate client = new FreeMarkerTemplate(id, scriptOrder, workDir, "client");
        client.put("classpath", "client-classes:.");
        client.put("testName", testName);
        client.put("clientClass", mainClass);
        String filename = client.writeFile();
        CodeGenerator.addScript(filename);
        File dir = new File(workDir + "/bsh");
        dir.mkdir();
    }

    public static void startTestCase(String testcaseDir) {
        String testId;
        if (!generateTestSources) {
            return;
        }
        scriptOrder = 1;
        int beginIndex = testcaseDir.indexOf("testcases/") + "testcases/".length();
        id = testId = testcaseDir.substring(beginIndex).replaceAll("/", ".");
        String destDir = CodeGenerator.chdir(testcaseDir);
        workDir = destDir + "/work";
        CodeGenerator.cleanDirectory(destDir);
        SourcesCollector.ensureDirectoryExists(workDir);
        CodeGenerator.copySources(testcaseDir);
        new FreeMarkerTemplate(id, scriptOrder, workDir, "bsh/Util.java_").writeFileTo(workDir + "/bsh", "Util.java");
        new FreeMarkerTemplate(id, scriptOrder, workDir, "junit/framework/TestCase.java_").writeFileTo(workDir + "/junit/framework", "TestCase.java");
        new FreeMarkerTemplate(id, scriptOrder, workDir, "junit/framework/Assert.java_").writeFileTo(workDir + "/junit/framework", "Assert.java");
    }

    protected static void cleanDirectory(String dir) {
        if (!dir.contains("jaxws-ri/tests/unit")) {
            CodeGenerator.abort("Trying to delete user files [" + dir + "]. Check you specified properly test to be run.");
        }
        try {
            File f = new File(dir);
            if (f.exists()) {
                CodeGenerator.delete(f);
            }
        }
        catch (IOException e) {
            System.err.println("Error while cleaning dest dir.");
            e.printStackTrace();
        }
    }

    static void delete(File f) throws IOException {
        String absolutePath = f.getAbsolutePath();
        if (!absolutePath.contains("jaxws-ri/tests/unit")) {
            CodeGenerator.abort("Trying to delete user files [" + absolutePath + "]. Check you specified properly test to be run.");
        }
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                CodeGenerator.delete(c);
            }
        }
        System.out.println("deleting file [" + f + "]");
        if (!f.delete()) {
            throw new FileNotFoundException("Failed to delete file: " + f);
        }
    }

    private static void abort(String message) {
        throw new RuntimeException(message);
    }

    protected static void copySources(String srcDir) {
        SourcesCollector collector = new SourcesCollector(srcDir);
        collector.copyFilesTo(CodeGenerator.chdir(srcDir) + "/src");
    }

    public static String chdir(String dir) {
        return dir.replaceAll("/testcases", "/no-harness");
    }

    private static List<String> chdir(List<String> list) {
        ArrayList<String> changed = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            String s = list.get(i);
            s = CodeGenerator.chdir(s);
            changed.add(s);
        }
        return changed;
    }

    private static List<String> moveToSrc2(List<String> list) {
        ArrayList<String> changed = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            String s = list.get(i);
            s = CodeGenerator.moveToSrc2(s);
            changed.add(s);
        }
        return changed;
    }

    public static void generateJavac(JavacTask javac) {
        if (!generateTestSources) {
            return;
        }
        ArrayList<String> mkdirs = new ArrayList<String>();
        String destDir = CodeGenerator.chdir(javac.getDestdir().toString());
        mkdirs.add(destDir);
        ArrayList<String> params = new ArrayList<String>();
        params.add("-d " + CodeGenerator.toRelativePath(destDir));
        params.add("-cp $SHARED_CLASSES:" + CodeGenerator.toRelativePath(CodeGenerator.chdir(javac.getClasspath().toString())));
        for (String p : javac.getSrcdir().list()) {
            p = CodeGenerator.chdir(p);
            p = CodeGenerator.toRelativePath(CodeGenerator.moveToSrc(p));
            params.add("`find " + p + " -name '*.java'`");
            mkdirs.add(p);
        }
        FreeMarkerTemplate run = new FreeMarkerTemplate(id, scriptOrder, workDir, "javac");
        run.put("mkdirs", CodeGenerator.toRelativePath(mkdirs));
        run.put("params", CodeGenerator.toRelativePath(params));
        String filename = run.writeFile();
        CodeGenerator.addScript(filename);
    }

    public static String moveToSrc(String directory) {
        File dir = new File(directory);
        File parent = dir.getParentFile();
        File testcaseDir = new File(workDir).getParentFile();
        if (dir.equals(testcaseDir)) {
            return dir.toString() + "/src";
        }
        if (parent.equals(testcaseDir)) {
            return parent.toString() + "/src/" + dir.getName();
        }
        return directory;
    }

    public static String moveToSrc2(String directory) {
        if (directory == null || workDir == null) {
            return directory;
        }
        String workDirParent = new File(workDir).getParent();
        if (directory.startsWith(workDirParent) && !directory.contains("/work/")) {
            System.out.println("fixing directory = \n\t\t" + directory);
            directory = directory.replaceAll(workDirParent, workDirParent + "/src/");
            System.out.println("\t>>" + directory);
        }
        return directory;
    }

    public static void generateTool(List<String> dirsToBeCretaed, List<String> params) {
        if (!generateTestSources) {
            return;
        }
        FreeMarkerTemplate template = new FreeMarkerTemplate(id, scriptOrder, workDir, "tool");
        template.put("dirs", CodeGenerator.toRelativePath(CodeGenerator.moveToSrc2(CodeGenerator.chdir(dirsToBeCretaed))));
        template.put("params", CodeGenerator.moveToSrc2(CodeGenerator.chdir(params)));
        String filename = template.writeFile();
        CodeGenerator.addScript(filename);
    }

    protected static void addScript(String filename) {
        testcaseScripts.add(filename);
        ++scriptOrder;
    }

    public static void generateClientClass(String testName, List<String> pImports, String pContents, Map<String, String> varMap) {
        if (!generateTestSources) {
            return;
        }
        File dir = new File(workDir + "/bsh");
        dir.mkdir();
        FreeMarkerTemplate clientClass = new FreeMarkerTemplate(id, scriptOrder, workDir, "bsh/Client.java_");
        clientClass.put("testName", testName);
        clientClass.put("pImports", pImports);
        clientClass.put("contents", pContents);
        for (String key : varMap.keySet()) {
            String value = varMap.get(key);
            value = CodeGenerator.fixedURLJava(value);
            clientClass.put(key, value);
        }
        clientClass.writeFileTo(workDir + "/bsh", "Client" + scriptOrder + ".java");
        CodeGenerator.generateClient(testName, "Client");
    }

    public static void generateJUnitClient(TestSuite ts, Class<?> testClass, Map<String, String> injectedProperties) {
        if (!generateTestSources) {
            return;
        }
        File dir = new File(workDir + "/bsh");
        dir.mkdir();
        FreeMarkerTemplate clientClass = new FreeMarkerTemplate(id, scriptOrder, workDir, "bsh/ClientJUnit.java_");
        String testClassName = ts.getName();
        clientClass.put("className", testClassName);
        String constructorArg = CodeGenerator.hasNoArgConstructor(testClass) ? "" : "\"" + testClassName + "\"";
        clientClass.put("constructorArg", constructorArg);
        clientClass.put("injectedProperties", injectedProperties);
        ArrayList<String> tests = new ArrayList<String>();
        for (int i = 0; i < ts.testCount(); ++i) {
            Test t = ts.testAt(i);
            String method = t.toString();
            tests.add(method.substring(0, method.indexOf(40)));
        }
        clientClass.put("methods", tests);
        clientClass.writeFileTo(workDir + "/bsh", "ClientJUnit" + scriptOrder + ".java");
        CodeGenerator.generateClient(testClassName, "ClientJUnit");
    }

    private static boolean hasNoArgConstructor(Class<?> clazz) {
        try {
            Constructor<?> c = clazz.getConstructor(new Class[0]);
            return c != null && (c.getModifiers() & 1) != 0;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static String getContextPath(String address) {
        if (address.contains("http://localhost:")) {
            String fixed = address.replaceAll("http://localhost:(\\d)+/", "");
            return fixed;
        }
        return address;
    }

    public static void fixPort(String address) {
        if (address.contains("http://localhost:")) {
            String fixedBASH = address.replaceAll(":8080/", ":\\$((PORT + " + deployedServices + "))/");
            String fixedJAVA = address.replaceAll(":8080/", ":\" + (DEPLOY_PORT + " + deployedServices + ") + \"/");
            fixedServiceURLsBASH.put(address, fixedBASH);
            fixedServiceURLsJava.put(address, fixedJAVA);
        }
    }

    public static int getFreePort() {
        return 8080 + deployedServices;
    }

    public static void generateDeploySources(WAR war, TestEndpoint testEndpoint, List<Source> metadata, Map<String, Object> props, String endpointAddress, String wsdlLocation, boolean fromwsdl) {
        HashMap<String, Object> templateParams = new HashMap<String, Object>();
        if (wsdlLocation != null && wsdlLocation.length() > 0) {
            templateParams.put("wsdlLocation", wsdlLocation.replaceAll("WEB-INF/wsdl/", ""));
        }
        ArrayList<String> metadata_files = new ArrayList<String>();
        for (Source source : metadata) {
            metadata_files.add(source.getSystemId().replaceAll("file:", ""));
        }
        templateParams.put("metadata_files", metadata_files);
        templateParams.put("props", props);
        QName qname = (QName)props.get("javax.xml.ws.wsdl.port");
        if (qname != null) {
            templateParams.put("portURI", "" + qname.getNamespaceURI());
            templateParams.put("portLOCAL", "" + qname.getLocalPart());
        }
        if ((qname = (QName)props.get("javax.xml.ws.wsdl.service")) != null) {
            templateParams.put("svcURI", "" + qname.getNamespaceURI());
            templateParams.put("svcLOCAL", "" + qname.getLocalPart());
        }
        templateParams.put("endpointImpl", "" + testEndpoint.className.replaceAll("\\$", "."));
        CodeGenerator.fixPort(endpointAddress);
        templateParams.put("endpointContextPath", "" + CodeGenerator.getContextPath(endpointAddress));
        CodeGenerator.generateDeploy(templateParams, war.classDir.getAbsolutePath(), fromwsdl);
    }

    public static String fixedURLBASH(String value) {
        if (value.startsWith("http://")) {
            for (String partToBeFixed : fixedServiceURLsBASH.keySet()) {
                if (!value.contains(partToBeFixed)) continue;
                String fixed = fixedServiceURLsBASH.get(partToBeFixed);
                return value.replaceAll(partToBeFixed, Matcher.quoteReplacement(fixed));
            }
        }
        return value;
    }

    public static String fixedURLJava(String value) {
        if (value.startsWith("http://")) {
            for (String partToBeFixed : fixedServiceURLsJava.keySet()) {
                if (!value.contains(partToBeFixed)) continue;
                String fixed = fixedServiceURLsJava.get(partToBeFixed);
                return value.replaceAll(partToBeFixed, Matcher.quoteReplacement(fixed));
            }
        }
        return value;
    }

    public static String toRelativePath(String value) {
        if (!value.contains("http://")) {
            String fixed = CodeGenerator.chdir(value);
            fixed = fixed.replaceAll("//", "/");
            fixed = fixed.replaceAll(workDir + "/", "");
            fixed = fixed.replaceAll(workDir, "");
            String workDirParent = workDir.substring(0, workDir.lastIndexOf(47));
            fixed = fixed.replaceAll(workDirParent, "..");
            return fixed;
        }
        return value;
    }

    public static void testStarting(File workDir) {
        String path = workDir.getPath();
        int i = -1;
        if (path.endsWith("/work")) {
            i = path.lastIndexOf("/work");
        } else if (path.contains("/work/")) {
            i = path.lastIndexOf("/work/");
        }
        if (i != -1) {
            path = path.substring(0, i);
        }
        if (!path.equals(lastTestcaseDir)) {
            CodeGenerator.testCaseDone();
            CodeGenerator.startTestCase(path);
            lastTestcaseDir = path;
        }
    }

    static {
        scriptOrder = 0;
        testcaseScripts = new ArrayList<String>();
        testcases = new ArrayList<String>();
        shutdownPortList = new ArrayList<String>();
        deployedServices = 0;
        fixedServiceURLsBASH = new HashMap<String, String>();
        fixedServiceURLsJava = new HashMap<String, String>();
    }
}

