/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.tool;

import com.sun.xml.ws.test.tool.LocalWsTool;
import com.sun.xml.ws.test.tool.RemoteWsTool;
import java.io.File;
import java.util.List;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WsTool
extends Assert {
    private boolean dumpParameters;
    public static WsTool NOOP = new WsTool(false){

        public void invoke(String ... args) {
        }
    };

    protected WsTool(boolean dumpParameters) {
        this.dumpParameters = dumpParameters;
    }

    public abstract void invoke(String ... var1) throws Exception;

    public boolean isNoop() {
        return this == NOOP;
    }

    public static WsTool createWsImport(File externalWsImport, boolean dumpParameters, String extraWsToolsArgs) {
        return WsTool.createTool(externalWsImport, "com.sun.tools.ws.WsImport", dumpParameters, extraWsToolsArgs);
    }

    public static WsTool createWsGen(File externalWsGen, boolean dumpParameters, String extraWsToolsArgs) {
        return WsTool.createTool(externalWsGen, "com.sun.tools.ws.WsGen", dumpParameters, extraWsToolsArgs);
    }

    private static WsTool createTool(File externalExecutable, String className, boolean dumpParameters, String extraWsToolsArgs) {
        if (externalExecutable != null) {
            return new RemoteWsTool(externalExecutable, dumpParameters, extraWsToolsArgs);
        }
        return new LocalWsTool(className, dumpParameters);
    }

    protected void dumpWsParams(List<String> params) {
        System.err.println("\n\nINVOKING WS Tool:\n");
        for (int i = 0; i < params.size(); ++i) {
            System.err.print(i == 0 ? " " : "     ");
            System.err.print(params.get(i));
            System.err.println(i + 1 < params.size() ? " \\" : "\n");
        }
    }

    protected boolean dumpParams() {
        return this.dumpParameters;
    }
}

