/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.model;

import com.sun.xml.ws.test.model.TestEndpoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.jws.WebService;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.xml.ws.WebServiceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedAnnotationTypes(value={"javax.jws.WebService", "javax.xml.ws.WebServiceProvider"})
public class EndpointReader
extends AbstractProcessor {
    private Elements els;
    private final Set<TestEndpoint> endpoints = new LinkedHashSet<TestEndpoint>();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.els = processingEnv.getElementUtils();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ArrayList<Element> classes = new ArrayList<Element>();
        for (Element element : roundEnv.getRootElements()) {
            if (element.getKind().equals((Object)ElementKind.INTERFACE)) continue;
            classes.add(element);
        }
        Collections.sort(classes, new Comparator<Element>(){

            @Override
            public int compare(Element o1, Element o2) {
                return EndpointReader.this.getClassName(o1).compareTo(EndpointReader.this.getClassName(o2));
            }
        });
        for (Element element : classes) {
            String serviceName = null;
            String portName = null;
            String fullName = this.getClassName(element);
            WebService ws = element.getAnnotation(WebService.class);
            if (ws != null) {
                if (serviceName == null) {
                    String string = serviceName = ws.serviceName().isEmpty() ? element.getSimpleName().toString() + "Service" : ws.serviceName();
                }
                if (portName == null) {
                    portName = ws.portName().isEmpty() ? null : ws.portName();
                }
            } else {
                WebServiceProvider wsp = element.getAnnotation(WebServiceProvider.class);
                if (wsp == null) continue;
                if (serviceName == null) {
                    String string = serviceName = wsp.serviceName().isEmpty() ? element.getSimpleName().toString() + "Service" : wsp.serviceName();
                }
                if (portName == null) {
                    portName = wsp.portName().isEmpty() ? null : wsp.portName();
                }
            }
            this.endpoints.add(new TestEndpoint(serviceName, fullName, portName, element.getAnnotation(WebServiceProvider.class) != null));
        }
        return true;
    }

    Set<TestEndpoint> getTestEndpoints() {
        return this.endpoints;
    }

    private String getPackageName(Element e) {
        String pkg = this.els.getPackageOf(e).getQualifiedName().toString();
        return pkg.isEmpty() ? "" : pkg + ".";
    }

    private String getClassName(Element e) {
        return this.getPackageName(e) + e.getSimpleName().toString();
    }
}

