/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.exec;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.TargetError;
import com.sun.xml.ws.test.World;
import com.sun.xml.ws.test.client.InterpreterEx;
import com.sun.xml.ws.test.client.ScriptBaseClass;
import com.sun.xml.ws.test.client.XmlResource;
import com.sun.xml.ws.test.container.DeployedService;
import com.sun.xml.ws.test.container.DeploymentContext;
import com.sun.xml.ws.test.exec.Executor;
import com.sun.xml.ws.test.model.TestClient;
import com.sun.xml.ws.test.model.TestEndpoint;
import java.beans.Introspector;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;

public class ClientExecutor
extends Executor {
    private final TestClient client;

    public ClientExecutor(DeploymentContext context, TestClient client) {
        super("client " + client.script.getName().replace('.', '_'), context);
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest() throws Throwable {
        if (this.context.clientClassLoader == null) {
            this.context.clientClassLoader = this.context.getResources() != null ? new URLClassLoader(new URL[]{this.context.getResources().toURL()}, World.runtime.getClassLoader()) : World.runtime.getClassLoader();
        }
        InterpreterEx engine = new InterpreterEx(this.context.clientClassLoader);
        NameSpace ns = engine.getNameSpace();
        ns.importPackage("javax.activation");
        ns.importPackage("javax.xml.ws");
        ns.importPackage("javax.xml.ws.soap");
        ns.importPackage("javax.xml.ws.handler");
        ns.importPackage("javax.xml.ws.handler.soap");
        ns.importPackage("javax.xml.bind");
        ns.importPackage("javax.xml.soap");
        ns.importPackage("javax.xml.namespace");
        ns.importPackage("javax.xml.transform");
        ns.importPackage("javax.xml.transform.sax");
        ns.importPackage("javax.xml.transform.dom");
        ns.importPackage("javax.xml.transform.stream");
        ns.importPackage("java.util");
        ns.importPackage("java.util.concurrent");
        ns.importPackage(this.context.descriptor.name + ".client");
        ns.importPackage(this.context.descriptor.name + ".common");
        ns.importObject((Object)new ScriptBaseClass(this.context, engine, this.client));
        try {
            engine.eval(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("util.bsh")));
        }
        catch (EvalError evalError) {
            throw new Error("Failed to evaluate util.bsh", evalError);
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.context.clientClassLoader);
        try {
            this.injectResources(ns, engine);
            this.invoke(engine);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    protected void invoke(Interpreter engine) throws Throwable {
        Reader r = this.client.script.read();
        try {
            if (this.client.parent.setUpScript != null) {
                engine.eval((Reader)new StringReader(this.client.parent.setUpScript), engine.getNameSpace(), "pre-client script");
            }
            engine.eval(r, engine.getNameSpace(), this.client.script.getName());
        }
        catch (TargetError e) {
            throw e.getTarget();
        }
        finally {
            r.close();
        }
    }

    private void injectResources(NameSpace ns, Interpreter engine) throws Exception {
        StringBuilder serviceList = new StringBuilder("injected services:");
        StringBuilder portList = new StringBuilder("injected ports:");
        StringBuilder addressList = new StringBuilder("injected addresses:");
        engine.set("home", (Object)this.client.parent.home);
        for (Map.Entry<String, XmlResource> e : this.context.descriptor.xmlResources.entrySet()) {
            engine.set(e.getKey(), (Object)e.getValue());
        }
        for (DeployedService svc : this.context.services.values()) {
            if (svc.service.isSTS) continue;
            engine.set("wsdlUrls", svc.app.getWSDL());
            for (Class clazz : svc.serviceClass) {
                String packageName = clazz.getPackage().getName();
                ns.importPackage(packageName);
                Method[] methods = clazz.getMethods();
                Class<Annotation> webendpointAnnotation = clazz.getClassLoader().loadClass("javax.xml.ws.WebEndpoint").asSubclass(Annotation.class);
                Method nameMethod = webendpointAnnotation.getDeclaredMethod("name", new Class[0]);
                Object serviceInstance = clazz.newInstance();
                String serviceVarName = Introspector.decapitalize(clazz.getSimpleName());
                engine.set(serviceVarName, serviceInstance);
                serviceList.append(' ').append(serviceVarName);
                for (Method method : methods) {
                    Annotation endpoint = method.getAnnotation(webendpointAnnotation);
                    if (endpoint == null || method.getParameterTypes().length != 0) continue;
                    String portName = (String)nameMethod.invoke((Object)endpoint, new Object[0]);
                    String varName = Introspector.decapitalize(portName);
                    try {
                        engine.set(varName, method.invoke(serviceInstance, new Object[0]));
                        engine.set(varName + "Address", (Object)svc.app.getEndpointAddress(this.getEndpoint(svc, portName)));
                        addressList.append(' ').append(varName).append("Address");
                    }
                    catch (InvocationTargetException e) {
                        if (e.getCause() instanceof Exception) {
                            throw (Exception)e.getCause();
                        }
                        throw e;
                    }
                    portList.append(' ').append(varName);
                }
            }
        }
        System.out.println(serviceList);
        System.out.println(portList);
        System.out.println(addressList);
    }

    private TestEndpoint getEndpoint(DeployedService svc, String portName) {
        for (TestEndpoint e : svc.service.endpoints) {
            if (e.portName == null || !e.portName.equals(portName)) continue;
            return e;
        }
        if (svc.service.endpoints.size() != 1) {
            throw new Error("Multiple ports are defined on '" + svc.service.name + "', yet ports are ambiguous. Please use @WebService/Provider(portName=)");
        }
        return (TestEndpoint)svc.service.endpoints.toArray()[0];
    }
}

