/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.container.cargo.gf;

import com.sun.xml.ws.test.container.cargo.gf.GlassfishInstalledLocalContainer;
import com.sun.xml.ws.test.container.cargo.gf.GlassfishStandaloneLocalConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.deployer.DeployerType;
import org.codehaus.cargo.container.spi.deployer.AbstractLocalDeployer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassfishInstalledLocalDeployer
extends AbstractLocalDeployer {
    public GlassfishInstalledLocalDeployer(InstalledLocalContainer localContainer) {
        super((LocalContainer)localContainer);
    }

    private GlassfishInstalledLocalContainer getLocalContainer() {
        return (GlassfishInstalledLocalContainer)super.getContainer();
    }

    private GlassfishStandaloneLocalConfiguration getConfiguration() {
        return (GlassfishStandaloneLocalConfiguration)this.getLocalContainer().getConfiguration();
    }

    public DeployerType getType() {
        return DeployerType.INSTALLED;
    }

    public void deploy(Deployable deployable) {
        this.doDeploy(deployable, false);
    }

    public void redeploy(Deployable deployable) {
        this.doDeploy(deployable, true);
    }

    private void doDeploy(Deployable deployable, boolean overwrite) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("deploy");
        if (overwrite) {
            args.add("--force");
        }
        if (deployable instanceof WAR) {
            args.add("--contextroot");
            args.add(((WAR)deployable).getContext());
        }
        this.addConnectOptions(args);
        args.add(new File(deployable.getFile()).getAbsolutePath());
        this.getLocalContainer().invokeAsAdmin(false, args.toArray(new String[args.size()]));
    }

    public void undeploy(Deployable deployable) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("undeploy");
        this.addConnectOptions(args);
        args.add(this.cutExtension(new File(deployable.getFile()).getName()));
        this.getLocalContainer().invokeAsAdmin(false, args.toArray(new String[args.size()]));
    }

    public void start(Deployable deployable) {
        super.start(deployable);
    }

    public void stop(Deployable deployable) {
        super.stop(deployable);
    }

    private String cutExtension(String name) {
        int idx = name.lastIndexOf(46);
        if (idx >= 0) {
            return name.substring(0, idx);
        }
        return name;
    }

    private void addConnectOptions(List<String> args) {
        args.add("--interactive=false");
        args.add("--port");
        args.add(this.getConfiguration().getPropertyValue("cargo.glassfish.adminPort"));
        args.add("--user");
        args.add(this.getConfiguration().getPropertyValue("cargo.remote.username"));
        args.add("--passwordfile");
        args.add(this.getConfiguration().getPasswordFile().getAbsolutePath());
    }
}

