/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.logging.Logger;

public class Bootstrap {
    private static final Logger logger = Logger.getLogger(Bootstrap.class.getName());

    public static void main(String[] args) throws Exception {
        File home = Bootstrap.getHomeDirectory();
        logger.fine("test harness home is " + home);
        System.getProperties().put("HARNESS_HOME", home.getPath());
        ArrayList<URL> harness = new ArrayList<URL>();
        File extLib = new File(home, "lib");
        if (extLib.exists()) {
            for (File jar : extLib.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            })) {
                logger.info("Adding " + jar + " to the harness realm");
                harness.add(jar.toURL());
            }
        }
        File libJar = new File(home, "harness-lib.jar");
        harness.add(libJar.toURL());
        URLClassLoader cl = new URLClassLoader(harness.toArray(new URL[0]), ClassLoader.getSystemClassLoader());
        Class<?> main = cl.loadClass("com.sun.xml.ws.test.Main");
        Method mainMethod = main.getMethod("main", String[].class);
        Thread.currentThread().setContextClassLoader(cl);
        mainMethod.invoke(null, new Object[]{args});
    }

    private static File getHomeDirectory() throws IOException {
        String res = Bootstrap.class.getClassLoader().getResource("com/sun/xml/ws/test/Bootstrap.class").toExternalForm();
        if (res.startsWith("jar:")) {
            res = res.substring(4, res.lastIndexOf(33));
            return new File(new URL(res).getFile().replace("%20", " ")).getParentFile();
        }
        throw new IllegalStateException("I can't figure out where the harness is loaded from: " + res);
    }
}

