/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice.monitoring;

import com.sun.enterprise.webservice.SOAPMessageContext;
import com.sun.enterprise.webservice.monitoring.EndpointImpl;
import com.sun.enterprise.webservice.monitoring.EndpointType;
import com.sun.enterprise.webservice.monitoring.HttpRequestInfoImpl;
import com.sun.enterprise.webservice.monitoring.MessageListener;
import com.sun.enterprise.webservice.monitoring.MessageTrace;
import com.sun.enterprise.webservice.monitoring.MessageTraceImpl;
import com.sun.enterprise.webservice.monitoring.TransportInfo;
import com.sun.enterprise.webservice.monitoring.WebServiceEngineImpl;
import javax.servlet.http.HttpServletRequest;

public class JAXWSEndpointImpl
extends EndpointImpl {
    JAXWSEndpointImpl(String endpointSelector, EndpointType type) {
        super(endpointSelector, type);
    }

    public boolean processRequest(SOAPMessageContext messageContext) throws Exception {
        boolean status = true;
        WebServiceEngineImpl wsEngine = WebServiceEngineImpl.getInstance();
        try {
            if (!this.listeners.isEmpty() || wsEngine.hasGlobalMessageListener()) {
                String messageID = (String)messageContext.get("MONITORING_MESSAGE_ID");
                if (messageID != null) {
                    HttpServletRequest httpReq = (HttpServletRequest)messageContext.get("javax.xml.ws.servlet.request");
                    HttpRequestInfoImpl info = new HttpRequestInfoImpl(httpReq);
                    wsEngine.processRequest(messageID, messageContext, (TransportInfo)info);
                }
                if (!this.listeners.isEmpty()) {
                    MessageTraceImpl request = new MessageTraceImpl();
                    request.setEndpoint(this);
                    request.setMessageContext(messageContext);
                    HttpServletRequest httpReq = (HttpServletRequest)messageContext.get("javax.xml.ws.servlet.request");
                    request.setTransportInfo(new HttpRequestInfoImpl(httpReq));
                    messageContext.put("MONITORING_REQUEST_MESSAGE_TRACE", request);
                }
            }
        }
        catch (Exception e) {
            WebServiceEngineImpl.sLogger.warning("Exception while tracing request : " + e.getMessage());
            throw e;
        }
        return status;
    }

    public void processResponse(SOAPMessageContext messageContext) throws Exception {
        WebServiceEngineImpl wsEngine = WebServiceEngineImpl.getInstance();
        try {
            if (wsEngine.hasGlobalMessageListener() || !this.listeners.isEmpty()) {
                String messageID = (String)messageContext.get("MONITORING_MESSAGE_ID");
                if (messageID != null) {
                    wsEngine.processResponse(messageID, messageContext);
                }
                if (!this.listeners.isEmpty()) {
                    MessageTraceImpl response = new MessageTraceImpl();
                    response.setEndpoint(this);
                    response.setMessageContext(messageContext);
                    for (MessageListener listener : this.listeners) {
                        listener.invocationProcessed((MessageTrace)messageContext.get("MONITORING_REQUEST_MESSAGE_TRACE"), response);
                    }
                }
            }
        }
        catch (Exception e) {
            WebServiceEngineImpl.sLogger.warning("Exception while tracing response : " + e.getMessage());
            throw e;
        }
    }
}

