/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.ejb.containers.StatelessSessionContainer;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.webservice.Ejb2RuntimeEndpointInfo;
import com.sun.enterprise.webservice.EjbRuntimeEndpointInfo;
import com.sun.enterprise.webservice.monitoring.WebServiceEngineFactory;
import com.sun.enterprise.webservice.monitoring.WebServiceEngineImpl;
import com.sun.logging.LogDomains;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebServiceEjbEndpointRegistry {
    private static StringManager localStrings = StringManager.getManager(WebServiceEjbEndpointRegistry.class);
    Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.container.ejb");
    private static WebServiceEjbEndpointRegistry registry = null;
    private Hashtable webServiceEjbEndpoints = new Hashtable();
    private Set ejbContextRoots = new HashSet();

    private WebServiceEjbEndpointRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WebServiceEjbEndpointRegistry getRegistry() {
        if (registry != null) return registry;
        Class<WebServiceEjbEndpointRegistry> clazz = WebServiceEjbEndpointRegistry.class;
        synchronized (WebServiceEjbEndpointRegistry.class) {
            if (registry != null) return registry;
            registry = new WebServiceEjbEndpointRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return registry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEjbWebServiceEndpoint(EjbRuntimeEndpointInfo endpoint) throws Exception {
        Hashtable hashtable = this.webServiceEjbEndpoints;
        synchronized (hashtable) {
            String uri;
            String uriRaw = endpoint.getEndpointAddressUri();
            String string = uri = uriRaw.charAt(0) == '/' ? uriRaw.substring(1) : uriRaw;
            if (this.webServiceEjbEndpoints.containsKey(uri)) {
                this.logger.log(Level.SEVERE, localStrings.getString("enterprise.webservice.duplicateService", new Object[]{uri}));
            }
            this.webServiceEjbEndpoints.put(uri, endpoint);
            this.regenerateEjbContextRoots();
        }
        WebServiceEngineImpl engine = (WebServiceEngineImpl)WebServiceEngineFactory.getInstance().getEngine();
        if (endpoint.getEndpoint().getWebService().getMappingFileUri() != null) {
            engine.createHandler(null, endpoint.getEndpoint());
        } else {
            engine.createHandler(endpoint.getEndpoint());
            endpoint.initRuntimeInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEjbWebServiceEndpoint(String endpointAddressUri) {
        EjbRuntimeEndpointInfo endpoint = null;
        Hashtable hashtable = this.webServiceEjbEndpoints;
        synchronized (hashtable) {
            String uriRaw = endpointAddressUri;
            String uri = uriRaw.charAt(0) == '/' ? uriRaw.substring(1) : uriRaw;
            endpoint = (EjbRuntimeEndpointInfo)this.webServiceEjbEndpoints.remove(uri);
            this.regenerateEjbContextRoots();
        }
        if (endpoint == null) {
            return;
        }
        WebServiceEngineImpl engine = (WebServiceEngineImpl)WebServiceEngineFactory.getInstance().getEngine();
        engine.removeHandler(endpoint.getEndpoint());
    }

    public EjbRuntimeEndpointInfo createEjbEndpointInfo(WebServiceEndpoint webServiceEndpoint, StatelessSessionContainer ejbContainer, Object servant, Class tieClass) {
        EjbRuntimeEndpointInfo info = "1.1".compareTo(webServiceEndpoint.getWebService().getWebServicesDescriptor().getSpecVersion()) >= 0 ? new Ejb2RuntimeEndpointInfo(webServiceEndpoint, ejbContainer, servant, tieClass) : new EjbRuntimeEndpointInfo(webServiceEndpoint, ejbContainer, servant);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EjbRuntimeEndpointInfo getEjbWebServiceEndpoint(String uriRaw, String method, String query) {
        EjbRuntimeEndpointInfo endpoint = null;
        if (uriRaw == null || uriRaw.length() == 0) {
            return null;
        }
        String uri = uriRaw.charAt(0) == '/' ? uriRaw.substring(1) : uriRaw;
        Hashtable hashtable = this.webServiceEjbEndpoints;
        synchronized (hashtable) {
            if (method.equals("GET")) {
                String contextRoot = this.getContextRootForUri(uri);
                if (this.ejbContextRoots.contains(contextRoot)) {
                    Collection values = this.webServiceEjbEndpoints.values();
                    for (EjbRuntimeEndpointInfo next : values) {
                        if (!next.getEndpoint().matchesEjbPublishRequest(uri, query)) continue;
                        endpoint = next;
                        break;
                    }
                }
            } else {
                endpoint = (EjbRuntimeEndpointInfo)this.webServiceEjbEndpoints.get(uri);
            }
        }
        return endpoint;
    }

    public Collection getEjbWebServiceEndpoints() {
        return this.webServiceEjbEndpoints.entrySet();
    }

    private String getContextRootForUri(String uri) {
        StringTokenizer tokenizer = new StringTokenizer(uri, "/");
        if (tokenizer.hasMoreTokens()) {
            return tokenizer.nextToken();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void regenerateEjbContextRoots() {
        Hashtable hashtable = this.webServiceEjbEndpoints;
        synchronized (hashtable) {
            HashSet<String> contextRoots = new HashSet<String>();
            for (String uri : this.webServiceEjbEndpoints.keySet()) {
                String contextRoot = this.getContextRootForUri(uri);
                if (contextRoot == null || contextRoot.equals("")) continue;
                contextRoots.add(contextRoot);
            }
            this.ejbContextRoots = contextRoots;
        }
    }
}

