/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.webservice.JAXWSAdapterRegistry;
import com.sun.enterprise.webservice.JAXWSContainer;
import com.sun.enterprise.webservice.WsUtil;
import com.sun.enterprise.webservice.monitoring.Endpoint;
import com.sun.enterprise.webservice.monitoring.WebServiceEngineImpl;
import com.sun.enterprise.webservice.monitoring.WebServiceTesterServlet;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.server.Adapter;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import com.sun.xml.ws.transport.http.servlet.ServletAdapterList;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.catalina.Loader;

public class JAXWSServlet
extends HttpServlet {
    private static Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    private WebServiceEndpoint endpoint;
    private String urlPattern;
    private String contextRoot;
    private WebServiceEngineImpl wsEngine_;
    private ClassLoader classLoader;

    public void init(ServletConfig servletConfig) throws ServletException {
        try {
            super.init(servletConfig);
            this.wsEngine_ = WebServiceEngineImpl.getInstance();
            this.doInit(servletConfig);
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    public void destroy() {
        JAXWSAdapterRegistry.getInstance().removeAdapter(this.contextRoot);
        try {
            new WsUtil().doPreDestroy(this.endpoint, this.classLoader);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "@PreDestroy lifecycle call failed for service" + this.endpoint.getName(), t);
        }
        this.wsEngine_.removeHandler(this.endpoint);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        Endpoint endpt;
        if ("Tester".equalsIgnoreCase(request.getQueryString()) && !"http://www.w3.org/2004/08/wsdl/http".equals(this.endpoint.getProtocolBinding()) && (endpt = this.wsEngine_.getEndpoint(request.getServletPath())) != null && Boolean.parseBoolean(endpt.getDescriptor().getDebugging())) {
            WebServiceTesterServlet.invoke(request, response, endpt.getDescriptor());
            return;
        }
        try {
            ServletAdapter targetEndpoint = (ServletAdapter)this.getEndpointFor(request);
            if (targetEndpoint == null) {
                throw new ServletException("Service not found");
            }
            targetEndpoint.handle(this.getServletContext(), request, response);
        }
        catch (Throwable t) {
            ServletException se = new ServletException();
            se.initCause(t);
            throw se;
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if ("Tester".equalsIgnoreCase(request.getQueryString()) && !"http://www.w3.org/2004/08/wsdl/http".equals(this.endpoint.getProtocolBinding())) {
            Endpoint endpt = this.wsEngine_.getEndpoint(request.getServletPath());
            if (endpt != null && (endpt.getDescriptor().isSecure() || endpt.getDescriptor().getMessageSecurityBinding() != null)) {
                String message = endpt.getDescriptor().getWebService().getName() + "is a secured web service; Tester feature is not supported for secured services";
                new WsUtil().writeInvalidMethodType(response, message);
                return;
            }
            if (endpt != null && Boolean.parseBoolean(endpt.getDescriptor().getDebugging())) {
                Loader loader = (Loader)endpt.getDescriptor().getBundleDescriptor().getExtraAttribute("WEBLOADER");
                if (loader != null) {
                    endpt.getDescriptor().getBundleDescriptor().setClassLoader(loader.getClassLoader());
                    endpt.getDescriptor().getBundleDescriptor().removeExtraAttribute("WEBLOADER");
                }
                WebServiceTesterServlet.invoke(request, response, endpt.getDescriptor());
                return;
            }
        }
        if (!"WSDL".equalsIgnoreCase(request.getQueryString()) && "http://www.w3.org/2004/08/wsdl/http".equals(this.endpoint.getProtocolBinding())) {
            this.doPost(request, response);
            return;
        }
        try {
            ServletAdapter targetEndpoint = (ServletAdapter)this.getEndpointFor(request);
            if (targetEndpoint != null) {
                targetEndpoint.publishWSDL(this.getServletContext(), request, response);
            } else {
                String message = "Invalid wsdl request " + request.getRequestURL();
                new WsUtil().writeInvalidMethodType(response, message);
            }
        }
        catch (Throwable t) {
            ServletException se = new ServletException();
            se.initCause(t);
            throw se;
        }
    }

    private void doInit(ServletConfig servletConfig) throws ServletException {
        String servletName = "unknown";
        try {
            InvocationManager invManager = Switch.getSwitch().getInvocationManager();
            ComponentInvocation inv = invManager.getCurrentInvocation();
            Object containerContext = inv.getContainerContext();
            WebBundleDescriptor webBundle = (WebBundleDescriptor)Switch.getSwitch().getDescriptorFor(containerContext);
            this.classLoader = Thread.currentThread().getContextClassLoader();
            servletName = servletConfig.getServletName();
            this.contextRoot = webBundle.getContextRoot();
            WebComponentDescriptor webComponent = webBundle.getWebComponentByCanonicalName(servletName);
            if (webComponent != null) {
                WebServicesDescriptor webServices = webBundle.getWebServices();
                Collection<WebServiceEndpoint> endpoints = webServices.getEndpointsImplementedBy(webComponent);
                this.endpoint = endpoints.iterator().next();
                if (!"http://www.w3.org/2004/08/wsdl/http".equals(this.endpoint.getProtocolBinding())) {
                    this.wsEngine_.createHandler(this.endpoint);
                }
            } else {
                throw new ServletException(servletName + " not found");
            }
            this.registerEndpoint();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Servlet web service endpoint '" + servletName + "' failure", t);
            ServletException se = new ServletException();
            se.initCause(t);
            throw se;
        }
    }

    private void registerEndpoint() throws Exception {
        WsUtil wsu = new WsUtil();
        Class<?> serviceEndpointClass = Class.forName(this.endpoint.getServletImplClass(), true, this.classLoader);
        String givenBinding = this.endpoint.getProtocolBinding();
        SDDocumentSource primaryWsdl = null;
        Collection docs = null;
        if (this.endpoint.getWebService().hasWsdlFile()) {
            BaseManager mgr = DeploymentServiceUtils.getInstanceManager((DeployableObjectType)DeployableObjectType.WEB);
            String deployedDir = mgr.getLocation(this.endpoint.getBundleDescriptor().getName());
            File pkgedWsdl = null;
            pkgedWsdl = deployedDir != null ? new File(deployedDir + File.separator + this.endpoint.getWebService().getWsdlFileUri()) : new File(this.endpoint.getWebService().getWsdlFileUrl().getFile());
            if (pkgedWsdl.exists()) {
                primaryWsdl = SDDocumentSource.create((URL)pkgedWsdl.toURL());
                docs = wsu.getWsdlsAndSchemas(pkgedWsdl);
            }
        }
        JAXWSContainer container = new JAXWSContainer(this.getServletContext(), this.endpoint);
        URL catalogURL = null;
        File catalogFile = new File(this.endpoint.getBundleDescriptor().getDeploymentDescriptorDir() + File.separator + "jax-ws-catalog.xml");
        if (catalogFile.exists()) {
            catalogURL = catalogFile.toURL();
        }
        WSBinding binding = BindingID.parse((String)givenBinding).createBinding();
        wsu.configureJAXWSServiceHandlers(this.endpoint, givenBinding, binding);
        wsu.setMtom(binding, this.endpoint);
        WSEndpoint wsep = WSEndpoint.create(serviceEndpointClass, (boolean)false, null, (QName)this.endpoint.getServiceName(), (QName)this.endpoint.getWsdlPort(), (Container)container, (WSBinding)binding, (SDDocumentSource)primaryWsdl, (Collection)docs, (URL)catalogURL);
        String uri = this.endpoint.getEndpointAddressUri();
        this.urlPattern = uri.startsWith("/") ? uri : "/" + uri;
        ServletAdapterList adapterList = new ServletAdapterList();
        ServletAdapter adapter = (ServletAdapter)adapterList.createAdapter(this.endpoint.getName(), this.urlPattern, wsep);
        this.registerEndpointUrlPattern((Adapter)adapter);
    }

    private void registerEndpointUrlPattern(Adapter info) {
        JAXWSAdapterRegistry.getInstance().addAdapter(this.contextRoot, this.urlPattern, info);
    }

    private Adapter getEndpointFor(HttpServletRequest request) {
        String path = request.getRequestURI().substring(request.getContextPath().length());
        return JAXWSAdapterRegistry.getInstance().getAdapter(this.contextRoot, this.urlPattern, path);
    }
}

