/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.ejb.Container;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.security.audit.AuditManagerFactory;
import com.sun.enterprise.webservice.Ejb2RuntimeEndpointInfo;
import com.sun.enterprise.webservice.EjbMessageDispatcher;
import com.sun.enterprise.webservice.EjbRuntimeEndpointInfo;
import com.sun.enterprise.webservice.WebServiceContextImpl;
import com.sun.enterprise.webservice.WebServiceEjbEndpointRegistry;
import com.sun.enterprise.webservice.WsUtil;
import com.sun.enterprise.webservice.monitoring.AuthenticationListener;
import com.sun.enterprise.webservice.monitoring.Endpoint;
import com.sun.enterprise.webservice.monitoring.WebServiceEngineImpl;
import com.sun.enterprise.webservice.monitoring.WebServiceTesterServlet;
import com.sun.logging.LogDomains;
import com.sun.web.security.RealmAdapter;
import com.sun.web.security.WebPrincipal;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.util.Base64;

public class EjbWebServiceServlet
extends HttpServlet {
    private static Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.container.ejb");
    private static final Base64 base64Helper = new Base64();
    private static final String AUTHORIZATION_HEADER = "authorization";
    private static AuditManager auditManager = AuditManagerFactory.getAuditManagerInstance();

    protected void service(HttpServletRequest hreq, HttpServletResponse hresp) throws ServletException, IOException {
        EjbRuntimeEndpointInfo ejbEndpoint;
        boolean dispatch = true;
        String requestUriRaw = hreq.getRequestURI();
        String requestUri = requestUriRaw.charAt(0) == '/' ? requestUriRaw.substring(1) : requestUriRaw;
        String query = hreq.getQueryString();
        if ("Tester".equalsIgnoreCase(query)) {
            Endpoint endpoint = WebServiceEngineImpl.getInstance().getEndpoint(hreq.getRequestURI());
            if (endpoint.getDescriptor().isSecure() || endpoint.getDescriptor().getMessageSecurityBinding() != null) {
                String message = endpoint.getDescriptor().getWebService().getName() + "is a secured web service; Tester feature is not supported for secured services";
                new WsUtil().writeInvalidMethodType(hresp, message);
                return;
            }
            if (endpoint != null && Boolean.parseBoolean(endpoint.getDescriptor().getDebugging())) {
                dispatch = false;
                WebServiceTesterServlet.invoke(hreq, hresp, endpoint.getDescriptor());
            }
        }
        if (dispatch && (ejbEndpoint = WebServiceEjbEndpointRegistry.getRegistry().getEjbWebServiceEndpoint(requestUri, hreq.getMethod(), query)) != null) {
            this.dispatchToEjbEndpoint(hreq, hresp, ejbEndpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchToEjbEndpoint(HttpServletRequest hreq, HttpServletResponse hresp, EjbRuntimeEndpointInfo ejbEndpoint) {
        String expectedScheme;
        String scheme = hreq.getScheme();
        String string = expectedScheme = ejbEndpoint.getEndpoint().isSecure() ? "https" : "http";
        if (!expectedScheme.equalsIgnoreCase(scheme)) {
            logger.log(Level.WARNING, "Invalid request scheme for Endpoint " + ejbEndpoint.getEndpoint().getEndpointName() + ". " + "Expected " + expectedScheme + " . Received " + scheme);
            return;
        }
        Switch theSwitch = Switch.getSwitch();
        Container container = ejbEndpoint.getContainer();
        boolean authenticated = false;
        try {
            container.externalPreInvoke();
            String realmName = null;
            Application app = ejbEndpoint.getEndpoint().getBundleDescriptor().getApplication();
            if (app != null) {
                realmName = app.getRealm();
            }
            if (realmName == null) {
                realmName = ejbEndpoint.getEndpoint().getRealm();
            }
            if (realmName == null) {
                realmName = hreq.getServerName() + ":" + hreq.getServerPort();
            }
            try {
                authenticated = this.doSecurity(hreq, ejbEndpoint, realmName);
            }
            catch (Exception e) {
                this.sendAuthenticationEvents(false, hreq.getRequestURI(), null);
                logger.log(Level.WARNING, "authentication failed for " + ejbEndpoint.getEndpoint().getEndpointName(), e);
            }
            if (auditManager.isAuditOn()) {
                auditManager.ejbAsWebServiceInvocation(ejbEndpoint.getEndpoint().getEndpointName(), authenticated);
            }
            if (!authenticated) {
                hresp.setHeader("WWW-Authenticate", "Basic realm=\"" + realmName + "\"");
                hresp.sendError(401);
                return;
            }
            EjbMessageDispatcher msgDispatcher = ejbEndpoint.getMessageDispatcher();
            msgDispatcher.invoke(hreq, hresp, this.getServletContext(), ejbEndpoint);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "", t);
        }
        finally {
            if (authenticated) {
                SecurityContext.setCurrent(null);
            }
            container.externalPostInvoke();
        }
    }

    private boolean doSecurity(HttpServletRequest hreq, EjbRuntimeEndpointInfo epInfo, String realmName) throws Exception {
        WebServiceEndpoint endpoint = epInfo.getEndpoint();
        boolean authenticated = false;
        String method = hreq.getMethod();
        if (method.equals("GET") || !endpoint.hasAuthMethod()) {
            return true;
        }
        WebPrincipal webPrincipal = null;
        String endpointName = endpoint.getEndpointName();
        if (endpoint.hasBasicAuth()) {
            String rawAuthInfo = hreq.getHeader(AUTHORIZATION_HEADER);
            if (rawAuthInfo == null) {
                this.sendAuthenticationEvents(false, hreq.getRequestURI(), null);
                return false;
            }
            String[] usernamePassword = this.parseUsernameAndPassword(rawAuthInfo);
            if (usernamePassword != null) {
                webPrincipal = new WebPrincipal(usernamePassword[0], usernamePassword[1], SecurityContext.init());
            } else {
                logger.log(Level.WARNING, "BASIC AUTH username/password http header parsing error for " + endpointName);
            }
        } else {
            X509Certificate[] certs = (X509Certificate[])hreq.getAttribute("javax.servlet.request.X509Certificate");
            if (certs == null || certs.length < 1) {
                certs = (X509Certificate[])hreq.getAttribute("org.apache.coyote.request.X509Certificate");
            }
            if (certs != null) {
                webPrincipal = new WebPrincipal(certs, SecurityContext.init());
            } else {
                logger.log(Level.WARNING, "CLIENT CERT authentication error for " + endpointName);
            }
        }
        if (webPrincipal == null) {
            this.sendAuthenticationEvents(false, hreq.getRequestURI(), null);
            return authenticated;
        }
        RealmAdapter ra = new RealmAdapter(realmName);
        authenticated = ra.authenticate(webPrincipal);
        if (!authenticated) {
            this.sendAuthenticationEvents(false, hreq.getRequestURI(), webPrincipal);
            logger.fine("authentication failed for " + endpointName);
        }
        this.sendAuthenticationEvents(true, hreq.getRequestURI(), webPrincipal);
        if (epInfo instanceof Ejb2RuntimeEndpointInfo) {
            return authenticated;
        }
        epInfo.prepareInvocation(false);
        WebServiceContextImpl ctxt = (WebServiceContextImpl)epInfo.getWebServiceContext();
        ctxt.setUserPrincipal(webPrincipal);
        return authenticated;
    }

    private String[] parseUsernameAndPassword(String rawAuthInfo) {
        String[] usernamePassword = null;
        if (rawAuthInfo != null && rawAuthInfo.startsWith("Basic ")) {
            String authString = rawAuthInfo.substring(6).trim();
            String unencoded = new String(Base64.decode((byte[])authString.getBytes()));
            int colon = unencoded.indexOf(58);
            if (colon > 0) {
                usernamePassword = new String[]{unencoded.substring(0, colon).trim(), unencoded.substring(colon + 1).trim()};
            }
        }
        return usernamePassword;
    }

    private void sendAuthenticationEvents(boolean success, String url, WebPrincipal principal) {
        Endpoint endpoint = WebServiceEngineImpl.getInstance().getEndpoint(url);
        if (endpoint == null) {
            return;
        }
        for (AuthenticationListener listener : WebServiceEngineImpl.getInstance().getAuthListeners()) {
            if (success) {
                listener.authSucess(endpoint.getDescriptor().getBundleDescriptor(), endpoint, (Principal)principal);
                continue;
            }
            listener.authFailure(endpoint.getDescriptor().getBundleDescriptor(), endpoint, (Principal)principal);
        }
    }
}

