/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.ejb.Container;
import com.sun.ejb.Invocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.webservice.ServletWSSecurityPipe;
import com.sun.enterprise.webservice.WsUtil;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import java.lang.reflect.Method;
import java.rmi.UnmarshalException;
import java.util.HashMap;
import java.util.logging.Level;

public class EjbWSSecurityPipe
extends ServletWSSecurityPipe {
    EjbWSSecurityPipe(HashMap pBag, Pipe tail, WebServiceEndpoint ep) {
        super(pBag, tail, ep);
    }

    protected EjbWSSecurityPipe(EjbWSSecurityPipe that, PipeCloner cloner) {
        super(that, cloner);
    }

    public Pipe copy(PipeCloner cloner) {
        return new EjbWSSecurityPipe(this, cloner);
    }

    protected void preInvokeEndpointHook(Packet packet) throws Exception {
        Method m = this.getMethod(packet);
        if (m != null && this.endpoint.hasHandlerChain()) {
            Switch theSwitch = Switch.getSwitch();
            InvocationManager invManager = theSwitch.getInvocationManager();
            Invocation inv = (Invocation)invManager.getCurrentInvocation();
            Container container = (Container)inv.container;
            UnmarshalException exception = null;
            try {
                Method webServiceMethodInPreHandler = inv.getWebServiceMethod();
                if (webServiceMethodInPreHandler != null && !webServiceMethodInPreHandler.equals(m)) {
                    exception = new UnmarshalException(localStrings.getLocalString("enterprise.webservice.postHandlerMethodMismatch", "Original Method {0} does not match post-handler method {1}", new Object[]{webServiceMethodInPreHandler, m}));
                }
            }
            catch (Exception e) {
                String errorMsg = localStrings.getLocalString("enterprise.webservice.cantGetMethod", "Exception while getting method for {0}", new Object[]{inv != null ? ((Container)inv.container).getEjbDescriptor().getName() : ""});
                exception = new UnmarshalException(errorMsg);
                inv.exception.initCause(e);
            }
            if (exception != null) {
                inv.exception = exception;
                WsUtil.getDefaultLogger().log(Level.WARNING, "postEjbHandlerError", inv.exception);
                throw exception;
            }
        }
    }

    protected Packet processValidatedRequest(Packet validatedPacket, Pipe next) throws Exception {
        Packet resultPacket = null;
        Switch theSwitch = Switch.getSwitch();
        InvocationManager invManager = theSwitch.getInvocationManager();
        Invocation inv = (Invocation)invManager.getCurrentInvocation();
        Exception ie = null;
        Method m = this.getMethod(validatedPacket);
        if (m != null) {
            Container container = (Container)inv.container;
            try {
                inv.method = m;
                if (!container.authorize(inv)) {
                    ie = new Exception(localStrings.getLocalString("enterprise.webservice.methodNotAuth", "Client not authorized for invocation of {0}", new Object[]{inv.method}));
                } else {
                    inv.setWebServiceMethod(inv.method);
                }
            }
            catch (Exception e) {
                String errorMsg = localStrings.getLocalString("enterprise.webservice.errorUnMarshalMethod", "Error unmarshalling method for ejb {0}", new Object[]{this.endpoint != null ? this.endpoint.getEjbComponentImpl().getName() : "unable to determine EjbComponentImp.name"});
                ie = new UnmarshalException(errorMsg);
                ie.initCause(e);
            }
            if (ie != null) {
                inv.exception = ie;
                throw ie;
            }
        } else {
            inv.setWebServiceMethod(null);
        }
        resultPacket = next.process(validatedPacket);
        return resultPacket;
    }
}

