/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.ejb.Container;
import com.sun.ejb.Invocation;
import com.sun.ejb.containers.StatelessSessionContainer;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.security.jauth.AuthException;
import com.sun.enterprise.security.jauth.ServerAuthConfig;
import com.sun.enterprise.webservice.Ejb3MessageDispatcher;
import com.sun.enterprise.webservice.EjbInvokerImpl;
import com.sun.enterprise.webservice.EjbMessageDispatcher;
import com.sun.enterprise.webservice.JAXWSContainer;
import com.sun.enterprise.webservice.WebServiceContextImpl;
import com.sun.enterprise.webservice.WsUtil;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.server.InstanceResolver;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import com.sun.xml.ws.transport.http.servlet.ServletAdapterList;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceContext;

public class EjbRuntimeEndpointInfo {
    protected static Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.container.ejb");
    protected WebServiceEndpoint endpoint;
    protected StatelessSessionContainer container;
    protected Object webServiceEndpointServant;
    protected ServerAuthConfig serverAuthConfig;
    protected InvocationManager invManager;
    private ServletAdapter adapter = null;
    private WebServiceContextImpl wsCtxt = null;
    private boolean handlersConfigured = false;
    protected EjbMessageDispatcher messageDispatcher = null;

    public EjbRuntimeEndpointInfo(WebServiceEndpoint webServiceEndpoint, StatelessSessionContainer ejbContainer, Object servant) {
        this.endpoint = webServiceEndpoint;
        this.container = ejbContainer;
        this.webServiceEndpointServant = servant;
        Switch theSwitch = Switch.getSwitch();
        this.invManager = theSwitch.getInvocationManager();
        try {
            this.serverAuthConfig = ServerAuthConfig.getConfig((String)"SOAP", (MessageSecurityBindingDescriptor)this.endpoint.getMessageSecurityBinding(), null);
        }
        catch (AuthException ae) {
            logger.log(Level.SEVERE, "EJB Webservice security configuration Failure", ae);
        }
    }

    public Container getContainer() {
        return this.container;
    }

    public WebServiceEndpoint getEndpoint() {
        return this.endpoint;
    }

    public ServerAuthConfig getServerAuthConfig() {
        return this.serverAuthConfig;
    }

    public String getEndpointAddressUri() {
        return this.endpoint.getEndpointAddressUri();
    }

    public WebServiceContext getWebServiceContext() {
        return this.wsCtxt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object prepareInvocation(boolean doPreInvoke) throws Exception {
        EjbRuntimeEndpointInfo ejbRuntimeEndpointInfo;
        if (this.adapter == null) {
            ejbRuntimeEndpointInfo = this;
            synchronized (ejbRuntimeEndpointInfo) {
                if (this.adapter == null) {
                    try {
                        Invocation tmpInv = new Invocation();
                        tmpInv.isWebService = true;
                        tmpInv.container = this.container;
                        tmpInv.transactionAttribute = 0;
                        this.invManager.preInvoke((ComponentInvocation)tmpInv);
                        EjbDescriptor ejbDesc = this.endpoint.getEjbComponentImpl();
                        for (ResourceReferenceDescriptor r : ejbDesc.getResourceReferenceDescriptors()) {
                            if (!r.isWebServiceContext()) continue;
                            Iterator iter = r.getInjectionTargets().iterator();
                            boolean matchingClassFound = false;
                            while (iter.hasNext()) {
                                InjectionTarget target = (InjectionTarget)iter.next();
                                if (!ejbDesc.getEjbClassName().equals(target.getClassName())) continue;
                                matchingClassFound = true;
                                break;
                            }
                            if (!matchingClassFound) continue;
                            try {
                                InitialContext ic = new InitialContext();
                                this.wsCtxt = (WebServiceContextImpl)ic.lookup("java:comp/env/" + r.getName());
                            }
                            catch (Throwable t) {}
                        }
                        if (this.wsCtxt == null) {
                            this.wsCtxt = new WebServiceContextImpl();
                        }
                    }
                    catch (Throwable t) {
                        try {
                            logger.severe("Cannot initialize endpoint " + this.endpoint.getName() + " : error is : " + t.getMessage());
                            Object ejbDesc = null;
                            return ejbDesc;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            this.invManager.postInvoke(this.invManager.getCurrentInvocation());
                        }
                    }
                    this.invManager.postInvoke(this.invManager.getCurrentInvocation());
                }
            }
        }
        if (doPreInvoke) {
            Invocation inv = new Invocation();
            inv.isWebService = true;
            inv.container = this.container;
            inv.transactionAttribute = 0;
            inv.securityPermissions = 0;
            inv.setContextData((WebServiceContext)this.wsCtxt);
            this.invManager.preInvoke((ComponentInvocation)inv);
        }
        if (this.handlersConfigured) return this.adapter;
        if (!doPreInvoke) return this.adapter;
        ejbRuntimeEndpointInfo = this;
        synchronized (ejbRuntimeEndpointInfo) {
            if (this.handlersConfigured) return this.adapter;
            try {
                String urlPattern;
                WsUtil wsu = new WsUtil();
                String implClassName = this.endpoint.getEjbComponentImpl().getEjbClassName();
                Class<?> clazz = this.container.getClassLoader().loadClass(implClassName);
                String givenBinding = this.endpoint.getProtocolBinding();
                SDDocumentSource primaryWsdl = null;
                Collection docs = null;
                if (this.endpoint.getWebService().hasWsdlFile()) {
                    BaseManager mgr = DeploymentServiceUtils.getInstanceManager((DeployableObjectType)DeployableObjectType.WEB);
                    String deployedDir = mgr.getLocation(this.endpoint.getBundleDescriptor().getName());
                    File pkgedWsdl = null;
                    pkgedWsdl = deployedDir != null ? new File(deployedDir + File.separator + this.endpoint.getWebService().getWsdlFileUri()) : new File(this.endpoint.getWebService().getWsdlFileUrl().getFile());
                    if (pkgedWsdl.exists()) {
                        primaryWsdl = SDDocumentSource.create((URL)pkgedWsdl.toURL());
                        docs = wsu.getWsdlsAndSchemas(pkgedWsdl);
                    }
                }
                JAXWSContainer container = new JAXWSContainer(null, this.endpoint);
                URL catalogURL = null;
                File catalogFile = new File(this.endpoint.getBundleDescriptor().getDeploymentDescriptorDir() + File.separator + "jax-ws-catalog.xml");
                if (catalogFile.exists()) {
                    catalogURL = catalogFile.toURL();
                }
                WSBinding binding = BindingID.parse((String)givenBinding).createBinding();
                wsu.configureJAXWSServiceHandlers(this.endpoint, this.endpoint.getProtocolBinding(), binding);
                wsu.setMtom(binding, this.endpoint);
                Invoker inv = InstanceResolver.createDefault(clazz).createInvoker();
                WSEndpoint wsep = WSEndpoint.create(clazz, (boolean)false, (Invoker)new EjbInvokerImpl(clazz, inv, this.webServiceEndpointServant, this.wsCtxt), (QName)this.endpoint.getServiceName(), (QName)this.endpoint.getWsdlPort(), (com.sun.xml.ws.api.server.Container)container, (WSBinding)binding, (SDDocumentSource)primaryWsdl, (Collection)docs, (URL)catalogURL);
                String uri = this.endpoint.getEndpointAddressUri();
                String string = urlPattern = uri.startsWith("/") ? uri : "/" + uri;
                if (urlPattern.indexOf("/", 1) != -1) {
                    urlPattern = urlPattern.substring(urlPattern.indexOf("/", 1));
                }
                ServletAdapterList adapterList = new ServletAdapterList();
                this.adapter = (ServletAdapter)adapterList.createAdapter(this.endpoint.getName(), urlPattern, wsep);
                this.handlersConfigured = true;
            }
            catch (Throwable t) {
                logger.severe("Cannot initialize endpoint " + this.endpoint.getName() + " : error is : " + t.getMessage());
                this.adapter = null;
            }
            return this.adapter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initRuntimeInfo() throws Exception {
        try {
            this.prepareInvocation(true);
        }
        finally {
            this.invManager.postInvoke(this.invManager.getCurrentInvocation());
        }
    }

    public void releaseImplementor() {
        try {
            Invocation inv = (Invocation)this.invManager.getCurrentInvocation();
            if (inv != null) {
                if (inv.ejb != null) {
                    this.container.postInvoke(inv);
                } else {
                    this.invManager.postInvoke((ComponentInvocation)inv);
                }
            }
        }
        catch (Throwable t) {
            logger.log(Level.FINE, "", t);
        }
    }

    public EjbMessageDispatcher getMessageDispatcher() {
        if (this.messageDispatcher == null) {
            this.messageDispatcher = new Ejb3MessageDispatcher();
        }
        return this.messageDispatcher;
    }
}

