/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.webservice.EjbMessageDispatcher;
import com.sun.enterprise.webservice.EjbRuntimeEndpointInfo;
import com.sun.enterprise.webservice.WsUtil;
import com.sun.enterprise.webservice.monitoring.WebServiceEngineImpl;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Ejb3MessageDispatcher
implements EjbMessageDispatcher {
    private static Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.container.ejb");
    private static WsUtil wsUtil = new WsUtil();
    private WebServiceEngineImpl wsEngine = WebServiceEngineImpl.getInstance();

    public void invoke(HttpServletRequest req, HttpServletResponse resp, ServletContext ctxt, EjbRuntimeEndpointInfo endpointInfo) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "JAXWS WebServiceDispatcher " + req.getMethod() + " entering for " + req.getRequestURI() + " and query string " + req.getQueryString());
        }
        String method = req.getMethod();
        try {
            if (method.equals("POST")) {
                this.handlePost(req, resp, endpointInfo);
            } else if (method.equals("GET")) {
                this.handleGet(req, resp, ctxt, endpointInfo);
            } else {
                String errorMessage = "Unsupported method request = [" + method + "] for endpoint " + endpointInfo.getEndpoint().getEndpointName() + " at " + endpointInfo.getEndpointAddressUri();
                logger.warning(errorMessage);
                wsUtil.writeInvalidMethodType(resp, errorMessage);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "ejb endpoint exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePost(HttpServletRequest req, HttpServletResponse resp, EjbRuntimeEndpointInfo endpointInfo) throws IOException {
        try {
            try {
                ServletAdapter adapter = (ServletAdapter)endpointInfo.prepareInvocation(true);
                if (adapter != null) {
                    adapter.handle(null, req, resp);
                } else {
                    logger.log(Level.SEVERE, "Unable to find adpater for endpoint " + endpointInfo.getEndpoint().getName());
                }
            }
            finally {
                endpointInfo.releaseImplementor();
            }
        }
        catch (Throwable e) {
            String errorMessage = "invocation error on ejb endpoint " + endpointInfo.getEndpoint().getEndpointName() + " at " + endpointInfo.getEndpointAddressUri() + " : " + e.getMessage();
            logger.log(Level.WARNING, errorMessage, e);
            String binding = endpointInfo.getEndpoint().getProtocolBinding();
            WsUtil.raiseException(resp, binding, errorMessage);
        }
    }

    private void handleGet(HttpServletRequest req, HttpServletResponse resp, ServletContext ctxt, EjbRuntimeEndpointInfo endpointInfo) throws IOException {
        try {
            ServletAdapter adapter = (ServletAdapter)endpointInfo.prepareInvocation(false);
            if (adapter != null) {
                adapter.publishWSDL(ctxt, req, resp);
            } else {
                String message = "Invalid wsdl request " + req.getRequestURL();
                new WsUtil().writeInvalidMethodType(resp, message);
            }
        }
        catch (Throwable e) {
            String errorMessage = "invocation error on ejb endpoint " + endpointInfo.getEndpoint().getEndpointName() + " at " + endpointInfo.getEndpointAddressUri() + " : " + e.getMessage();
            logger.log(Level.WARNING, errorMessage, e);
            String binding = endpointInfo.getEndpoint().getProtocolBinding();
            WsUtil.raiseException(resp, binding, errorMessage);
        }
    }
}

