/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.codegen;

import com.sun.appserv.ClassLoaderUtil;
import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.JaxrpcMappingDescriptor;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.io.JaxrpcMappingDeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.AppClientVisitor;
import com.sun.enterprise.deployment.util.ApplicationVisitor;
import com.sun.enterprise.deployment.util.ComponentVisitor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.EjbBundleVisitor;
import com.sun.enterprise.deployment.util.ModuleContentLinker;
import com.sun.enterprise.loader.ASURLClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.spi.JaxRpcObjectFactory;
import com.sun.xml.rpc.spi.tools.CompileToolDelegate;
import com.sun.xml.rpc.spi.tools.GeneratedFileInfo;
import com.sun.xml.rpc.spi.tools.J2EEModelInfo;
import com.sun.xml.rpc.spi.tools.ModelFileModelInfo;
import com.sun.xml.rpc.spi.tools.ModelInfo;
import com.sun.xml.rpc.spi.tools.NamespaceMappingInfo;
import com.sun.xml.rpc.spi.tools.NamespaceMappingRegistryInfo;
import com.sun.xml.rpc.spi.tools.NoMetadataModelInfo;
import com.sun.xml.rpc.tools.wscompile.CompileTool;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.Service;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.deployment.common.ClientArtifactsManager;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.InstalledLibrariesResolver;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.glassfish.web.deployment.util.WebBundleVisitor;
import org.glassfish.web.deployment.util.WebServerInfo;
import org.glassfish.webservices.WsCompile;
import org.glassfish.webservices.WsUtil;
import org.glassfish.webservices.codegen.JaxRpcCodegenAdapter;

public class JaxRpcRICodegen
extends ModuleContentLinker
implements JaxRpcCodegenAdapter,
ApplicationVisitor,
EjbBundleVisitor,
WebBundleVisitor,
AppClientVisitor {
    protected DeploymentContext context = null;
    protected ServiceLocator habitat = null;
    protected String moduleClassPath = null;
    ArrayList<String> files = new ArrayList();
    private JaxRpcObjectFactory rpcFactory = JaxRpcObjectFactory.newInstance();
    private static final Logger logger = WsUtil.getDefaultLogger();
    private int wscompileInvocationCount = 0;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JaxRpcRICodegen.class);
    private com.sun.xml.rpc.spi.tools.CompileTool wscompileForAccept = null;
    private com.sun.xml.rpc.spi.tools.CompileTool wscompileForWebServices = null;
    private boolean processServiceReferences = false;
    private boolean hasWebServiceClients = false;
    File dummyConfigFile = null;

    public JaxRpcRICodegen(boolean processServiceReferences) {
        this.processServiceReferences = processServiceReferences;
    }

    @Override
    public void run(ServiceLocator habitat, DeploymentContext context, String cp) throws Exception {
        this.rootLocation_ = new FileArchive();
        BundleDescriptor bundle = DOLUtils.getCurrentBundleForContext((DeploymentContext)context);
        if (bundle.hasWebServiceClients() && bundle instanceof ApplicationClientDescriptor) {
            this.hasWebServiceClients = true;
        }
        if (bundle.isStandalone()) {
            this.rootLocation_.open(context.getSourceDir().toURI());
        } else {
            this.rootLocation_.open(context.getSource().getParentArchive().getURI());
        }
        this.context = context;
        this.habitat = habitat;
        this.moduleClassPath = cp;
        Application application = (Application)context.getModuleMetaData(Application.class);
        application.visit((ComponentVisitor)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void accept(ServiceReferenceDescriptor serviceRef) {
        if (!this.processServiceReferences) {
            return;
        }
        boolean codegenRequired = false;
        URL wsdlOverride = null;
        boolean wsdlOverriden = false;
        boolean jaxwsClient = false;
        super.accept(serviceRef);
        try {
            Class<?> serviceInterface;
            ClassLoader clr = serviceRef.getBundleDescriptor().getClassLoader();
            if (serviceRef.getServiceInterface() != null && Service.class.isAssignableFrom(serviceInterface = clr.loadClass(serviceRef.getServiceInterface()))) {
                jaxwsClient = true;
            }
            for (ServiceRefPortInfo portInfo : serviceRef.getPortsInfo()) {
                if (!portInfo.isLinkedToPortComponent()) continue;
                WebServiceEndpoint linkedPortComponent = portInfo.getPortComponentLink();
                if (linkedPortComponent == null) {
                    throw new Exception(localStrings.getLocalString("enterprise.webservice.componentlinkunresolved", "The port-component-link {0} cannot be resolved", new Object[]{portInfo.getPortComponentLinkName()}));
                }
                WsUtil wsUtil = new WsUtil();
                WebServerInfo wsi = wsUtil.getWebServerInfoForDAS();
                URL rootURL = wsi.getWebServerRootURL(linkedPortComponent.isSecure());
                URL actualAddress = linkedPortComponent.composeEndpointAddress(rootURL);
                if (jaxwsClient) {
                    portInfo.addStubProperty("javax.xml.ws.service.endpoint.address", actualAddress.toExternalForm());
                } else {
                    portInfo.addStubProperty("javax.xml.rpc.service.endpoint.address", actualAddress.toExternalForm());
                }
                if (!serviceRef.getBundleDescriptor().getModuleType().equals((Object)DOLUtils.carType()) || (wsdlOverride = serviceRef.getWsdlOverride()) == null) continue;
                wsdlOverriden = true;
                serviceRef.setWsdlOverride(linkedPortComponent.getWebService().getWsdlFileUrl());
            }
            if (jaxwsClient) {
                return;
            }
            if (serviceRef.hasGeneratedServiceInterface()) {
                if (!serviceRef.hasWsdlFile() || !serviceRef.hasMappingFile()) throw new Exception("Deployment error for service-ref " + serviceRef.getName() + ".\nService references with generated service " + "interface must include WSDL and mapping information.");
                codegenRequired = true;
            } else if (serviceRef.hasWsdlFile()) {
                if (!serviceRef.hasMappingFile()) throw new Exception("Deployment error for service-ref " + serviceRef.getName() + ".\nService references with wsdl must also have " + "mapping information.");
                codegenRequired = true;
            }
            if (codegenRequired) {
                com.sun.xml.rpc.spi.tools.CompileTool wscompile;
                ModelInfo modelInfo = this.createModelInfo(serviceRef);
                String[] args = this.createJaxrpcCompileArgs(false, this.hasWebServiceClients);
                this.wscompileForAccept = wscompile = this.rpcFactory.createCompileTool((OutputStream)System.out, "wscompile");
                WsCompile delegate = new WsCompile(wscompile, serviceRef);
                delegate.setModelInfo(modelInfo);
                wscompile.setDelegate((CompileToolDelegate)delegate);
                this.jaxrpc(args, delegate, (Descriptor)serviceRef, this.files);
                if (this.hasWebServiceClients) {
                    this.addArtifactsForAppClient();
                }
            }
            if (!wsdlOverriden) return;
            serviceRef.setWsdlOverride(wsdlOverride);
            return;
        }
        catch (IllegalStateException e) {
            logger.info("Attempting to add artifacts for appClient after artifacts were generated " + e.getMessage());
            return;
        }
        catch (Exception e) {
            RuntimeException re = new RuntimeException(e.getMessage());
            re.initCause(e);
            throw re;
        }
    }

    private void addArtifactsForAppClient() {
        ClientArtifactsManager cArtifactsManager = ClientArtifactsManager.get((DeploymentContext)this.context);
        for (int i = 0; i < this.files.size(); ++i) {
            File file;
            URI artifact;
            URI baseURI = this.context.getScratchDir("ejb").toURI();
            if (cArtifactsManager.contains(baseURI, artifact = baseURI.relativize((file = new File(this.files.get(i))).toURI()))) continue;
            cArtifactsManager.add(baseURI, artifact);
        }
    }

    public void accept(WebService webService) {
        if (this.processServiceReferences) {
            return;
        }
        if (!this.webServiceInContext(webService)) {
            return;
        }
        super.accept(webService);
        try {
            if (new WsUtil().isJAXWSbasedService(webService)) {
                WsUtil wsUtil = new WsUtil();
                Collection endpoints = webService.getEndpoints();
                for (WebServiceEndpoint ep : endpoints) {
                    if (ep.implementedByWebComponent()) {
                        wsUtil.updateServletEndpointRuntime(ep);
                        continue;
                    }
                    wsUtil.validateEjbEndpoint(ep);
                }
            } else {
                this.jaxrpcWebService(webService, this.files);
            }
        }
        catch (Exception e) {
            RuntimeException ge = new RuntimeException(e.getMessage());
            ge.initCause(e);
            throw ge;
        }
    }

    @Override
    public Iterator getListOfBinaryFiles() {
        return this.files.iterator();
    }

    @Override
    public Iterator getListOfSourceFiles() {
        return null;
    }

    @Override
    public void done() {
    }

    private void done(com.sun.xml.rpc.spi.tools.CompileTool wscompile) {
        CompileTool compileTool;
        com.sun.xml.rpc.spi.tools.ProcessorEnvironment env;
        if (wscompile != null && wscompile instanceof CompileTool && (env = (compileTool = (CompileTool)wscompile).getEnvironment()) != null && env instanceof ProcessorEnvironment) {
            ProcessorEnvironment typedEnv = (ProcessorEnvironment)env;
            URLClassLoader urlCL = typedEnv.getClassLoader();
            ClassLoaderUtil.releaseLoader((URLClassLoader)urlCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JaxrpcMappingDescriptor getJaxrpcMappingInfo(URL mappingFileUrl, Descriptor desc) throws Exception {
        JaxrpcMappingDescriptor mappingDesc = null;
        try (InputStream is = null;){
            is = mappingFileUrl.openStream();
            JaxrpcMappingDeploymentDescriptorFile jaxrpcDD = new JaxrpcMappingDeploymentDescriptorFile();
            if (desc instanceof ServiceReferenceDescriptor) {
                ServiceReferenceDescriptor srd = (ServiceReferenceDescriptor)desc;
                jaxrpcDD.setDeploymentDescriptorPath(srd.getMappingFileUri());
                jaxrpcDD.setErrorReportingString(srd.getBundleDescriptor().getModuleDescriptor().getArchiveUri());
            }
            if (desc instanceof WebService) {
                WebService ws = (WebService)desc;
                jaxrpcDD.setDeploymentDescriptorPath(ws.getMappingFileUri());
                jaxrpcDD.setErrorReportingString(ws.getBundleDescriptor().getModuleDescriptor().getArchiveUri());
            }
            jaxrpcDD.setXMLValidationLevel("none");
            mappingDesc = (JaxrpcMappingDescriptor)JaxrpcMappingDescriptor.class.cast(jaxrpcDD.read(is));
        }
        return mappingDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isJaxrpcRIModelFile(URL mappingFileUrl) {
        boolean isModel = false;
        InputStream is = null;
        try {
            is = mappingFileUrl.openStream();
            isModel = this.rpcFactory.createXMLModelFileFilter().isModelFile(is);
        }
        catch (Throwable t) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
        }
        return isModel;
    }

    private ModelInfo createModelInfo(WebService webService) throws Exception {
        ModelFileModelInfo modelInfo = null;
        URL mappingFileUrl = webService.getMappingFile().toURL();
        modelInfo = this.createModelFileModelInfo(mappingFileUrl);
        if (this.isJaxrpcRIModelFile(mappingFileUrl)) {
            this.debug("000. JaxrpcRIModelFile.");
            modelInfo = this.createModelFileModelInfo(mappingFileUrl);
        } else {
            JaxrpcMappingDescriptor mappingDesc = this.getJaxrpcMappingInfo(mappingFileUrl, (Descriptor)webService);
            if (mappingDesc.isSimpleMapping()) {
                this.debug("111. SimpleMapping.");
                modelInfo = this.createNoMetadataModelInfo(webService, mappingDesc);
            } else {
                this.debug("222. FullMapping .");
                modelInfo = this.createFullMappingModelInfo(webService);
            }
        }
        return modelInfo;
    }

    private ModelInfo createModelInfo(ServiceReferenceDescriptor serviceRef) throws Exception {
        JaxrpcMappingDescriptor mappingDesc;
        Object modelInfo = null;
        URL mappingFileUrl = serviceRef.getMappingFile().toURL();
        modelInfo = this.isJaxrpcRIModelFile(mappingFileUrl) ? this.createModelFileModelInfo(mappingFileUrl) : ((mappingDesc = this.getJaxrpcMappingInfo(mappingFileUrl, (Descriptor)serviceRef)).isSimpleMapping() && serviceRef.hasGeneratedServiceInterface() ? this.createNoMetadataModelInfo(serviceRef, mappingDesc) : this.createFullMappingModelInfo(serviceRef));
        return modelInfo;
    }

    private ModelFileModelInfo createModelFileModelInfo(URL modelFileUrl) throws Exception {
        ModelFileModelInfo modelInfo = this.rpcFactory.createModelFileModelInfo();
        modelInfo.setLocation(modelFileUrl.toExternalForm());
        return modelInfo;
    }

    private J2EEModelInfo createFullMappingModelInfo(WebService webService) throws Exception {
        URL mappingFileUrl = webService.getMappingFile().toURL();
        URL wsdlFileUrl = webService.getWsdlFileUrl();
        return this.createFullMappingModelInfo(mappingFileUrl, wsdlFileUrl);
    }

    private J2EEModelInfo createFullMappingModelInfo(ServiceReferenceDescriptor serviceRef) throws Exception {
        URL mappingFileUrl = serviceRef.getMappingFile().toURL();
        URL wsdlFileUrl = serviceRef.hasWsdlOverride() ? serviceRef.getWsdlOverride() : serviceRef.getWsdlFileUrl();
        return this.createFullMappingModelInfo(mappingFileUrl, wsdlFileUrl);
    }

    private J2EEModelInfo createFullMappingModelInfo(URL mappingFile, URL wsdlFile) throws Exception {
        J2EEModelInfo modelInfo = this.rpcFactory.createJ2EEModelInfo(mappingFile);
        modelInfo.setLocation(wsdlFile.toExternalForm());
        modelInfo.setJavaPackageName("package_ignored");
        return modelInfo;
    }

    private NoMetadataModelInfo createNoMetadataModelInfo(WebService webService, JaxrpcMappingDescriptor mappingDesc) throws Exception {
        NoMetadataModelInfo modelInfo = this.rpcFactory.createNoMetadataModelInfo();
        URL wsdlFileUrl = webService.getWsdlFileUrl();
        Collection endpoints = webService.getEndpoints();
        if (endpoints.size() != 1) {
            throw new Exception("Deployment code generation error for webservice " + webService.getName() + ". " + " jaxrpc-mapping-file is required if web service has " + "multiple endpoints");
        }
        WebServiceEndpoint endpoint = (WebServiceEndpoint)endpoints.iterator().next();
        modelInfo.setLocation(wsdlFileUrl.toExternalForm());
        modelInfo.setInterfaceName(endpoint.getServiceEndpointInterface());
        modelInfo.setPortName(endpoint.getWsdlPort());
        this.addNamespaceMappingRegistry(modelInfo, mappingDesc);
        return modelInfo;
    }

    private void addNamespaceMappingRegistry(NoMetadataModelInfo modelInfo, JaxrpcMappingDescriptor mappingDesc) {
        NamespaceMappingRegistryInfo namespaceRegistry = this.rpcFactory.createNamespaceMappingRegistryInfo();
        modelInfo.setNamespaceMappingRegistry(namespaceRegistry);
        Collection mappings = mappingDesc.getMappings();
        for (JaxrpcMappingDescriptor.Mapping next : mappings) {
            NamespaceMappingInfo namespaceInfo = this.rpcFactory.createNamespaceMappingInfo(next.getNamespaceUri(), next.getPackage());
            namespaceRegistry.addMapping(namespaceInfo);
        }
    }

    private NoMetadataModelInfo createNoMetadataModelInfo(ServiceReferenceDescriptor serviceRef, JaxrpcMappingDescriptor mappingDesc) throws Exception {
        Class<?> serviceInterface;
        Collection seis;
        NoMetadataModelInfo modelInfo = this.rpcFactory.createNoMetadataModelInfo();
        URL wsdlFile = serviceRef.hasWsdlOverride() ? serviceRef.getWsdlOverride() : serviceRef.getWsdlFileUrl();
        modelInfo.setLocation(wsdlFile.toExternalForm());
        WsUtil wsUtil = new WsUtil();
        String serviceInterfaceName = serviceRef.getServiceInterface();
        ClassLoader cl = ((Application)this.context.getModuleMetaData(Application.class)).getClassLoader();
        if (cl instanceof ASURLClassLoader) {
            String modClassPath = ASClassLoaderUtil.getModuleClassPath((ServiceLocator)this.habitat, (DeploymentContext)this.context);
            List moduleList = ASClassLoaderUtil.getURLsFromClasspath((String)modClassPath, (String)File.pathSeparator, null);
            Iterator itr = moduleList.iterator();
            while (itr.hasNext()) {
                ((ASURLClassLoader)cl).appendURL((URL)itr.next());
            }
        }
        if ((seis = wsUtil.getSEIsFromGeneratedService(serviceInterface = cl.loadClass(serviceInterfaceName))).size() == 0) {
            throw new Exception("Invalid Generated Service Interface " + serviceInterfaceName + " . ");
        }
        if (seis.size() > 1) {
            throw new Exception("Deployment error : If no jaxrpc-mapping file is provided, Generated Service Interface must have only 1 Service Endpoint Interface");
        }
        String serviceEndpointInterface = (String)seis.iterator().next();
        modelInfo.setInterfaceName(serviceEndpointInterface);
        this.addNamespaceMappingRegistry(modelInfo, mappingDesc);
        return modelInfo;
    }

    private boolean keepJaxrpcGeneratedFile(String fileType, Descriptor desc) {
        boolean keep = true;
        if (fileType.equals("Wsdl") || fileType.equals("RemoteInterface")) {
            keep = false;
        } else if (fileType.equals("Service")) {
            keep = desc instanceof ServiceReferenceDescriptor && ((ServiceReferenceDescriptor)desc).hasGenericServiceInterface();
        }
        return keep;
    }

    private String[] createJaxrpcCompileArgs(boolean generateTies, boolean forceRegen) throws IOException {
        String moduleBasePath;
        String moduleWebInfPath;
        File moduleWebInfFile;
        String optionalDependencyClassPath;
        int numJaxrpcArgs = 11;
        if (logger.isLoggable(Level.FINE)) {
            numJaxrpcArgs = 16;
        }
        if (forceRegen) {
            --numJaxrpcArgs;
        }
        ++this.wscompileInvocationCount;
        String infix = null;
        if (this.wscompileInvocationCount > 1) {
            ++numJaxrpcArgs;
            infix = this.wscompileInvocationCount + "";
        }
        String[] jaxrpcArgs = new String[numJaxrpcArgs];
        int jaxrpcCnt = 0;
        if (this.dummyConfigFile == null) {
            this.dummyConfigFile = File.createTempFile("dummy_wscompile_config", "config");
            this.dummyConfigFile.deleteOnExit();
        }
        if ((optionalDependencyClassPath = InstalledLibrariesResolver.getExtDirFilesAsClasspath()).length() > 0) {
            this.moduleClassPath = optionalDependencyClassPath + File.pathSeparatorChar + this.moduleClassPath;
        }
        this.moduleClassPath = (moduleWebInfFile = new File(moduleWebInfPath = (moduleBasePath = this.context.getSourceDir().getAbsolutePath()) + File.separatorChar + "WEB-INF" + File.separatorChar + "classes")).exists() ? moduleWebInfPath + File.pathSeparatorChar + this.moduleClassPath : moduleBasePath + File.pathSeparatorChar + this.moduleClassPath;
        if (!this.context.getScratchDir("ejb").mkdirs() && logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "AS-WSJSR109IMPL-00093", this.context.getScratchDir("ejb"));
        }
        String string = jaxrpcArgs[jaxrpcCnt++] = generateTies ? "-gen:server" : "-gen:client";
        if (!forceRegen) {
            jaxrpcArgs[jaxrpcCnt++] = "-f:donotoverride";
        }
        if (infix != null) {
            jaxrpcArgs[jaxrpcCnt++] = "-f:infix:" + infix;
        }
        jaxrpcArgs[jaxrpcCnt++] = "-classpath";
        jaxrpcArgs[jaxrpcCnt++] = this.moduleClassPath;
        if (logger.isLoggable(Level.FINE)) {
            long timeStamp = System.currentTimeMillis();
            jaxrpcArgs[jaxrpcCnt++] = "-Xdebugmodel:" + this.context.getScratchDir("ejb") + File.separator + "debugModel.txt." + timeStamp;
            jaxrpcArgs[jaxrpcCnt++] = "-Xprintstacktrace";
            jaxrpcArgs[jaxrpcCnt++] = "-model";
            jaxrpcArgs[jaxrpcCnt++] = this.context.getScratchDir("ejb") + File.separator + "debugModel.model" + timeStamp;
            jaxrpcArgs[jaxrpcCnt++] = "-verbose";
        }
        jaxrpcArgs[jaxrpcCnt++] = "-s";
        jaxrpcArgs[jaxrpcCnt++] = this.context.getScratchDir("ejb").getAbsolutePath();
        jaxrpcArgs[jaxrpcCnt++] = "-d";
        jaxrpcArgs[jaxrpcCnt++] = this.context.getScratchDir("ejb").getAbsolutePath();
        jaxrpcArgs[jaxrpcCnt++] = "-keep";
        jaxrpcArgs[jaxrpcCnt++] = "-g";
        jaxrpcArgs[jaxrpcCnt++] = this.dummyConfigFile.getPath();
        if (logger.isLoggable(Level.FINE)) {
            for (int i = 0; i < jaxrpcArgs.length; ++i) {
                logger.fine(jaxrpcArgs[i]);
            }
        }
        return jaxrpcArgs;
    }

    private void jaxrpc(String[] args, WsCompile wsCompile, Descriptor desc, ArrayList<String> files) throws Exception {
        block6: {
            try {
                if (logger.isLoggable(Level.FINE)) {
                    this.debug("---> ARGS = ");
                    for (int i = 0; i < args.length; ++i) {
                        logger.fine(args[i] + "; ");
                    }
                }
                boolean compiled = wsCompile.getCompileTool().run(args);
                this.done(wsCompile.getCompileTool());
                if (compiled) {
                    for (GeneratedFileInfo next : wsCompile.getGeneratedFiles()) {
                        String fileType = next.getType();
                        File file = next.getFile();
                        String origPath = file.getPath();
                        if (!origPath.endsWith(".java")) continue;
                        int javaIndex = origPath.lastIndexOf(".java");
                        String newPath = origPath.substring(0, javaIndex) + ".class";
                        if (!this.keepJaxrpcGeneratedFile(fileType, desc)) continue;
                        files.add(newPath);
                    }
                    break block6;
                }
                throw new Exception("jaxrpc compilation exception");
            }
            catch (Throwable t) {
                Exception ge = new Exception(t.getMessage());
                ge.initCause(t);
                throw ge;
            }
        }
    }

    private void jaxrpcWebService(WebService webService, ArrayList<String> files) throws Exception {
        com.sun.xml.rpc.spi.tools.CompileTool wscompile;
        if (webService.getWsdlFileUrl() == null || webService.getMappingFileUri() == null) {
            throw new Exception(localStrings.getLocalString("enterprise.webservice.jaxrpcFilesNotFound", "Service {0} seems to be a JAXRPC based web service but without the mandatory WSDL and Mapping file. Deployment cannot proceed", new Object[]{webService.getName()}));
        }
        ModelInfo modelInfo = this.createModelInfo(webService);
        String[] args = this.createJaxrpcCompileArgs(true, false);
        this.wscompileForWebServices = wscompile = this.rpcFactory.createCompileTool((OutputStream)System.out, "wscompile");
        WsCompile delegate = new WsCompile(wscompile, webService);
        delegate.setModelInfo(modelInfo);
        wscompile.setDelegate((CompileToolDelegate)delegate);
        this.jaxrpc(args, delegate, (Descriptor)webService, files);
    }

    private void debug(String msg) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("[JaxRpcRICodegen] --> " + msg);
        }
    }

    private boolean webServiceInContext(WebService webService) {
        BundleDescriptor contextBundleDescriptor = (BundleDescriptor)this.context.getModuleMetaData(BundleDescriptor.class);
        String moduleId = contextBundleDescriptor.getModuleID();
        return moduleId.equals(webService.getBundleDescriptor().getModuleID());
    }

    public void accept(BundleDescriptor descriptor) {
        if (descriptor instanceof Application) {
            Application application = (Application)descriptor;
            for (BundleDescriptor ebd : application.getBundleDescriptorsOfType(DOLUtils.ejbType())) {
                ebd.visit(this.getSubDescriptorVisitor((Descriptor)ebd));
            }
            for (BundleDescriptor wbd : application.getBundleDescriptorsOfType(DOLUtils.warType())) {
                if (wbd == null) continue;
                wbd.visit(this.getSubDescriptorVisitor((Descriptor)wbd));
            }
            for (BundleDescriptor acd : application.getBundleDescriptorsOfType(DOLUtils.carType())) {
                acd.visit(this.getSubDescriptorVisitor((Descriptor)acd));
            }
        } else {
            super.accept(descriptor);
        }
    }

    public void accept(Application application) {
    }

    public void accept(EjbBundleDescriptor bundleDescriptor) {
    }

    public void accept(ApplicationClientDescriptor appclientdescriptor) {
    }

    public void accept(WebBundleDescriptor descriptor) {
    }
}

