/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.xml.rpc.spi.JaxRpcObjectFactory;
import com.sun.xml.rpc.spi.runtime.ImplementorCache;
import com.sun.xml.rpc.spi.runtime.ImplementorCacheDelegate;
import com.sun.xml.rpc.spi.runtime.RuntimeEndpointInfo;
import com.sun.xml.rpc.spi.runtime.ServletDelegate;
import com.sun.xml.rpc.spi.runtime.ServletSecondDelegate;
import com.sun.xml.rpc.spi.runtime.SystemHandlerDelegate;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.WebServiceException;
import org.glassfish.internal.api.Globals;
import org.glassfish.webservices.ImplementorCacheDelegateImpl;
import org.glassfish.webservices.LogUtils;
import org.glassfish.webservices.SecurityService;
import org.glassfish.webservices.WebServiceContractImpl;
import org.glassfish.webservices.WsUtil;
import org.glassfish.webservices.monitoring.JAXRPCEndpointImpl;
import org.glassfish.webservices.monitoring.WebServiceEngineImpl;

public class ServletWebServiceDelegate
extends ServletSecondDelegate {
    private static final Logger logger = LogUtils.getLogger();
    private WebServiceEndpoint endpoint_;
    private ServletDelegate rpcDelegate_;
    private JaxRpcObjectFactory rpcFactory_;
    private WebServiceEngineImpl wsEngine_;
    private JAXRPCEndpointImpl endpointImpl_;
    private SecurityService secServ;

    public ServletWebServiceDelegate(ServletDelegate firstDelegate) {
        this.rpcDelegate_ = firstDelegate;
        this.rpcFactory_ = JaxRpcObjectFactory.newInstance();
        this.wsEngine_ = WebServiceEngineImpl.getInstance();
        if (Globals.getDefaultHabitat() != null) {
            this.secServ = (SecurityService)Globals.get(SecurityService.class);
        }
    }

    public void postInit(ServletConfig servletConfig) throws ServletException {
        block5: {
            String servletName = "unknown";
            try {
                WebServiceContractImpl wscImpl = WebServiceContractImpl.getInstance();
                ComponentEnvManager compEnvManager = wscImpl.getComponentEnvManager();
                JndiNameEnvironment jndiNameEnv = compEnvManager.getCurrentJndiNameEnvironment();
                WebBundleDescriptor webBundle = null;
                if (jndiNameEnv == null || !(jndiNameEnv instanceof WebBundleDescriptor)) {
                    throw new WebServiceException("Cannot intialize the JAXRPCServlet for " + jndiNameEnv);
                }
                webBundle = (WebBundleDescriptor)jndiNameEnv;
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                servletName = servletConfig.getServletName();
                WebComponentDescriptor webComponent = webBundle.getWebComponentByCanonicalName(servletName);
                if (webComponent != null) {
                    SystemHandlerDelegate securityHandlerDelegate;
                    WebServicesDescriptor webServices = webBundle.getWebServices();
                    Collection endpoints = webServices.getEndpointsImplementedBy(webComponent);
                    this.endpoint_ = (WebServiceEndpoint)endpoints.iterator().next();
                    this.registerEndpoint(classLoader);
                    if (this.secServ != null && (securityHandlerDelegate = this.secServ.getSecurityHandler(this.endpoint_)) != null) {
                        this.rpcDelegate_.setSystemHandlerDelegate(securityHandlerDelegate);
                        this.endpointImpl_ = (JAXRPCEndpointImpl)JAXRPCEndpointImpl.class.cast(this.wsEngine_.createHandler(securityHandlerDelegate, this.endpoint_));
                        this.rpcDelegate_.setSystemHandlerDelegate((SystemHandlerDelegate)this.endpointImpl_);
                    }
                    break block5;
                }
                throw new ServletException(servletName + " not found");
            }
            catch (Throwable t) {
                String msg = MessageFormat.format(logger.getResourceBundle().getString("AS-WSJSR109IMPL-00078"), servletName);
                logger.log(Level.WARNING, msg, t);
                throw new ServletException(t);
            }
        }
    }

    public void destroy() {
        this.wsEngine_.removeHandler(this.endpoint_);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        WsUtil wsUtil = new WsUtil();
        try {
            wsUtil.handleGet(request, response, this.endpoint_);
        }
        catch (Exception e) {
            String msg = MessageFormat.format(logger.getResourceBundle().getString("AS-WSJSR109IMPL-00081"), this.endpoint_.getEndpointName());
            logger.log(Level.WARNING, msg, e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.rpcDelegate_.doPost(request, response);
    }

    public void warnMissingContextInformation() {
    }

    public ImplementorCache createImplementorCache(ServletConfig sc) {
        ImplementorCache ic = this.rpcFactory_.createImplementorCache(sc);
        ImplementorCacheDelegateImpl delegate = new ImplementorCacheDelegateImpl(sc);
        ic.setDelegate((ImplementorCacheDelegate)delegate);
        return ic;
    }

    private void registerEndpoint(ClassLoader loader) throws Exception {
        RuntimeEndpointInfo endpointInfo = this.rpcFactory_.createRuntimeEndpointInfo();
        Class<?> serviceEndpointInterfaceClass = loader.loadClass(this.endpoint_.getServiceEndpointInterface());
        Class<?> implementationClass = loader.loadClass(this.endpoint_.getServletImplClass());
        String tieClassName = this.endpoint_.getTieClassName();
        if (tieClassName != null) {
            Class<?> tieClass = loader.loadClass(tieClassName);
            endpointInfo.setTieClass(tieClass);
        }
        endpointInfo.setRemoteInterface(serviceEndpointInterfaceClass);
        endpointInfo.setImplementationClass(implementationClass);
        endpointInfo.setName(this.endpoint_.getEndpointName());
        endpointInfo.setDeployed(true);
        endpointInfo.setPortName(this.endpoint_.getWsdlPort());
        endpointInfo.setServiceName(this.endpoint_.getServiceName());
        String uri = this.endpoint_.getEndpointAddressUri();
        uri = uri.startsWith("/") ? uri : "/" + uri;
        endpointInfo.setUrlPattern(uri);
        this.rpcDelegate_.registerEndpointUrlPattern(endpointInfo);
    }
}

