/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.xml.ws.api.server.Adapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.webservices.LogUtils;

public class JAXWSAdapterRegistry {
    private static JAXWSAdapterRegistry registry = null;
    private final Map<String, ContextAdapter> store = Collections.synchronizedMap(new HashMap());
    private static final Logger logger = LogUtils.getLogger();

    private JAXWSAdapterRegistry() {
    }

    public static synchronized JAXWSAdapterRegistry getInstance() {
        if (registry == null) {
            registry = new JAXWSAdapterRegistry();
        }
        return registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAdapter(String contextRoot, String urlPattern, Adapter info) {
        if (contextRoot == null) {
            contextRoot = "";
        }
        Map<String, ContextAdapter> map = this.store;
        synchronized (map) {
            ContextAdapter contextRtInfo = this.store.get(contextRoot);
            if (contextRtInfo == null) {
                contextRtInfo = new ContextAdapter();
            }
            contextRtInfo.addAdapter(urlPattern, info);
            this.store.put(contextRoot, contextRtInfo);
        }
    }

    public Adapter getAdapter(String contextRoot, String path, String urlPattern) {
        ContextAdapter serviceInfo = this.store.get(contextRoot);
        if (serviceInfo == null) {
            return null;
        }
        return serviceInfo.getAdapter(path, urlPattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAdapter(String contextRoot) {
        if (contextRoot == null) {
            contextRoot = "";
        }
        Map<String, ContextAdapter> map = this.store;
        synchronized (map) {
            ContextAdapter serviceInfo = this.store.get(contextRoot);
            if (serviceInfo == null) {
                return;
            }
            this.store.remove(contextRoot);
        }
    }

    class ContextAdapter {
        final Map<String, Adapter> fixedUrlPatternEndpoints = Collections.synchronizedMap(new HashMap());
        final List<Adapter> pathUrlPatternEndpoints = Collections.synchronizedList(new ArrayList());

        ContextAdapter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addAdapter(String urlPattern, Adapter info) {
            if (urlPattern.indexOf("*.") != -1) {
                logger.log(Level.SEVERE, "AS-WSJSR109IMPL-00033");
            } else if (urlPattern.endsWith("/*")) {
                this.pathUrlPatternEndpoints.add(info);
            } else {
                Map<String, Adapter> map = this.fixedUrlPatternEndpoints;
                synchronized (map) {
                    if (this.fixedUrlPatternEndpoints.containsKey(urlPattern)) {
                        logger.log(Level.SEVERE, "AS-WSJSR109IMPL-00034", urlPattern);
                    }
                    this.fixedUrlPatternEndpoints.put(urlPattern, info);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Adapter getAdapter(String path, String urlPattern) {
            Adapter result = this.fixedUrlPatternEndpoints.get(path);
            if (result == null) {
                List<Adapter> list = this.pathUrlPatternEndpoints;
                synchronized (list) {
                    for (Adapter candidate : this.pathUrlPatternEndpoints) {
                        if (!path.startsWith(this.getValidPathForEndpoint(urlPattern))) continue;
                        result = candidate;
                        break;
                    }
                }
            }
            return result;
        }

        private String getValidPathForEndpoint(String s) {
            if (s.endsWith("/*")) {
                return s.substring(0, s.length() - 2);
            }
            return s;
        }
    }
}

