/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import org.glassfish.webservices.WebServiceDeploymentListener;
import org.glassfish.webservices.WebServiceDeploymentNotifier;

public final class WebServiceDeploymentNotifierImpl
implements WebServiceDeploymentNotifier {
    private final Collection<WebServiceDeploymentListener> listeners = new CopyOnWriteArraySet<WebServiceDeploymentListener>();

    public void addListener(WebServiceDeploymentListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(WebServiceDeploymentListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyDeployed(WebServiceEndpoint nextEndpoint) {
        for (WebServiceDeploymentListener listener : this.listeners) {
            listener.onDeployed(nextEndpoint);
        }
    }

    public void notifyUndeployed(WebServiceEndpoint nextEndpoint) {
        for (WebServiceDeploymentListener listener : this.listeners) {
            listener.onUndeployed(nextEndpoint);
        }
    }
}

