/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.api.client.ServiceInterceptor;
import com.sun.xml.ws.developer.WSBindingProvider;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.Binding;
import javax.xml.ws.soap.SOAPBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortCreationCallbackImpl
extends ServiceInterceptor {
    private ServiceReferenceDescriptor ref;
    private static Logger logger = LogDomains.getLogger(PortCreationCallbackImpl.class, (String)"javax.enterprise.webservices");

    public PortCreationCallbackImpl(ServiceReferenceDescriptor svcRef) {
        this.ref = svcRef;
    }

    public void postCreateProxy(WSBindingProvider bp, Class<?> serviceEndpointInterface) {
        ServiceRefPortInfo portInfo = this.ref.getPortInfoBySEI(serviceEndpointInterface.getName());
        if (portInfo != null) {
            boolean mtomEnabled = false;
            if (portInfo.getMtomEnabled() != null && new Boolean(portInfo.getMtomEnabled()).booleanValue()) {
                mtomEnabled = true;
            }
            if (mtomEnabled) {
                Binding bType = bp.getBinding();
                if (SOAPBinding.class.isAssignableFrom(bType.getClass())) {
                    ((SOAPBinding)bType).setMTOMEnabled(true);
                } else {
                    logger.log(Level.SEVERE, "serviceref.invalidmtom");
                }
            }
            Set properties = portInfo.getStubProperties();
            for (NameValuePairDescriptor next : properties) {
                bp.getRequestContext().put(next.getName(), next.getValue());
            }
        }
    }

    public void postCreateDispatch(WSBindingProvider bp) {
    }
}

